/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ResourceIdNode extends ImplicitNode {

	public ResourceIdNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Sets the Resource that the resourceid attribute of the node will point to
	 *
	 * @param resource the resource
	 * @throws Lib3MFException
	 */
	public void setResource(Resource resource) throws Lib3MFException {
		Pointer resourceHandle = null;
		if (resource != null) {
			resourceHandle = resource.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Resource is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_resourceidnode_setresource.invokeInt(new java.lang.Object[]{mHandle, resourceHandle}));
	}

	/**
	 * Retrieves the resource of the node
	 *
	 * @return the resource
	 * @throws Lib3MFException
	 */
	public Resource getResource() throws Lib3MFException {
		Pointer bufferResource = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_resourceidnode_getresource.invokeInt(new java.lang.Object[]{mHandle, bufferResource}));
		Pointer valueResource = bufferResource.getPointer(0);
		Resource resource = null;
		if (valueResource == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Resource was a null pointer");
		}
		resource = mWrapper.PolymorphicFactory(valueResource, Resource.class);
		return resource;
	}

	/**
	 * Retrieves the output
	 *
	 * @return the output
	 * @throws Lib3MFException
	 */
	public ImplicitPort getOutputValue() throws Lib3MFException {
		Pointer bufferValue = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_resourceidnode_getoutputvalue.invokeInt(new java.lang.Object[]{mHandle, bufferValue}));
		Pointer valueValue = bufferValue.getPointer(0);
		ImplicitPort value = null;
		if (valueValue == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "Value was a null pointer");
		}
		value = mWrapper.PolymorphicFactory(valueValue, ImplicitPort.class);
		return value;
	}


}

