/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class ImplicitPort extends Base {

	public ImplicitPort(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the identifier of the port
	 *
	 * @return the identifier
	 * @throws Lib3MFException
	 */
	public String getIdentifier() throws Lib3MFException {
		Pointer bytesNeededIdentifier = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_getidentifier.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededIdentifier, null}));
		int sizeIdentifier = bytesNeededIdentifier.getInt(0);
		Pointer bufferIdentifier = new Memory(sizeIdentifier);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_getidentifier.invokeInt(new java.lang.Object[]{mHandle, sizeIdentifier, bytesNeededIdentifier, bufferIdentifier}));
		return new String(bufferIdentifier.getByteArray(0, sizeIdentifier - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the identifier of the port
	 *
	 * @param identifier the identifier
	 * @throws Lib3MFException
	 */
	public void setIdentifier(String identifier) throws Lib3MFException {
		byte[] bytesIdentifier = identifier.getBytes(StandardCharsets.UTF_8);
		Memory bufferIdentifier = new Memory(bytesIdentifier.length + 1);
		bufferIdentifier.write(0, bytesIdentifier, 0, bytesIdentifier.length);
		bufferIdentifier.setByte(bytesIdentifier.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_setidentifier.invokeInt(new java.lang.Object[]{mHandle, bufferIdentifier}));
	}

	/**
	 * Retrieves the display name of the port
	 *
	 * @return the display name
	 * @throws Lib3MFException
	 */
	public String getDisplayName() throws Lib3MFException {
		Pointer bytesNeededDisplayName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_getdisplayname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededDisplayName, null}));
		int sizeDisplayName = bytesNeededDisplayName.getInt(0);
		Pointer bufferDisplayName = new Memory(sizeDisplayName);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_getdisplayname.invokeInt(new java.lang.Object[]{mHandle, sizeDisplayName, bytesNeededDisplayName, bufferDisplayName}));
		return new String(bufferDisplayName.getByteArray(0, sizeDisplayName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the display name of the port
	 *
	 * @param displayName the display name
	 * @throws Lib3MFException
	 */
	public void setDisplayName(String displayName) throws Lib3MFException {
		byte[] bytesDisplayName = displayName.getBytes(StandardCharsets.UTF_8);
		Memory bufferDisplayName = new Memory(bytesDisplayName.length + 1);
		bufferDisplayName.write(0, bytesDisplayName, 0, bytesDisplayName.length);
		bufferDisplayName.setByte(bytesDisplayName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_setdisplayname.invokeInt(new java.lang.Object[]{mHandle, bufferDisplayName}));
	}

	/**
	 * Sets the type of the port
	 *
	 * @param implicitPortType the type
	 * @throws Lib3MFException
	 */
	public void setType(Lib3MFWrapper.ImplicitPortType implicitPortType) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_settype.invokeInt(new java.lang.Object[]{mHandle, Lib3MFWrapper.EnumConversion.convertImplicitPortTypeToConst(implicitPortType)}));
	}

	/**
	 * Retrieves the type of the port
	 *
	 * @return the type
	 * @throws Lib3MFException
	 */
	public Lib3MFWrapper.ImplicitPortType getType() throws Lib3MFException {
		Pointer bufferImplicitPortType = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_gettype.invokeInt(new java.lang.Object[]{mHandle, bufferImplicitPortType}));
		return Lib3MFWrapper.EnumConversion.convertConstToImplicitPortType(bufferImplicitPortType.getInt(0));
	}

	/**
	 * Retrieves the reference of the port, only used for input ports
	 *
	 * @return the reference
	 * @throws Lib3MFException
	 */
	public String getReference() throws Lib3MFException {
		Pointer bytesNeededReference = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_getreference.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededReference, null}));
		int sizeReference = bytesNeededReference.getInt(0);
		Pointer bufferReference = new Memory(sizeReference);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_getreference.invokeInt(new java.lang.Object[]{mHandle, sizeReference, bytesNeededReference, bufferReference}));
		return new String(bufferReference.getByteArray(0, sizeReference - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the reference of the port, only used for input ports
	 *
	 * @param reference the reference
	 * @throws Lib3MFException
	 */
	public void setReference(String reference) throws Lib3MFException {
		byte[] bytesReference = reference.getBytes(StandardCharsets.UTF_8);
		Memory bufferReference = new Memory(bytesReference.length + 1);
		bufferReference.write(0, bytesReference, 0, bytesReference.length);
		bufferReference.setByte(bytesReference.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_implicitport_setreference.invokeInt(new java.lang.Object[]{mHandle, bufferReference}));
	}


}

