/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.util.Collection;
import org.hibernate.engine.internal.NaturalIdLogging;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;

public class NaturalIdHelper {
    public static String[] getNaturalIdPropertyNames(EntityPersister persister) {
        int[] naturalIdPropertyIndices = persister.getNaturalIdentifierProperties();
        if (naturalIdPropertyIndices == null) {
            throw new IdentifierGenerationException("Entity '" + persister.getEntityName() + "' has no '@NaturalId' property");
        }
        if (persister.getEntityMetamodel().isNaturalIdentifierInsertGenerated()) {
            throw new IdentifierGenerationException("Entity '" + persister.getEntityName() + "' has a '@NaturalId' property which is also defined as insert-generated");
        }
        String[] allPropertyNames = persister.getPropertyNames();
        String[] propertyNames = new String[naturalIdPropertyIndices.length];
        for (int i = 0; i < naturalIdPropertyIndices.length; ++i) {
            propertyNames[i] = allPropertyNames[naturalIdPropertyIndices[i]];
        }
        return propertyNames;
    }

    public static void performAnyNeededCrossReferenceSynchronizations(boolean synchronizationEnabled, EntityMappingType entityMappingType, SharedSessionContractImplementor session) {
        if (synchronizationEnabled && entityMappingType.getNaturalIdMapping().isMutable() && session.isTransactionInProgress()) {
            EntityPersister entityPersister = entityMappingType.getEntityPersister();
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            Collection<?> cachedResolutions = persistenceContext.getNaturalIdResolutions().getCachedPkResolutions(entityPersister);
            boolean loggerDebugEnabled = NaturalIdLogging.NATURAL_ID_LOGGER.isDebugEnabled();
            for (Object id : cachedResolutions) {
                EntityKey entityKey = session.generateEntityKey(id, entityPersister);
                Object entity = persistenceContext.getEntity(entityKey);
                EntityEntry entry = persistenceContext.getEntry(entity);
                if (entry != null) {
                    if (!entry.requiresDirtyCheck(entity) || entry.getStatus() != Status.MANAGED) continue;
                    persistenceContext.getNaturalIdResolutions().handleSynchronization(id, entity, entityPersister);
                    continue;
                }
                if (!loggerDebugEnabled) continue;
                NaturalIdLogging.NATURAL_ID_LOGGER.debugf("Cached natural-id/pk resolution linked to missing EntityEntry in persistence context: %s#%s", (Object)entityMappingType.getEntityName(), id);
            }
        }
    }
}

