/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.theme.KeycloakSanitizerPolicy;
import org.owasp.html.Encoding;

public class KeycloakSanitizerMethod
implements TemplateMethodModelEx {
    private static final Pattern HREF_PATTERN = Pattern.compile("\\s+href=\"([^\"]*)\"");

    public Object exec(List list) throws TemplateModelException {
        if (list.isEmpty() || list.get(0) == null) {
            throw new NullPointerException("Can not escape null value.");
        }
        String html = list.get(0).toString();
        html = this.decodeHtmlFull(html);
        String sanitized = KeycloakSanitizerPolicy.POLICY_DEFINITION.sanitize(html);
        return this.fixURLs(sanitized);
    }

    private String decodeHtmlFull(String html) {
        if (html == null) {
            return null;
        }
        int MAX_DECODING_COUNT = 5;
        for (int i = 0; i < MAX_DECODING_COUNT; ++i) {
            String decodedHtml = Encoding.decodeHtml((String)html);
            if (decodedHtml.equals(html)) {
                return html;
            }
            html = decodedHtml;
        }
        return "";
    }

    private String fixURLs(String msg) {
        Matcher matcher = HREF_PATTERN.matcher(msg);
        if (matcher.find()) {
            int last = 0;
            StringBuilder result = new StringBuilder(msg.length());
            do {
                String href = matcher.group(1).replaceAll("&#61;", "=").replaceAll("\\.\\.", ".").replaceAll("&amp;", "&");
                result.append(msg.substring(last, matcher.start(1))).append(href);
                last = matcher.end(1);
            } while (matcher.find());
            result.append(msg.substring(last));
            return result.toString();
        }
        return msg;
    }
}

