/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Transient;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedGrant;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CredentialsOffer {
    @JsonProperty(value="credential_issuer")
    private String credentialIssuer;
    @JsonProperty(value="credential_configuration_ids")
    private List<String> credentialConfigurationIds;
    private PreAuthorizedGrant grants;

    public String getCredentialIssuer() {
        return this.credentialIssuer;
    }

    public CredentialsOffer setCredentialIssuer(String credentialIssuer) {
        this.credentialIssuer = credentialIssuer;
        return this;
    }

    @Transient
    public String getIssuerMetadataUrl() {
        KeycloakUriBuilder metadataUrl = KeycloakUriBuilder.fromUri((String)this.credentialIssuer).path("/.well-known/openid-credential-issuer");
        int idx = this.credentialIssuer.indexOf("/realms");
        if (idx > 0) {
            String baseUrl = this.credentialIssuer.substring(0, idx);
            String realmPath = this.credentialIssuer.substring(idx);
            metadataUrl = KeycloakUriBuilder.fromUri((String)baseUrl).path("/.well-known/openid-credential-issuer").path(realmPath);
        }
        return metadataUrl.buildAsString(new Object[0]);
    }

    public List<String> getCredentialConfigurationIds() {
        return this.credentialConfigurationIds;
    }

    public CredentialsOffer setCredentialConfigurationIds(List<String> credentialConfigurationIds) {
        this.credentialConfigurationIds = Collections.unmodifiableList(credentialConfigurationIds);
        return this;
    }

    public PreAuthorizedGrant getGrants() {
        return this.grants;
    }

    public CredentialsOffer setGrants(PreAuthorizedGrant grants) {
        this.grants = grants;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CredentialsOffer)) {
            return false;
        }
        CredentialsOffer that = (CredentialsOffer)o;
        return Objects.equals(this.getCredentialIssuer(), that.getCredentialIssuer()) && Objects.equals(this.getCredentialConfigurationIds(), that.getCredentialConfigurationIds()) && Objects.equals(this.getGrants(), that.getGrants());
    }

    public int hashCode() {
        return Objects.hash(this.getCredentialIssuer(), this.getCredentialConfigurationIds(), this.getGrants());
    }
}

