/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.DataPlaneAcceptor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.network.ConnectionDisconnectListener;
import org.apache.kafka.server.util.FutureUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r=c\u0001B&M\u0001EC\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005M\"A!\u000e\u0001BC\u0002\u0013\u00051\u000e\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003m\u0011!I\bA!b\u0001\n\u0003Q\b\"CA\u0001\u0001\t\u0005\t\u0015!\u0003|\u0011)\t\u0019\u0001\u0001BC\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003'\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\u000b\u0001\t\u0015\r\u0011\"\u0001\u0002\u0018!Q\u00111\u0005\u0001\u0003\u0002\u0003\u0006I!!\u0007\t\u0015\u0005\u0015\u0002A!b\u0001\n\u0003\t9\u0003\u0003\u0006\u00020\u0001\u0011\t\u0011)A\u0005\u0003SA!\"!\r\u0001\u0005\u000b\u0007I\u0011AA\u001a\u0011)\tY\u0005\u0001B\u0001B\u0003%\u0011Q\u0007\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA4\u0011%\tI\b\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA4\u0011%\ti\b\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BAA\u0011%\ti\t\u0001b\u0001\n\u0013\ty\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAI\u0011%\tI\n\u0001b\u0001\n#\tY\n\u0003\u0005\u0002$\u0002\u0001\u000b\u0011BAO\u0011%\t)\u000b\u0001b\u0001\n\u0013\t9\u000b\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAU\u0011%\t\t\f\u0001b\u0001\n\u0013\t\u0019\f\u0003\u0005\u0002<\u0002\u0001\u000b\u0011BA[\u0011%\ti\f\u0001b\u0001\n\u0013\ty\f\u0003\u0005\u0002J\u0002\u0001\u000b\u0011BAa\u0011%\tY\r\u0001b\u0001\n\u0013\ty\f\u0003\u0005\u0002N\u0002\u0001\u000b\u0011BAa\u0011%\ty\r\u0001b\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002`\u0002\u0001\u000b\u0011BAj\u0011)\t\t\u000f\u0001b\u0001\n\u0003a\u00151\u001d\u0005\t\u0005\u0003\u0001\u0001\u0015!\u0003\u0002f\"I!1\u0001\u0001C\u0002\u0013\u0005!Q\u0001\u0005\t\u0005\u001b\u0001\u0001\u0015!\u0003\u0003\b!A!q\u0002\u0001!\u0002\u0013\u0011\t\u0002C\u0005\u0003\u001e\u0001\u0011\r\u0011\"\u0001\u0003 !A!q\u0005\u0001!\u0002\u0013\u0011\t\u0003C\u0005\u0003*\u0001\u0011\r\u0011\"\u0003\u0003,!A!\u0011\b\u0001!\u0002\u0013\u0011i\u0003C\u0005\u0003<\u0001\u0001\r\u0011\"\u0003\u0003>!I!Q\t\u0001A\u0002\u0013%!q\t\u0005\t\u0005'\u0002\u0001\u0015)\u0003\u0003@!9!q\u0002\u0001\u0005\u0002\tU\u0003b\u0002B,\u0001\u0011\u0005!\u0011\f\u0005\b\u0005K\u0002A\u0011\u0002B4\u0011\u001d\u0011i\u0007\u0001C\u0005\u0005_BqA!\"\u0001\t#\u00119\tC\u0004\u0003\u0016\u0002!\tAa&\t\u000f\te\u0005\u0001\"\u0001\u0003\u0018\"9!1\u0014\u0001\u0005\u0002\tu\u0005b\u0002BR\u0001\u0011\u0005!Q\u0015\u0005\b\u0005[\u0003A\u0011\u0001BX\u0011\u001d\u0011)\f\u0001C!\u0005oCqAa5\u0001\t\u0003\u0012)\u000eC\u0004\u0003\\\u0002!\tE!8\t\u0011\t\u0015\b\u0001\"\u0001M\u0005ODqA!?\u0001\t\u0003\u0011YpB\u0004\u0004\u00061C\taa\u0002\u0007\r-c\u0005\u0012AB\u0005\u0011\u001d\ti\u0005\u0011C\u0001\u0007\u0017A\u0011b!\u0004A\u0005\u0004%\t!!\u001a\t\u0011\r=\u0001\t)A\u0005\u0003OB\u0011b!\u0005A\u0005\u0004%\tAa.\t\u0011\rM\u0001\t)A\u0005\u0005sC\u0011b!\u0006A\u0005\u0004%\tAa.\t\u0011\r]\u0001\t)A\u0005\u0005sCqa!\u0007A\t\u0003\u0019Y\u0002C\u0005\u00042\u0001\u000b\n\u0011\"\u0001\u00044!I1\u0011\n!\u0012\u0002\u0013\u000511\n\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0006\u0003\u001b:\u000bqA\\3uo>\u00148NC\u0001P\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001*Y=B\u00111KV\u0007\u0002)*\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\n1\u0011I\\=SK\u001a\u0004\"!\u0017/\u000e\u0003iS!a\u0017(\u0002\u000bU$\u0018\u000e\\:\n\u0005uS&a\u0002'pO\u001eLgn\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C:\u000baa]3sm\u0016\u0014\u0018BA2a\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u000611m\u001c8gS\u001e,\u0012A\u001a\t\u0003?\u001eL!\u0001\u001b1\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u001c\t\u0003[Zl\u0011A\u001c\u0006\u0003U>T!\u0001]9\u0002\r\r|W.\\8o\u0015\ty%O\u0003\u0002ti\u00061\u0011\r]1dQ\u0016T\u0011!^\u0001\u0004_J<\u0017BA<o\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0005i&lW-F\u0001|!\tah0D\u0001~\u0015\tYv.\u0003\u0002\u0000{\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055\u0011/\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\t\"a\u0003\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u0001\u0014GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000fI\u0001\u0012CBLg+\u001a:tS>tW*\u00198bO\u0016\u0014XCAA\r!\u0011\tY\"a\b\u000e\u0005\u0005u!BA1r\u0013\u0011\t\t#!\b\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'/\u0001\nba&4VM]:j_:l\u0015M\\1hKJ\u0004\u0013!D:pG.,GOR1di>\u0014\u00180\u0006\u0002\u0002*A!\u00111DA\u0016\u0013\u0011\ti#!\b\u0003'M+'O^3s'>\u001c7.\u001a;GC\u000e$xN]=\u0002\u001dM|7m[3u\r\u0006\u001cGo\u001c:zA\u0005i2m\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u00148/\u0006\u0002\u00026A1\u0011qGA\u001f\u0003\u0003j!!!\u000f\u000b\u0007\u0005mB+\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u0002:\t\u00191+Z9\u0011\t\u0005\r\u0013qI\u0007\u0003\u0003\u000bR1!TA\u000f\u0013\u0011\tI%!\u0012\u00039\r{gN\\3di&|g\u000eR5tG>tg.Z2u\u0019&\u001cH/\u001a8fe\u0006q2m\u001c8oK\u000e$\u0018n\u001c8ESN\u001cwN\u001c8fGRd\u0015n\u001d;f]\u0016\u00148\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005E\u0013QKA,\u00033\nY&!\u0018\u0002`\u0005\u0005\u0004cAA*\u00015\tA\nC\u0003e\u001f\u0001\u0007a\rC\u0003k\u001f\u0001\u0007A\u000eC\u0003z\u001f\u0001\u00071\u0010C\u0004\u0002\u0004=\u0001\r!a\u0002\t\u000f\u0005Uq\u00021\u0001\u0002\u001a!I\u0011QE\b\u0011\u0002\u0003\u0007\u0011\u0011\u0006\u0005\n\u0003cy\u0001\u0013!a\u0001\u0003k\ta\"\\3ue&\u001c7\u000fU1dW\u0006<W-\u0006\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014\u0001\u00027b]\u001eT!!!\u001d\u0002\t)\fg/Y\u0005\u0005\u0003k\nYG\u0001\u0004TiJLgnZ\u0001\u0010[\u0016$(/[2t!\u0006\u001c7.Y4fA\u0005\u0001R.\u001a;sS\u000e\u001c8\t\\1tg:\u000bW.Z\u0001\u0012[\u0016$(/[2t\u00072\f7o\u001d(b[\u0016\u0004\u0013\u0001D7fiJL7m]$s_V\u0004XCAAA!\u0011\t\u0019)a\"\u000e\u0005\u0005\u0015%b\u00016\u0002\u001e%!\u0011\u0011RAC\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000e[\u0016$(/[2t\u000fJ|W\u000f\u001d\u0011\u0002#5\f\u00070U;fk\u0016$'+Z9vKN$8/\u0006\u0002\u0002\u0012B!\u0011\u0011NAJ\u0013\u0011\t)*a\u001b\u0003\u000f%sG/Z4fe\u0006\u0011R.\u0019=Rk\u0016,X\r\u001a*fcV,7\u000f^:!\u0003\u0019qw\u000eZ3JIV\u0011\u0011Q\u0014\t\u0004'\u0006}\u0015bAAQ)\n\u0019\u0011J\u001c;\u0002\u000f9|G-Z%eA\u0005QAn\\4D_:$X\r\u001f;\u0016\u0005\u0005%\u0006c\u0001?\u0002,&\u0019\u0011QV?\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013\u0001E7f[>\u0014\u0018\u0010U8pYN+gn]8s+\t\t)\fE\u0002n\u0003oK1!!/o\u0005\u0019\u0019VM\\:pe\u0006\tR.Z7pef\u0004vn\u001c7TK:\u001cxN\u001d\u0011\u0002G5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a)fe\u000e,g\u000e^'fiJL7MT1nKV\u0011\u0011\u0011\u0019\t\u0005\u0003\u0007\f)-D\u0001p\u0013\r\t9m\u001c\u0002\u000b\u001b\u0016$(/[2OC6,\u0017\u0001J7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.\u001a\u0011\u0002A5,Wn\u001c:z!>|G\u000eR3qY\u0016$X\r\u001a+j[\u0016lU\r\u001e:jG:\u000bW.Z\u0001\"[\u0016lwN]=Q_>dG)\u001a9mKR,G\rV5nK6+GO]5d\u001d\u0006lW\rI\u0001\u000b[\u0016lwN]=Q_>dWCAAj!\u0011\t).a7\u000e\u0005\u0005]'bAAm_\u00061Q.Z7pefLA!!8\u0002X\nQQ*Z7pef\u0004vn\u001c7\u0002\u00175,Wn\u001c:z!>|G\u000eI\u0001\u0013I\u0006$\u0018\r\u00157b]\u0016\f5mY3qi>\u00148/\u0006\u0002\u0002fBA\u0011q]Ay\u0003k\fY0\u0004\u0002\u0002j*!\u00111^Aw\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003_\fy'\u0001\u0003vi&d\u0017\u0002BAz\u0003S\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\u0011\t\u0019-a>\n\u0007\u0005exN\u0001\u0005F]\u0012\u0004x.\u001b8u!\u0011\t\u0019&!@\n\u0007\u0005}HJA\tECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J\f1\u0003Z1uCBc\u0017M\\3BG\u000e,\u0007\u000f^8sg\u0002\nq\u0003Z1uCBc\u0017M\\3SKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0005\t\u001d\u0001\u0003BA*\u0005\u0013I1Aa\u0003M\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\f\u0001\u0004Z1uCBc\u0017M\\3SKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003=qW\r\u001f;Qe>\u001cWm]:pe&#\u0007\u0003\u0002B\n\u00053i!A!\u0006\u000b\t\t]\u0011\u0011^\u0001\u0007CR|W.[2\n\t\tm!Q\u0003\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002!\r|gN\\3di&|g.U;pi\u0006\u001cXC\u0001B\u0011!\u0011\t\u0019Fa\t\n\u0007\t\u0015BJ\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\u00029\u0005dG.Q;uQ>\u0014\u0018N_3s\rV$XO]3t\u0007>l\u0007\u000f\\3uKV\u0011!Q\u0006\t\u0007\u0003O\u0014yCa\r\n\t\tE\u0012\u0011\u001e\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA5\u0005kIAAa\u000e\u0002l\t!ak\\5e\u0003u\tG\u000e\\!vi\"|'/\u001b>fe\u001a+H/\u001e:fg\u000e{W\u000e\u001d7fi\u0016\u0004\u0013aB:u_B\u0004X\rZ\u000b\u0003\u0005\u007f\u00012a\u0015B!\u0013\r\u0011\u0019\u0005\u0016\u0002\b\u0005>|G.Z1o\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\t\t%#q\n\t\u0004'\n-\u0013b\u0001B')\n!QK\\5u\u0011%\u0011\tFLA\u0001\u0002\u0004\u0011y$A\u0002yIE\n\u0001b\u001d;paB,G\r\t\u000b\u0003\u0003;\u000bq#\u001a8bE2,'+Z9vKN$\bK]8dKN\u001c\u0018N\\4\u0015\t\t5\"1\f\u0005\b\u0005;\n\u0004\u0019\u0001B0\u0003E\tW\u000f\u001e5pe&TXM\u001d$viV\u0014Xm\u001d\t\t\u0003o\u0011\t'!>\u0003.%!!1MA\u001d\u0005\ri\u0015\r]\u0001%GJ,\u0017\r^3ECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J\fe\u000e\u001a)s_\u000e,7o]8sgR!!\u0011\nB5\u0011\u001d\u0011YG\ra\u0001\u0003k\f\u0001\"\u001a8ea>Lg\u000e^\u0001\nK:$\u0007o\\5oiN,\"A!\u001d\u0011\u0011\tM$\u0011\u0010B>\u0003kl!A!\u001e\u000b\t\t]\u0014\u0011H\u0001\nS6lW\u000f^1cY\u0016LAAa\u0019\u0003vA!!Q\u0010BA\u001b\t\u0011yH\u0003\u0002N_&!!1\u0011B@\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]\u0019'/Z1uK\u0012\u000bG/\u0019)mC:,\u0017iY2faR|'\u000f\u0006\u0005\u0002|\n%%Q\u0012BI\u0011\u001d\u0011Y\t\u000ea\u0001\u0003k\f\u0001\"\u001a8e!>Lg\u000e\u001e\u0005\b\u0005\u001f#\u0004\u0019\u0001B \u0003QI7\u000f\u0015:jm&dWmZ3e\u0019&\u001cH/\u001a8fe\"9!1\u0013\u001bA\u0002\t\u001d\u0011A\u0004:fcV,7\u000f^\"iC:tW\r\\\u0001\u0017gR|\u0007\u000f\u0015:pG\u0016\u001c8/\u001b8h%\u0016\fX/Z:ugR\u0011!\u0011J\u0001\tg\",H\u000fZ8x]\u0006I!m\\;oIB{'\u000f\u001e\u000b\u0005\u0003;\u0013y\nC\u0004\u0003\"^\u0002\rAa\u001f\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0002\u0019\u0005$G\rT5ti\u0016tWM]:\u0015\t\t%#q\u0015\u0005\b\u0005SC\u0004\u0019\u0001BV\u00039a\u0017n\u001d;f]\u0016\u00148/\u00113eK\u0012\u0004b!a\u000e\u0002>\u0005U\u0018a\u0004:f[>4X\rT5ti\u0016tWM]:\u0015\t\t%#\u0011\u0017\u0005\b\u0005gK\u0004\u0019\u0001BV\u0003Aa\u0017n\u001d;f]\u0016\u00148OU3n_Z,G-A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\te\u0006CBA\u001c\u0005w\u0013y,\u0003\u0003\u0003>\u0006e\"aA*fiB!!\u0011\u0019Bh\u001d\u0011\u0011\u0019Ma3\u0011\u0007\t\u0015G+\u0004\u0002\u0003H*\u0019!\u0011\u001a)\u0002\rq\u0012xn\u001c;?\u0013\r\u0011i\rV\u0001\u0007!J,G-\u001a4\n\t\u0005U$\u0011\u001b\u0006\u0004\u0005\u001b$\u0016a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\u0011\u0011IEa6\t\r\te7\b1\u0001g\u0003%qWm^\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,GC\u0002B%\u0005?\u0014\u0019\u000f\u0003\u0004\u0003br\u0002\rAZ\u0001\n_2$7i\u001c8gS\u001eDaA!7=\u0001\u00041\u0017aD2p]:,7\r^5p]\u000e{WO\u001c;\u0015\t\u0005u%\u0011\u001e\u0005\b\u0005Wl\u0004\u0019\u0001Bw\u0003\u001d\tG\r\u001a:fgN\u0004BAa<\u0003v6\u0011!\u0011\u001f\u0006\u0005\u0005g\fy'A\u0002oKRLAAa>\u0003r\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0003E!\u0017\r^1QY\u0006tW-Q2dKB$xN\u001d\u000b\u0005\u0005{\u001c\u0019\u0001E\u0003T\u0005\u007f\fY0C\u0002\u0004\u0002Q\u0013aa\u00149uS>t\u0007b\u0002BQ}\u0001\u0007!qX\u0001\r'>\u001c7.\u001a;TKJ4XM\u001d\t\u0004\u0003'\u00025C\u0001!S)\t\u00199!\u0001\u0007NKR\u0014\u0018nY:He>,\b/A\u0007NKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t\u0003Y\u0011VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013!\b'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0002=1K7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON\u0004\u0013aC2m_N,7k\\2lKR$BA!\u0013\u0004\u001e!91q\u0004%A\u0002\r\u0005\u0012aB2iC:tW\r\u001c\t\u0005\u0007G\u0019i#\u0004\u0002\u0004&)!1qEB\u0015\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BB\u0016\u0003_\n1A\\5p\u0013\u0011\u0019yc!\n\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111Q\u0007\u0016\u0005\u0003S\u00199d\u000b\u0002\u0004:A!11HB#\u001b\t\u0019iD\u0003\u0003\u0004@\r\u0005\u0013!C;oG\",7m[3e\u0015\r\u0019\u0019\u0005V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB$\u0007{\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u00111Q\n\u0016\u0005\u0003k\u00199\u0004")
public class SocketServer
implements Logging,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final ApiVersionManager apiVersionManager;
    private final ServerSocketFactory socketFactory;
    private final Seq<ConnectionDisconnectListener> connectionDisconnectListeners;
    private final String metricsPackage;
    private final String metricsClassName;
    private final KafkaMetricsGroup metricsGroup;
    private final Integer maxQueuedRequests;
    private final int nodeId;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool memoryPool;
    private final ConcurrentHashMap<Endpoint, DataPlaneAcceptor> dataPlaneAcceptors;
    private final RequestChannel dataPlaneRequestChannel;
    private final AtomicInteger nextProcessorId;
    private final ConnectionQuotas connectionQuotas;
    private final CompletableFuture<Void> allAuthorizerFuturesComplete;
    private boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Seq<ConnectionDisconnectListener> $lessinit$greater$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static ServerSocketFactory $lessinit$greater$default$6() {
        return ServerSocketFactory.INSTANCE;
    }

    public static void closeSocket(SocketChannel channel) {
        SocketServer$.MODULE$.closeSocket(channel);
    }

    public static Set<String> ListenerReconfigurableConfigs() {
        return SocketServer$.MODULE$.ListenerReconfigurableConfigs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    public static String MetricsGroup() {
        return SocketServer$.MODULE$.MetricsGroup();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    public ServerSocketFactory socketFactory() {
        return this.socketFactory;
    }

    public Seq<ConnectionDisconnectListener> connectionDisconnectListeners() {
        return this.connectionDisconnectListeners;
    }

    private String metricsPackage() {
        return this.metricsPackage;
    }

    private String metricsClassName() {
        return this.metricsClassName;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int nodeId() {
        return this.nodeId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    private MemoryPool memoryPool() {
        return this.memoryPool;
    }

    public ConcurrentHashMap<Endpoint, DataPlaneAcceptor> dataPlaneAcceptors() {
        return this.dataPlaneAcceptors;
    }

    public RequestChannel dataPlaneRequestChannel() {
        return this.dataPlaneRequestChannel;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private CompletableFuture<Void> allAuthorizerFuturesComplete() {
        return this.allAuthorizerFuturesComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public int nextProcessorId() {
        return this.nextProcessorId.getAndIncrement();
    }

    public synchronized CompletableFuture<Void> enableRequestProcessing(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        if (this.stopped()) {
            throw new RuntimeException("Can't enable request processing: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Enabling request processing.");
        this.dataPlaneAcceptors().values().forEach(acceptor -> this.chainAcceptorFuture$1((Acceptor)acceptor, (Map)authorizerFutures));
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])authorizerFutures.values().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), this.allAuthorizerFuturesComplete());
        CompletableFuture<Void> enableFuture = new CompletableFuture<Void>();
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.CollectionHasAsScala(this.dataPlaneAcceptors().values()).asScala().toArray(ClassTag$.MODULE$.apply(DataPlaneAcceptor.class))), (Function1 & Serializable)x$2 -> x$2.startedFuture(), ClassTag$.MODULE$.apply(CompletableFuture.class))), enableFuture);
        return enableFuture;
    }

    private synchronized void createDataPlaneAcceptorAndProcessors(Endpoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new data plane acceptor and processors: SocketServer is stopped.");
        }
        ListenerName listenerName = ListenerName.normalised((String)endpoint.listener());
        java.util.Map<String, Object> parsedConfigs = this.config().valuesFromThisConfigWithPrefixOverride(listenerName.configPrefix());
        this.connectionQuotas().addListener(this.config(), listenerName);
        ListenerName listenerName2 = this.config().interBrokerListenerName();
        boolean isPrivilegedListener = listenerName2 != null && listenerName2.equals(listenerName);
        DataPlaneAcceptor dataPlaneAcceptor = this.createDataPlaneAcceptor(endpoint, isPrivilegedListener, this.dataPlaneRequestChannel());
        this.config().addReconfigurable((Reconfigurable)dataPlaneAcceptor);
        dataPlaneAcceptor.configure(parsedConfigs);
        this.dataPlaneAcceptors().put(endpoint, dataPlaneAcceptor);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Created data-plane acceptor and processors for endpoint : " + listenerName);
    }

    private scala.collection.immutable.Map<ListenerName, Endpoint> endpoints() {
        return ((IterableOnceOps)this.config().listeners().map((Function1 & Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ListenerName.normalised((String)l.listener())), l))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public DataPlaneAcceptor createDataPlaneAcceptor(Endpoint endPoint, boolean isPrivilegedListener, RequestChannel requestChannel) {
        return new DataPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), isPrivilegedListener, requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    public synchronized void stopProcessingRequests() {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping socket server request processors");
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$3 -> {
                x$3.beginShutdown();
                return BoxedUnit.UNIT;
            });
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.close();
                return BoxedUnit.UNIT;
            });
            this.dataPlaneRequestChannel().clear();
            this.info((Function0<String>)(Function0 & Serializable)() -> "Stopped socket server request processors");
            return;
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down socket server");
        this.allAuthorizerFuturesComplete().completeExceptionally(new TimeoutException("The socket server was shut down before the Authorizer could be completely initialized."));
        synchronized (this) {
            this.stopProcessingRequests();
            this.dataPlaneRequestChannel().shutdown();
            this.connectionQuotas().close();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(this.endpoints().apply((Object)listenerName));
            if (acceptor == null) {
                throw new KafkaException("Could not find listenerName : " + listenerName + " in data-plane.");
            }
            n = acceptor.localPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<Endpoint> listenersAdded) {
        if (this.stopped()) {
            throw new RuntimeException("can't add new listeners: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Adding data-plane listeners for endpoints " + listenersAdded);
        listenersAdded.foreach((Function1 & Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors((Endpoint)endpoint);
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(endpoint);
            return this.allAuthorizerFuturesComplete().whenComplete((x$5, e) -> {
                if (e != null) {
                    acceptor.startedFuture().completeExceptionally((Throwable)e);
                    return;
                }
                acceptor.start();
            });
        });
    }

    public synchronized void removeListeners(Seq<Endpoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Removing data-plane listeners for endpoints " + listenersRemoved);
        listenersRemoved.foreach((Function1 & Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer maxConnectionRate;
        Integer maxConnections;
        Map<String, Object> maxConnectionsPerIpOverrides;
        Integer maxConnectionsPerIp;
        Integer n = maxConnectionsPerIp = newConfig.maxConnectionsPerIp();
        Integer n2 = oldConfig.maxConnectionsPerIp();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating maxConnectionsPerIp: " + maxConnectionsPerIp);
            this.connectionQuotas().updateMaxConnectionsPerIp(Predef$.MODULE$.Integer2int(maxConnectionsPerIp));
        }
        Map<String, Object> map = maxConnectionsPerIpOverrides = newConfig.maxConnectionsPerIpOverrides();
        Map<String, Object> map2 = oldConfig.maxConnectionsPerIpOverrides();
        if (map == null ? map2 != null : !map.equals(map2)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating maxConnectionsPerIpOverrides: " + ((IterableOnceOps)maxConnectionsPerIpOverrides.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    int v = x0$1._2$mcI$sp();
                    return k + "=" + v;
                }
                throw new MatchError(null);
            })).mkString(","));
            this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
        }
        Integer n3 = maxConnections = newConfig.maxConnections();
        Integer n4 = oldConfig.maxConnections();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating broker-wide maxConnections: " + maxConnections);
            this.connectionQuotas().updateBrokerMaxConnections(Predef$.MODULE$.Integer2int(maxConnections));
        }
        Integer n5 = maxConnectionRate = newConfig.maxConnectionCreationRate();
        Integer n6 = oldConfig.maxConnectionCreationRate();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Updating broker-wide maxConnectionCreationRate: " + maxConnectionRate);
            this.connectionQuotas().updateBrokerMaxConnectionRate(Predef$.MODULE$.Integer2int(maxConnectionRate));
            return;
        }
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable)() -> 0, (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.get(address))));
    }

    public Option<DataPlaneAcceptor> dataPlaneAcceptor(String listenerName) {
        Object object = new Object();
        try {
            CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.dataPlaneAcceptors()).asScala().foreach((Function1 & Serializable)x0$1 -> {
                SocketServer.$anonfun$dataPlaneAcceptor$1(listenerName, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ double $anonfun$new$6(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$4(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$6(m))));
    }

    public static final /* synthetic */ double $anonfun$new$1(SocketServer $this) {
        synchronized ($this) {
            Iterable dataPlaneProcessors = (Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors());
            Iterable ioWaitRatioMetricNames = (Iterable)dataPlaneProcessors.map((Function1 & Serializable)p -> {
                void metricName_tags;
                void metricName_group;
                void metricName_name;
                Metrics metrics = $this.metrics();
                java.util.Map<String, String> map = p.metricTags();
                String string = SocketServer$.MODULE$.MetricsGroup();
                String string2 = "io-wait-ratio";
                if (metrics == null) {
                    throw null;
                }
                return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
            });
            double d = dataPlaneProcessors.isEmpty() ? 1.0 : BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)ioWaitRatioMetricNames.map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$4($this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)dataPlaneProcessors.size();
            return d;
        }
    }

    public static final /* synthetic */ long $anonfun$new$7(SocketServer $this) {
        return $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ long $anonfun$new$8(SocketServer $this) {
        return $this.memoryPool().size() - $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ double $anonfun$new$14(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$12(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (Function1 & Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$14(m))));
    }

    public static final /* synthetic */ double $anonfun$new$9(SocketServer $this) {
        synchronized ($this) {
            double d = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((Iterable)((Iterable)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().values().flatMap((Function1 & Serializable)a -> a.processors())).map((Function1 & Serializable)p -> {
                void metricName_tags;
                void metricName_group;
                void metricName_name;
                Metrics metrics = $this.metrics();
                java.util.Map<String, String> map = p.metricTags();
                String string = SocketServer$.MODULE$.MetricsGroup();
                String string2 = "expired-connections-killed-count";
                if (metrics == null) {
                    throw null;
                }
                return metrics.metricName((String)metricName_name, (String)metricName_group, "", (java.util.Map)metricName_tags);
            })).map((Function1 & Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$12($this, metricName)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            return d;
        }
    }

    public static final /* synthetic */ boolean $anonfun$enableRequestProcessing$1(Acceptor acceptor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Endpoint endpoint = (Endpoint)x0$1._1();
            return acceptor$1.endPoint().listener().equals(endpoint.listener());
        }
        throw new MatchError(null);
    }

    private final void chainAcceptorFuture$1(Acceptor acceptor, Map authorizerFutures$1) {
        Tuple2 tuple2;
        CompletableFuture completableFuture;
        Option option = authorizerFutures$1.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$enableRequestProcessing$1(acceptor, x0$1)));
        if (None$.MODULE$.equals(option)) {
            completableFuture = this.allAuthorizerFuturesComplete();
        } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            completableFuture = (CompletableFuture)tuple2._2();
        } else {
            throw new MatchError((Object)option);
        }
        completableFuture.whenComplete((x$1, e) -> {
            if (e != null) {
                acceptor.startedFuture().completeExceptionally((Throwable)e);
                return;
            }
            acceptor.start();
        });
    }

    public static final /* synthetic */ void $anonfun$removeListeners$3(SocketServer $this, DataPlaneAcceptor acceptor) {
        acceptor.beginShutdown();
        acceptor.close();
        $this.config().removeReconfigurable((Reconfigurable)acceptor);
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, Endpoint endpoint) {
        $this.connectionQuotas().removeListener($this.config(), ListenerName.normalised((String)endpoint.listener()));
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala($this.dataPlaneAcceptors()).asScala().remove((Object)endpoint).foreach((Function1 & Serializable)acceptor -> {
            SocketServer.$anonfun$removeListeners$3($this, acceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dataPlaneAcceptor$1(String listenerName$2, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        block5: {
            block8: {
                DataPlaneAcceptor acceptor;
                block7: {
                    String string;
                    block6: {
                        if (x0$1 == null) break block5;
                        Endpoint endPoint = (Endpoint)x0$1._1();
                        acceptor = (DataPlaneAcceptor)x0$1._2();
                        string = endPoint.listener();
                        if (string != null) break block6;
                        if (listenerName$2 != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!string.equals(listenerName$2)) break block8;
                }
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)acceptor));
            }
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider, ApiVersionManager apiVersionManager, ServerSocketFactory socketFactory, Seq<ConnectionDisconnectListener> connectionDisconnectListeners) {
        void add_stat;
        void sensor_name;
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        this.apiVersionManager = apiVersionManager;
        this.socketFactory = socketFactory;
        this.connectionDisconnectListeners = connectionDisconnectListeners;
        this.metricsPackage = "kafka.network";
        this.metricsClassName = "SocketServer";
        this.metricsGroup = new KafkaMetricsGroup(this.metricsPackage(), this.metricsClassName());
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.nodeId = config.brokerId();
        this.logContext = new LogContext("[SocketServer listenerType=" + apiVersionManager.listenerType() + ", nodeId=" + this.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        String string = "MemoryPoolUtilization";
        if (metrics == null) {
            throw null;
        }
        Sensor.RecordingLevel sensor_recordingLevel = Sensor.RecordingLevel.INFO;
        Object var10_9 = null;
        string = null;
        this.memoryPoolSensor = metrics.sensor((String)sensor_name, null, sensor_recordingLevel, (Sensor[])null);
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", SocketServer$.MODULE$.MetricsGroup());
        Sensor sensor = this.memoryPoolSensor();
        Meter meter = new Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName());
        if (sensor == null) {
            throw null;
        }
        sensor.add((CompoundStat)add_stat, null);
        meter = null;
        this.memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.dataPlaneAcceptors = new ConcurrentHashMap();
        this.dataPlaneRequestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()), time, apiVersionManager.newRequestMetrics());
        this.nextProcessorId = new AtomicInteger(0);
        this.connectionQuotas = new ConnectionQuotas(config, time, metrics);
        this.allAuthorizerFuturesComplete = new CompletableFuture();
        this.stopped = false;
        this.metricsGroup().newGauge("NetworkProcessorAvgIdlePercent", () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$1(this)));
        this.metricsGroup().newGauge("MemoryPoolAvailable", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$7(this)));
        this.metricsGroup().newGauge("MemoryPoolUsed", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$8(this)));
        this.metricsGroup().newGauge("ExpiredConnectionsKilledCount", () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$9(this)));
        if (apiVersionManager.listenerType().equals((Object)ApiMessageType.ListenerType.CONTROLLER)) {
            config.controllerListeners().foreach((Function1 & Serializable)endpoint -> {
                this.createDataPlaneAcceptorAndProcessors(endpoint);
                return BoxedUnit.UNIT;
            });
            return;
        }
        config.dataPlaneListeners().foreach((Function1 & Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors(endpoint);
            return BoxedUnit.UNIT;
        });
    }
}

