/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Mask an image with the negation (or logical compliment) of a mask.


This class is templated over the types of the input image type, the
mask image type and the type of the output image. Numeric conversions
(castings) are done by the C++ defaults.

The pixel type of the input 2 image must have a valid definition of
the operator!=. This condition is required because internally this
filter will perform the operation


The pixel from the input 1 is cast to the pixel type of the output
image.

Note that the input and the mask images must be of the same size.


WARNING:
Only pixel value with mask_value ( defaults to 0 ) will be preserved.

See:
 MaskImageFilter

 itk::simple::MaskNegated for the procedural interface

 itk::MaskNegatedImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMaskNegatedImageFilter.h
*/
public class MaskNegatedImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MaskNegatedImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MaskNegatedImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MaskNegatedImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MaskNegatedImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MaskNegatedImageFilter::~MaskNegatedImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MaskNegatedImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MaskNegatedImageFilter::MaskNegatedImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MaskNegatedImageFilter() {
    this(SimpleITKJNI.new_MaskNegatedImageFilter(), true);
  }

  /**
Self&amp; itk::simple::MaskNegatedImageFilter::SetOutsideValue(double OutsideValue)

Method to explicitly set the outside value of the mask. Defaults to 0

*/
public  void setOutsideValue(double OutsideValue) {
    SimpleITKJNI.MaskNegatedImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
double itk::simple::MaskNegatedImageFilter::GetOutsideValue() const
*/
public  double getOutsideValue() {
    return SimpleITKJNI.MaskNegatedImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::MaskNegatedImageFilter::SetMaskingValue(double MaskingValue)

Method to explicitly set the masking value of the mask. Defaults to 0

*/
public  void setMaskingValue(double MaskingValue) {
    SimpleITKJNI.MaskNegatedImageFilter_setMaskingValue(swigCPtr, this, MaskingValue);
  }

  /**
double itk::simple::MaskNegatedImageFilter::GetMaskingValue() const

Method to get the masking value of the mask.

*/
public  double getMaskingValue() {
    return SimpleITKJNI.MaskNegatedImageFilter_getMaskingValue(swigCPtr, this);
  }

  /**
std::string itk::simple::MaskNegatedImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MaskNegatedImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MaskNegatedImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MaskNegatedImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MaskNegatedImageFilter::Execute(Image &amp;&amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.MaskNegatedImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

}
