/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocInverter;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.RawPostingList;
import org.apache.lucene.index.TermVectorsTermsWriter;
import org.apache.lucene.index.TermVectorsTermsWriterPerThread;
import org.apache.lucene.index.TermsHashConsumerPerField;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.UnicodeUtil;

final class TermVectorsTermsWriterPerField
extends TermsHashConsumerPerField {
    final TermVectorsTermsWriterPerThread perThread;
    final TermsHashPerField termsHashPerField;
    final TermVectorsTermsWriter termsWriter;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    final DocInverter.FieldInvertState fieldState;
    boolean doVectors;
    boolean doVectorPositions;
    boolean doVectorOffsets;
    int maxNumPostings;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TermVectorsTermsWriterPerField(TermsHashPerField termsHashPerField, TermVectorsTermsWriterPerThread perThread, FieldInfo fieldInfo) {
        this.termsHashPerField = termsHashPerField;
        this.perThread = perThread;
        this.termsWriter = perThread.termsWriter;
        this.fieldInfo = fieldInfo;
        this.docState = termsHashPerField.docState;
        this.fieldState = termsHashPerField.fieldState;
    }

    int getStreamCount() {
        return 2;
    }

    boolean start(Fieldable[] fields, int count) {
        this.doVectors = false;
        this.doVectorPositions = false;
        this.doVectorOffsets = false;
        for (int i = 0; i < count; ++i) {
            Fieldable field = fields[i];
            if (!field.isIndexed() || !field.isTermVectorStored()) continue;
            this.doVectors = true;
            this.doVectorPositions |= field.isStorePositionWithTermVector();
            this.doVectorOffsets |= field.isStoreOffsetWithTermVector();
        }
        if (this.doVectors) {
            if (this.perThread.doc == null) {
                this.perThread.doc = this.termsWriter.getPerDoc();
                this.perThread.doc.docID = this.docState.docID;
                if (!$assertionsDisabled && this.perThread.doc.numVectorFields != 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && 0L != this.perThread.doc.tvf.length()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && 0L != this.perThread.doc.tvf.getFilePointer()) {
                    throw new AssertionError();
                }
            } else {
                if (!$assertionsDisabled && this.perThread.doc.docID != this.docState.docID) {
                    throw new AssertionError();
                }
                if (this.termsHashPerField.numPostings != 0) {
                    this.termsHashPerField.reset();
                }
            }
        }
        return this.doVectors;
    }

    public void abort() {
    }

    void finish() throws IOException {
        if (!$assertionsDisabled && !this.docState.testPoint("TermVectorsTermsWriterPerField.finish start")) {
            throw new AssertionError();
        }
        int numPostings = this.termsHashPerField.numPostings;
        if (!$assertionsDisabled && numPostings < 0) {
            throw new AssertionError();
        }
        if (!this.doVectors || numPostings == 0) {
            return;
        }
        if (numPostings > this.maxNumPostings) {
            this.maxNumPostings = numPostings;
        }
        RAMOutputStream tvf = this.perThread.doc.tvf;
        if (!$assertionsDisabled && !this.fieldInfo.storeTermVector) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.perThread.vectorFieldsInOrder(this.fieldInfo)) {
            throw new AssertionError();
        }
        this.perThread.doc.addField(this.termsHashPerField.fieldInfo.number);
        RawPostingList[] postings = this.termsHashPerField.sortPostings();
        tvf.writeVInt(numPostings);
        byte bits = 0;
        if (this.doVectorPositions) {
            bits = (byte)(bits | 1);
        }
        if (this.doVectorOffsets) {
            bits = (byte)(bits | 2);
        }
        ((IndexOutput)tvf).writeByte(bits);
        int encoderUpto = 0;
        int lastTermBytesCount = 0;
        ByteSliceReader reader = this.perThread.vectorSliceReader;
        char[][] charBuffers = this.perThread.termsHashPerThread.charPool.buffers;
        for (int j = 0; j < numPostings; ++j) {
            int prefix;
            TermVectorsTermsWriter.PostingList posting = (TermVectorsTermsWriter.PostingList)postings[j];
            int freq = posting.freq;
            char[] text2 = charBuffers[posting.textStart >> 14];
            int start2 = posting.textStart & 0x3FFF;
            UnicodeUtil.UTF8Result utf8Result = this.perThread.utf8Results[encoderUpto];
            UnicodeUtil.UTF16toUTF8(text2, start2, utf8Result);
            int termBytesCount = utf8Result.length;
            if (j > 0) {
                byte[] lastTermBytes = this.perThread.utf8Results[1 - encoderUpto].result;
                byte[] termBytes = this.perThread.utf8Results[encoderUpto].result;
                for (prefix = 0; prefix < lastTermBytesCount && prefix < termBytesCount && lastTermBytes[prefix] == termBytes[prefix]; ++prefix) {
                }
            }
            encoderUpto = 1 - encoderUpto;
            lastTermBytesCount = termBytesCount;
            int suffix = termBytesCount - prefix;
            tvf.writeVInt(prefix);
            tvf.writeVInt(suffix);
            ((IndexOutput)tvf).writeBytes(utf8Result.result, prefix, suffix);
            tvf.writeVInt(freq);
            if (this.doVectorPositions) {
                this.termsHashPerField.initReader(reader, posting, 0);
                reader.writeTo(tvf);
            }
            if (!this.doVectorOffsets) continue;
            this.termsHashPerField.initReader(reader, posting, 1);
            reader.writeTo(tvf);
        }
        this.termsHashPerField.reset();
        this.perThread.termsHashPerThread.reset(false);
    }

    void shrinkHash() {
        this.termsHashPerField.shrinkHash(this.maxNumPostings);
        this.maxNumPostings = 0;
    }

    void newTerm(Token t, RawPostingList p0) {
        if (!$assertionsDisabled && !this.docState.testPoint("TermVectorsTermsWriterPerField.newTerm start")) {
            throw new AssertionError();
        }
        TermVectorsTermsWriter.PostingList p = (TermVectorsTermsWriter.PostingList)p0;
        p.freq = 1;
        if (this.doVectorOffsets) {
            int startOffset = this.fieldState.offset + t.startOffset();
            int endOffset = this.fieldState.offset + t.endOffset();
            this.termsHashPerField.writeVInt(1, startOffset);
            this.termsHashPerField.writeVInt(1, endOffset - startOffset);
            p.lastOffset = endOffset;
        }
        if (this.doVectorPositions) {
            this.termsHashPerField.writeVInt(0, this.fieldState.position);
            p.lastPosition = this.fieldState.position;
        }
    }

    void addTerm(Token t, RawPostingList p0) {
        if (!$assertionsDisabled && !this.docState.testPoint("TermVectorsTermsWriterPerField.addTerm start")) {
            throw new AssertionError();
        }
        TermVectorsTermsWriter.PostingList p = (TermVectorsTermsWriter.PostingList)p0;
        ++p.freq;
        if (this.doVectorOffsets) {
            int startOffset = this.fieldState.offset + t.startOffset();
            int endOffset = this.fieldState.offset + t.endOffset();
            this.termsHashPerField.writeVInt(1, startOffset - p.lastOffset);
            this.termsHashPerField.writeVInt(1, endOffset - startOffset);
            p.lastOffset = endOffset;
        }
        if (this.doVectorPositions) {
            this.termsHashPerField.writeVInt(0, this.fieldState.position - p.lastPosition);
            p.lastPosition = this.fieldState.position;
        }
    }

    void skippingLongTerm(Token t) {
    }

    static {
        $assertionsDisabled = !TermVectorsTermsWriterPerField.class.desiredAssertionStatus();
    }
}

