/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Placeholder;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.CommitChecksKt;
import com.intellij.vcs.commit.CommitOptions;
import com.intellij.vcs.commit.CommitOptionsKt;
import com.intellij.vcs.commit.CommitOptionsUi;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0000\u0018\u0000 -2\u00020\u0001:\u0002,-B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u00020\u001d*\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u001a\u0010#\u001a\u00020\u001d*\u00020!2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u0014\u0010&\u001a\u00020\u001d*\u00020!2\u0006\u0010'\u001a\u00020%H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010)\u001a\u00020\u001d2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/vcs/commit/CommitOptionsPanel;", "Lcom/intellij/vcs/commit/CommitOptionsUi;", "project", "Lcom/intellij/openapi/project/Project;", "actionNameSupplier", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "nonFocusable", "", "nonModalCommit", "contentBorder", "Ljavax/swing/border/Border;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;ZZLjavax/swing/border/Border;)V", "component", "Ljavax/swing/JComponent;", "placeholder", "Lcom/intellij/ui/dsl/builder/Placeholder;", "value", "isEmpty", "()Z", "visibleVcses", "", "Lcom/intellij/openapi/vcs/AbstractVcs;", "visibleVcsListeners", "", "Ljava/lang/Runnable;", "setOptions", "", "options", "Lcom/intellij/vcs/commit/CommitOptions;", "appendNonModalCommitSettingsRow", "Lcom/intellij/ui/dsl/builder/Panel;", "actionName", "appendOptionRows", "", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "appendOptionRow", "option", "extractMeaningfulComponent", "setVisible", "vcses", "", "VcsVisiblePredicate", "Companion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nCommitOptionsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitOptionsPanel.kt\ncom/intellij/vcs/commit/CommitOptionsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1869#2,2:164\n*S KotlinDebug\n*F\n+ 1 CommitOptionsPanel.kt\ncom/intellij/vcs/commit/CommitOptionsPanel\n*L\n117#1:164,2\n*E\n"})
public final class CommitOptionsPanel
implements CommitOptionsUi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<String> actionNameSupplier;
    private final boolean nonFocusable;
    private final boolean nonModalCommit;
    @NotNull
    private final Border contentBorder;
    @JvmField
    @NotNull
    public final JComponent component;
    private Placeholder placeholder;
    private boolean isEmpty;
    @Nullable
    private Set<? extends AbstractVcs> visibleVcses;
    @NotNull
    private final List<Runnable> visibleVcsListeners;

    public CommitOptionsPanel(@NotNull Project project, @NotNull Function0<String> actionNameSupplier, boolean nonFocusable, boolean nonModalCommit, @NotNull Border contentBorder) {
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(actionNameSupplier, (String)"actionNameSupplier");
        Intrinsics.checkNotNullParameter((Object)contentBorder, (String)"contentBorder");
        this.project = project;
        this.actionNameSupplier = actionNameSupplier;
        this.nonFocusable = nonFocusable;
        this.nonModalCommit = nonModalCommit;
        this.contentBorder = contentBorder;
        this.isEmpty = true;
        this.visibleVcsListeners = new ArrayList();
        DialogPanel $this$_init__u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> CommitOptionsPanel._init_$lambda$0(this, arg_0));
        boolean bl = false;
        $this$_init__u24lambda_u241.setBorder(this.contentBorder);
        DialogPanel panel = dialogPanel;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)panel), (int)22, (int)30, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.component = jScrollPane;
    }

    public /* synthetic */ CommitOptionsPanel(Project project, Function0 function0, boolean bl, boolean bl2, Border border, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
            border = (Border)jBEmptyBorder;
        }
        this(project, (Function0<String>)function0, bl, bl2, border);
    }

    public final boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public void setOptions(@NotNull CommitOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = UIUtil.removeMnemonic((String)((String)this.actionNameSupplier.invoke()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeMnemonic(...)");
        String actionName = string;
        this.visibleVcsListeners.clear();
        this.isEmpty = CommitOptionsKt.isEmpty(options);
        Placeholder placeholder = this.placeholder;
        if (placeholder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"placeholder");
            placeholder = null;
        }
        placeholder.setComponent((JComponent)BuilderKt.panel(arg_0 -> CommitOptionsPanel.setOptions$lambda$0(options, this, actionName, arg_0)));
        if (this.nonFocusable) {
            UIUtil.forEachComponentInHierarchy((Component)this.component, arg_0 -> CommitOptionsPanel.setOptions$lambda$2(CommitOptionsPanel::setOptions$lambda$1, arg_0));
        }
    }

    private final void appendNonModalCommitSettingsRow(Panel $this$appendNonModalCommitSettingsRow, String actionName) {
        VcsConfiguration settings = VcsConfiguration.getInstance((Project)this.project);
        Panel.row$default((Panel)$this$appendNonModalCommitSettingsRow, null, arg_0 -> CommitOptionsPanel.appendNonModalCommitSettingsRow$lambda$0(actionName, settings, this, arg_0), (int)1, null);
    }

    private final void appendOptionRows(Panel $this$appendOptionRows, List<? extends RefreshableOnComponent> options) {
        Iterable $this$forEach$iv = options;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RefreshableOnComponent it = (RefreshableOnComponent)element$iv;
            boolean bl = false;
            this.appendOptionRow($this$appendOptionRows, it);
        }
    }

    private final void appendOptionRow(Panel $this$appendOptionRow, RefreshableOnComponent option) {
        JComponent jComponent = option.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = this.extractMeaningfulComponent(jComponent);
        Panel.row$default((Panel)$this$appendOptionRow, null, arg_0 -> CommitOptionsPanel.appendOptionRow$lambda$0(component, option, arg_0), (int)1, null);
    }

    private final JComponent extractMeaningfulComponent(JComponent component) {
        if (component instanceof DialogPanel) {
            return null;
        }
        if (component instanceof JPanel) {
            Border border = ((JPanel)component).getBorder();
            if (((JPanel)component).getLayout() instanceof BorderLayout && ((JPanel)component).getComponents().length == 1 && (border == null || border instanceof EmptyBorder)) {
                Component component2 = ((JPanel)component).getComponents()[0];
                return component2 instanceof JComponent ? (JComponent)component2 : null;
            }
        }
        return null;
    }

    @Override
    public void setVisible(@Nullable Collection<? extends AbstractVcs> vcses) {
        Collection<? extends AbstractVcs> collection = vcses;
        this.visibleVcses = collection != null ? CollectionsKt.toSet((Iterable)collection) : null;
        for (Runnable listener2 : this.visibleVcsListeners) {
            listener2.run();
        }
    }

    private static final Unit _init_$lambda$0(CommitOptionsPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CommitOptionsPanel.lambda$0$0(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$0(CommitOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.placeholder = $this$row.placeholder().align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit setOptions$lambda$0(CommitOptions $options, CommitOptionsPanel this$0, String $actionName, Panel $this$panel) {
        List<RefreshableOnComponent> afterOptions;
        List<RefreshableOnComponent> postCommitChecks;
        Object[] option;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        for (Map.Entry<AbstractVcs, RefreshableOnComponent> entry : $options.getVcsOptions().entrySet()) {
            AbstractVcs vcs = entry.getKey();
            option = entry.getValue();
            Panel.group$default((Panel)$this$panel, (String)vcs.getDisplayName(), (boolean)false, arg_0 -> CommitOptionsPanel.setOptions$lambda$0$0(this$0, (RefreshableOnComponent)option, arg_0), (int)2, null).visibleIf((ComponentPredicate)this$0.new VcsVisiblePredicate(vcs));
        }
        List<RefreshableOnComponent> preCommitChecks = $options.getBeforeCommitChecksOptions();
        if (!((Collection)preCommitChecks).isEmpty()) {
            Panel.group$default((Panel)$this$panel, (String)Companion.commitChecksGroupTitle($actionName), (boolean)false, arg_0 -> CommitOptionsPanel.setOptions$lambda$0$1(this$0, preCommitChecks, arg_0), (int)2, null);
        }
        if (!((Collection)(postCommitChecks = $options.getPostCommitChecksOptions())).isEmpty()) {
            Panel.group$default((Panel)$this$panel, (String)Companion.postCommitChecksGroupTitle($actionName), (boolean)false, arg_0 -> CommitOptionsPanel.setOptions$lambda$0$2(this$0, postCommitChecks, $actionName, arg_0), (int)2, null);
        }
        if (!((Collection)(afterOptions = $options.getAfterOptions())).isEmpty()) {
            option = new Object[]{$actionName};
            Panel.group$default((Panel)$this$panel, (String)VcsBundle.message((String)"border.standard.after.checkin.options.group", (Object[])option), (boolean)false, arg_0 -> CommitOptionsPanel.setOptions$lambda$0$3(this$0, afterOptions, arg_0), (int)2, null);
        }
        List<RefreshableOnComponent> extensionOptions = $options.getExtensionOptions();
        this$0.appendOptionRows($this$panel, extensionOptions);
        return Unit.INSTANCE;
    }

    private static final Unit setOptions$lambda$0$0(CommitOptionsPanel this$0, RefreshableOnComponent $option, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.appendOptionRow($this$group, $option);
        return Unit.INSTANCE;
    }

    private static final Unit setOptions$lambda$0$1(CommitOptionsPanel this$0, List $preCommitChecks, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.appendOptionRows($this$group, $preCommitChecks);
        return Unit.INSTANCE;
    }

    private static final Unit setOptions$lambda$0$2(CommitOptionsPanel this$0, List $postCommitChecks, String $actionName, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.appendOptionRows($this$group, $postCommitChecks);
        if (this$0.nonModalCommit) {
            Panel.separator$default((Panel)$this$group, null, (int)1, null);
            this$0.appendNonModalCommitSettingsRow($this$group, $actionName);
        }
        return Unit.INSTANCE;
    }

    private static final Unit setOptions$lambda$0$3(CommitOptionsPanel this$0, List $afterOptions, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.appendOptionRows($this$group, $afterOptions);
        return Unit.INSTANCE;
    }

    private static final Unit setOptions$lambda$1(Component it) {
        if (it instanceof JCheckBox) {
            ((JCheckBox)it).setFocusable(false);
        }
        return Unit.INSTANCE;
    }

    private static final void setOptions$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit appendNonModalCommitSettingsRow$lambda$0(String $actionName, VcsConfiguration $settings, CommitOptionsPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{$actionName};
        String string = VcsBundle.message((String)"settings.commit.postpone.slow.checks", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.selected((Cell)Cell.comment$default((Cell)$this$row.checkBox(string), (String)VcsBundle.message((String)"settings.commit.postpone.slow.checks.description.short", (Object[])new Object[0]), (int)0, null, (int)6, null), (boolean)$settings.NON_MODAL_COMMIT_POSTPONE_SLOW_CHECKS).onChanged(arg_0 -> CommitOptionsPanel.appendNonModalCommitSettingsRow$lambda$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit appendNonModalCommitSettingsRow$lambda$0$0(CommitOptionsPanel this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommitChecksKt.setRunSlowCommitChecksAfterCommit(this$0.project, it.isSelected());
        return Unit.INSTANCE;
    }

    private static final Unit appendOptionRow$lambda$0(JComponent $component, RefreshableOnComponent $option, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = $component;
        if (jComponent == null) {
            jComponent = $option.getComponent();
        }
        JComponent jComponent2 = jComponent;
        Intrinsics.checkNotNull((Object)jComponent2);
        $this$row.cell(jComponent2).align(Align.FILL);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006J\u0018\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/commit/CommitOptionsPanel$Companion;", "", "<init>", "()V", "commitChecksGroupTitle", "", "Lorg/jetbrains/annotations/Nls;", "actionName", "postCommitChecksGroupTitle", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String commitChecksGroupTitle(@NotNull String actionName) {
            Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
            Object[] objectArray = new Object[]{actionName};
            String string = VcsBundle.message((String)"commit.checks.group", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public final String postCommitChecksGroupTitle(@NotNull String actionName) {
            Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
            Object[] objectArray = new Object[]{actionName};
            String string = VcsBundle.message((String)"commit.checks.group.post", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u000e\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/commit/CommitOptionsPanel$VcsVisiblePredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "<init>", "(Lcom/intellij/vcs/commit/CommitOptionsPanel;Lcom/intellij/openapi/vcs/AbstractVcs;)V", "getVcs", "()Lcom/intellij/openapi/vcs/AbstractVcs;", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.platform.vcs.impl"})
    private final class VcsVisiblePredicate
    extends ComponentPredicate {
        @NotNull
        private final AbstractVcs vcs;

        public VcsVisiblePredicate(AbstractVcs vcs) {
            Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
            this.vcs = vcs;
        }

        @NotNull
        public final AbstractVcs getVcs() {
            return this.vcs;
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            CommitOptionsPanel.this.visibleVcsListeners.add(() -> VcsVisiblePredicate.addListener$lambda$0(listener2, this));
        }

        @NotNull
        public Boolean invoke() {
            Set set = CommitOptionsPanel.this.visibleVcses;
            return set != null ? set.contains(this.vcs) : true;
        }

        private static final void addListener$lambda$0(Function1 $listener, VcsVisiblePredicate this$0) {
            $listener.invoke((Object)this$0.invoke());
        }
    }
}

