﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/logs/CloudWatchLogs_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudWatchLogs {
namespace Model {

/**
 * <p>Represents a log event.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/OutputLogEvent">AWS
 * API Reference</a></p>
 */
class OutputLogEvent {
 public:
  AWS_CLOUDWATCHLOGS_API OutputLogEvent() = default;
  AWS_CLOUDWATCHLOGS_API OutputLogEvent(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHLOGS_API OutputLogEvent& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDWATCHLOGS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The time the event occurred, expressed as the number of milliseconds after
   * <code>Jan 1, 1970 00:00:00 UTC</code>.</p>
   */
  inline long long GetTimestamp() const { return m_timestamp; }
  inline bool TimestampHasBeenSet() const { return m_timestampHasBeenSet; }
  inline void SetTimestamp(long long value) {
    m_timestampHasBeenSet = true;
    m_timestamp = value;
  }
  inline OutputLogEvent& WithTimestamp(long long value) {
    SetTimestamp(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data contained in the log event.</p>
   */
  inline const Aws::String& GetMessage() const { return m_message; }
  inline bool MessageHasBeenSet() const { return m_messageHasBeenSet; }
  template <typename MessageT = Aws::String>
  void SetMessage(MessageT&& value) {
    m_messageHasBeenSet = true;
    m_message = std::forward<MessageT>(value);
  }
  template <typename MessageT = Aws::String>
  OutputLogEvent& WithMessage(MessageT&& value) {
    SetMessage(std::forward<MessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the event was ingested, expressed as the number of milliseconds
   * after <code>Jan 1, 1970 00:00:00 UTC</code>.</p>
   */
  inline long long GetIngestionTime() const { return m_ingestionTime; }
  inline bool IngestionTimeHasBeenSet() const { return m_ingestionTimeHasBeenSet; }
  inline void SetIngestionTime(long long value) {
    m_ingestionTimeHasBeenSet = true;
    m_ingestionTime = value;
  }
  inline OutputLogEvent& WithIngestionTime(long long value) {
    SetIngestionTime(value);
    return *this;
  }
  ///@}
 private:
  long long m_timestamp{0};

  Aws::String m_message;

  long long m_ingestionTime{0};
  bool m_timestampHasBeenSet = false;
  bool m_messageHasBeenSet = false;
  bool m_ingestionTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
