/*
 * Decompiled with CFR 0.152.
 */
package jcckit.graphic;

import java.awt.Color;
import jcckit.graphic.FillAttributes;
import jcckit.graphic.LineAttributes;
import jcckit.util.ConfigParameters;

public class ShapeAttributes
implements LineAttributes,
FillAttributes {
    public static final String FILL_COLOR_KEY = "fillColor";
    public static final String LINE_COLOR_KEY = "lineColor";
    public static final String LINE_THICKNESS_KEY = "lineThickness";
    public static final String LINE_PATTERN_KEY = "linePattern";
    private final Color _fillColor;
    private final Color _lineColor;
    private final double _lineThickness;
    private final double[] _linePattern;

    public ShapeAttributes(ConfigParameters config) {
        this(config.getColor(FILL_COLOR_KEY, null), config.getColor(LINE_COLOR_KEY, null), config.getDouble(LINE_THICKNESS_KEY, 0.0), config.getDoubleArray(LINE_PATTERN_KEY, null));
    }

    public ShapeAttributes(Color fillColor, Color lineColor, double lineThickness, double[] linePattern) {
        this._fillColor = fillColor;
        this._lineColor = lineColor;
        this._lineThickness = Math.max(0.0, lineThickness);
        this._linePattern = linePattern;
    }

    @Override
    public Color getFillColor() {
        return this._fillColor;
    }

    @Override
    public Color getLineColor() {
        return this._lineColor;
    }

    @Override
    public double getLineThickness() {
        return this._lineThickness;
    }

    @Override
    public double[] getLinePattern() {
        return this._linePattern;
    }
}

