/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import kafka.network.RequestChannel;
import kafka.server.AuthHelper;
import kafka.server.KafkaConfig;
import kafka.server.RequestHandlerHelper;
import kafka.utils.Logging;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.message.CreateAclsResponseData;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.message.DescribeAclsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateAclsRequest;
import org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.kafka.common.requests.DeleteAclsRequest;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.requests.DescribeAclsRequest;
import org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.purgatory.DelayedFuturePurgatory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\b\u0010\u0001QA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!A!\u0002\u0013A\u0005\"B&\u0001\t\u0003a\u0005bB*\u0001\u0005\u0004%I\u0001\u0016\u0005\u00077\u0002\u0001\u000b\u0011B+\t\u000bq\u0003A\u0011A/\t\u000b\u0005\u0004A\u0011\u00012\t\u000b\u0019\u0004A\u0011A4\t\u000by\u0004A\u0011A@\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\t9\u0011i\u00197Ba&\u001c(B\u0001\t\u0012\u0003\u0019\u0019XM\u001d<fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039}i\u0011!\b\u0006\u0003=E\tQ!\u001e;jYNL!\u0001I\u000f\u0003\u000f1{wmZ5oO\u0006Q\u0011-\u001e;i\u0011\u0016d\u0007/\u001a:\u0011\u0005\r\"S\"A\b\n\u0005\u0015z!AC!vi\"DU\r\u001c9fe\u0006\u0001\u0012-\u001e;i_JL'0\u001a:QYV<\u0017N\u001c\t\u0004-!R\u0013BA\u0015\u0018\u0005\u0019y\u0005\u000f^5p]B\u00191&N\u001c\u000e\u00031R!!\f\u0018\u0002\u0013%tG/\u001a:oC2\u001c(BA\u00181\u0003\u0019\u0019w.\\7p]*\u0011!#\r\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014x-\u0003\u00027Y\t1\u0001\u000b\\;hS:\u0004\"\u0001\u000f\u001f\u000e\u0003eR!AO\u001e\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002\u0011a%\u0011Q(\u000f\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018!\u0004:fcV,7\u000f\u001e%fYB,'\u000f\u0005\u0002$\u0001&\u0011\u0011i\u0004\u0002\u0015%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0011\u0016d\u0007/\u001a:\u0002\tI|G.\u001a\t\u0003\t\u0016k\u0011aO\u0005\u0003\rn\u00121\u0002\u0015:pG\u0016\u001c8OU8mK\u000611m\u001c8gS\u001e\u0004\"aI%\n\u0005){!aC&bM.\f7i\u001c8gS\u001e\fa\u0001P5oSRtDCB'O\u001fB\u000b&\u000b\u0005\u0002$\u0001!)\u0011E\u0002a\u0001E!)aE\u0002a\u0001O!)aH\u0002a\u0001\u007f!)!I\u0002a\u0001\u0007\")qI\u0002a\u0001\u0011\u0006\u0011\u0012\r\u001c;fe\u0006\u001bGn\u001d)ve\u001e\fGo\u001c:z+\u0005)\u0006C\u0001,Z\u001b\u00059&B\u0001-<\u0003%\u0001XO]4bi>\u0014\u00180\u0003\u0002[/\n1B)\u001a7bs\u0016$g)\u001e;ve\u0016\u0004VO]4bi>\u0014\u00180A\nbYR,'/Q2mgB+(oZ1u_JL\b%\u0001\u0005jg\u000ecwn]3e+\u0005q\u0006C\u0001\f`\u0013\t\u0001wCA\u0004C_>dW-\u00198\u0002\u000b\rdwn]3\u0015\u0003\r\u0004\"A\u00063\n\u0005\u0015<\"\u0001B+oSR\f!\u0003[1oI2,G)Z:de&\u0014W-Q2mgR\u0011\u0001N\u001d\t\u0004SB\u001cW\"\u00016\u000b\u0005-d\u0017AC2p]\u000e,(O]3oi*\u0011QN\\\u0001\u0005kRLGNC\u0001p\u0003\u0011Q\u0017M^1\n\u0005ET'!E\"p[BdW\r^1cY\u00164U\u000f^;sK\")1o\u0003a\u0001i\u00069!/Z9vKN$\bCA;|\u001d\t1\u00180D\u0001x\u0015\tA\u0018#A\u0004oKR<xN]6\n\u0005i<\u0018A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0003yv\u0014qAU3rk\u0016\u001cHO\u0003\u0002{o\u0006\u0001\u0002.\u00198eY\u0016\u001c%/Z1uK\u0006\u001bGn\u001d\u000b\u0004Q\u0006\u0005\u0001\"B:\r\u0001\u0004!\u0018\u0001\u00055b]\u0012dW\rR3mKR,\u0017i\u00197t)\rA\u0017q\u0001\u0005\u0006g6\u0001\r\u0001\u001e")
public class AclApis
implements Logging {
    private final AuthHelper authHelper;
    private final Option<Plugin<Authorizer>> authorizerPlugin;
    private final RequestHandlerHelper requestHelper;
    private final KafkaConfig config;
    private final DelayedFuturePurgatory alterAclsPurgatory;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private DelayedFuturePurgatory alterAclsPurgatory() {
        return this.alterAclsPurgatory;
    }

    public boolean isClosed() {
        return this.alterAclsPurgatory().isShutdown();
    }

    public void close() {
        this.alterAclsPurgatory().shutdown();
    }

    public CompletableFuture<BoxedUnit> handleDescribeAcls(RequestChannel.Request request) {
        this.authHelper.authorizeClusterOperation(request, AclOperation.DESCRIBE);
        DescribeAclsRequest describeAclsRequest = (DescribeAclsRequest)request.body(ClassTag$.MODULE$.apply(DescribeAclsRequest.class));
        Option<Plugin<Authorizer>> option = this.authorizerPlugin;
        if (None$.MODULE$.equals(option)) {
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleDescribeAcls$1(describeAclsRequest, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        } else if (option instanceof Some) {
            Plugin auth = (Plugin)((Some)option).value();
            AclBindingFilter filter = describeAclsRequest.filter();
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleDescribeAcls$2(auth, filter, describeAclsRequest, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
        } else {
            throw new MatchError(option);
        }
        return CompletableFuture.completedFuture(BoxedUnit.UNIT);
    }

    public CompletableFuture<BoxedUnit> handleCreateAcls(RequestChannel.Request request) {
        this.authHelper.authorizeClusterOperation(request, AclOperation.ALTER);
        CreateAclsRequest createAclsRequest = (CreateAclsRequest)request.body(ClassTag$.MODULE$.apply(CreateAclsRequest.class));
        Option<Plugin<Authorizer>> option = this.authorizerPlugin;
        if (None$.MODULE$.equals(option)) {
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> createAclsRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)requestThrottleMs), (Throwable)new SecurityDisabledException("No Authorizer is configured.")));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        if (option instanceof Some) {
            Plugin auth = (Plugin)((Some)option).value();
            Buffer allBindings = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(createAclsRequest.aclCreations()).asScala().map((Function1 & Serializable)x$1 -> CreateAclsRequest.aclBinding((CreateAclsRequestData.AclCreation)x$1));
            Map errorResults = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            ArrayBuffer validBindings = new ArrayBuffer();
            allBindings.foreach((Function1 & Serializable)acl -> {
                InvalidRequestException throwable;
                ResourcePattern resource = acl.pattern();
                ResourceType resourceType = resource.resourceType();
                ResourceType resourceType2 = ResourceType.CLUSTER;
                InvalidRequestException invalidRequestException = !(resourceType != null ? !resourceType.equals(resourceType2) : resourceType2 != null) && !resource.name().equals("kafka-cluster") ? new InvalidRequestException("The only valid name for the CLUSTER resource is kafka-cluster") : (throwable = resource.name().isEmpty() ? new InvalidRequestException("Invalid empty resource name") : null);
                if (throwable != null) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> "Failed to add acl " + acl + " to " + resource, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                    errorResults.update(acl, (Object)new AclCreateResult((ApiException)throwable));
                    return BoxedUnit.UNIT;
                }
                return validBindings.$plus$eq(acl);
            });
            CompletableFuture future = new CompletableFuture();
            List<CompletableFuture> createResults = ((Authorizer)auth.get()).createAcls((AuthorizableRequestContext)request.context(), CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)validBindings).asJava()).stream().map(x$1 -> x$1.toCompletableFuture()).toList();
            this.alterAclsPurgatory().tryCompleteElseWatch(Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), createResults, () -> AclApis.sendResponseCallback$1(allBindings, errorResults, createResults, validBindings, future));
            return future.thenApply(aclCreationResults -> {
                this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleCreateAcls$12(aclCreationResults, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
                return BoxedUnit.UNIT;
            });
        }
        throw new MatchError(option);
    }

    public CompletableFuture<BoxedUnit> handleDeleteAcls(RequestChannel.Request request) {
        this.authHelper.authorizeClusterOperation(request, AclOperation.ALTER);
        DeleteAclsRequest deleteAclsRequest = (DeleteAclsRequest)request.body(ClassTag$.MODULE$.apply(DeleteAclsRequest.class));
        Option<Plugin<Authorizer>> option = this.authorizerPlugin;
        if (None$.MODULE$.equals(option)) {
            this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> deleteAclsRequest.getErrorResponse(BoxesRunTime.unboxToInt((Object)requestThrottleMs), (Throwable)new SecurityDisabledException("No Authorizer is configured.")));
            return CompletableFuture.completedFuture(BoxedUnit.UNIT);
        }
        if (option instanceof Some) {
            Plugin auth = (Plugin)((Some)option).value();
            CompletableFuture future = new CompletableFuture();
            List<CompletableFuture> deleteResults = ((Authorizer)auth.get()).deleteAcls((AuthorizableRequestContext)request.context(), deleteAclsRequest.filters()).stream().map(x$2 -> x$2.toCompletableFuture()).toList();
            this.alterAclsPurgatory().tryCompleteElseWatch(Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), deleteResults, () -> AclApis.sendResponseCallback$2(deleteResults, future));
            return future.thenApply(filterResults -> {
                this.requestHelper.sendResponseMaybeThrottle(request, (Function1<Object, AbstractResponse>)(Function1 & Serializable)requestThrottleMs -> AclApis.$anonfun$handleDeleteAcls$7(filterResults, deleteAclsRequest$1, BoxesRunTime.unboxToInt((Object)requestThrottleMs)));
                return BoxedUnit.UNIT;
            });
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ DescribeAclsResponse $anonfun$handleDescribeAcls$1(DescribeAclsRequest describeAclsRequest$1, int requestThrottleMs) {
        return new DescribeAclsResponse(new DescribeAclsResponseData().setErrorCode(Errors.SECURITY_DISABLED.code()).setErrorMessage("No Authorizer is configured on the broker").setThrottleTimeMs(requestThrottleMs), describeAclsRequest$1.version());
    }

    public static final /* synthetic */ DescribeAclsResponse $anonfun$handleDescribeAcls$2(Plugin auth$1, AclBindingFilter filter$1, DescribeAclsRequest describeAclsRequest$1, int requestThrottleMs) {
        return new DescribeAclsResponse(new DescribeAclsResponseData().setThrottleTimeMs(requestThrottleMs).setResources(DescribeAclsResponse.aclsResources((Iterable)((Authorizer)auth$1.get()).acls(filter$1))), describeAclsRequest$1.version());
    }

    private static final void sendResponseCallback$1(Buffer allBindings$1, Map errorResults$1, List createResults$1, ArrayBuffer validBindings$1, CompletableFuture future$1) {
        Buffer aclCreationResults = (Buffer)allBindings$1.map((Function1 & Serializable)acl -> {
            AclCreateResult result = (AclCreateResult)errorResults$1.getOrElse(acl, (Function0 & Serializable)() -> (AclCreateResult)((CompletableFuture)createResults$1.get(validBindings$1.indexOf(acl))).get());
            CreateAclsResponseData.AclCreationResult creationResult = new CreateAclsResponseData.AclCreationResult();
            OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(result.exception())).foreach((Function1 & Serializable)throwable -> {
                ApiError apiError = ApiError.fromThrowable((Throwable)throwable);
                return creationResult.setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
            });
            return creationResult;
        });
        future$1.complete(CollectionConverters$.MODULE$.BufferHasAsJava(aclCreationResults).asJava());
    }

    public static final /* synthetic */ CreateAclsResponse $anonfun$handleCreateAcls$12(List aclCreationResults$1, int requestThrottleMs) {
        return new CreateAclsResponse(new CreateAclsResponseData().setThrottleTimeMs(requestThrottleMs).setResults(aclCreationResults$1));
    }

    private static final void sendResponseCallback$2(List deleteResults$1, CompletableFuture future$2) {
        List filterResults = deleteResults$1.stream().map(x$3 -> (AclDeleteResult)x$3.get()).map(x$1 -> DeleteAclsResponse.filterResult((AclDeleteResult)x$1)).collect(Collectors.toList());
        future$2.complete(filterResults);
    }

    public static final /* synthetic */ DeleteAclsResponse $anonfun$handleDeleteAcls$7(List filterResults$1, DeleteAclsRequest deleteAclsRequest$1, int requestThrottleMs) {
        return new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(requestThrottleMs).setFilterResults(filterResults$1), deleteAclsRequest$1.version());
    }

    public AclApis(AuthHelper authHelper, Option<Plugin<Authorizer>> authorizerPlugin, RequestHandlerHelper requestHelper, ProcessRole role, KafkaConfig config) {
        this.authHelper = authHelper;
        this.authorizerPlugin = authorizerPlugin;
        this.requestHelper = requestHelper;
        this.config = config;
        this.logIdent_$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("[AclApis-%s-%s] "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{role, BoxesRunTime.boxToInteger((int)config.nodeId())})));
        this.alterAclsPurgatory = new DelayedFuturePurgatory("AlterAcls", config.nodeId());
    }
}

