/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPolylineProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PointsParser;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    public String getLocalName() {
        return "polyline";
    }

    public Bridge getInstance() {
        return new SVGPolylineElementBridge();
    }

    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        String string = element.getAttributeNS(null, "points");
        if (string.length() != 0) {
            AWTPolylineProducer aWTPolylineProducer = new AWTPolylineProducer();
            aWTPolylineProducer.setWindingRule(CSSUtilities.convertFillRule(element));
            try {
                PointsParser pointsParser = new PointsParser();
                pointsParser.setPointsHandler(aWTPolylineProducer);
                pointsParser.parse(string);
            }
            catch (ParseException parseException) {
                BridgeException bridgeException = new BridgeException(element, "attribute.malformed", new Object[]{"points"});
                bridgeException.setGraphicsNode(shapeNode);
                throw bridgeException;
            }
            finally {
                shapeNode.setShape(aWTPolylineProducer.getShape());
            }
        }
    }

    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
        String string = mutationEvent.getAttrName();
        if (string.equals("points")) {
            if (mutationEvent.getNewValue().length() == 0) {
                ((ShapeNode)this.node).setShape(DEFAULT_SHAPE);
            } else {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            }
            this.handleGeometryChanged();
        } else {
            super.handleDOMAttrModifiedEvent(mutationEvent);
        }
    }

    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

