/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class LimitedInputStream
extends InputStream {
    private final InputStream in;
    private long remaining;
    private long marked;

    public LimitedInputStream(InputStream in, int size) {
        this.in = Objects.requireNonNull(in);
        this.remaining = size;
        this.marked = size;
        if (size < 0) {
            throw new IllegalArgumentException("size must be non-negative");
        }
    }

    private void consume(long n) throws IOException {
        if (n - this.remaining > 0L) {
            throw new EOFException("request to read more bytes than available");
        }
        this.remaining -= n;
    }

    private boolean hasRemaining() {
        return this.remaining > 0L;
    }

    private long ranged(long n) {
        if (n <= 0L) {
            return 0L;
        }
        return Math.min(n, this.remaining);
    }

    @Override
    public int read() throws IOException {
        if (this.hasRemaining()) {
            int read = this.in.read();
            this.consume(1L);
            return read;
        }
        this.eof();
        return -1;
    }

    @Override
    public int available() throws IOException {
        return (int)this.ranged(this.in.available());
    }

    @Override
    public void close() throws IOException {
        this.remaining = 0L;
        this.eof();
        this.in.close();
    }

    protected void eof() {
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark((int)this.ranged(readlimit));
        this.marked = this.remaining;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.hasRemaining()) {
            int read = this.in.read(b, off, (int)this.ranged(len));
            this.consume(read);
            return read;
        }
        this.eof();
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("mark/reset not supported");
        }
        this.in.reset();
        this.remaining = this.marked;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(this.ranged(n));
        this.consume(skipped);
        return skipped;
    }
}

