/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.exception;

import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Component(service={ExceptionMapper.class})
public class ValidationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ValidationExceptionMapper.class.getName());

    public Response toResponse(ConstraintViolationException exception) {
        exception.getConstraintViolations().forEach(constraintViolation -> {
            LOGGER.error("{} {}. {}", new Object[]{constraintViolation.getPropertyPath(), constraintViolation.getMessage(), LOGGER.isDebugEnabled() ? "" : "Enable debug log level for more information about the invalid value received"});
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("value {} from {} {}", new Object[]{constraintViolation.getInvalidValue(), constraintViolation.getPropertyPath(), constraintViolation.getMessage(), exception});
            }
        });
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("Content-Type", (Object)"text/plain").entity((Object)"Request rejected by the server because: Invalid received data").build();
    }
}

