/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public class StaticFactoryConverter
extends AbstractConverter {
    private final Method method;

    public StaticFactoryConverter(Class type, Method method) {
        super(type);
        this.method = method;
    }

    @Override
    protected Object toObjectImpl(String text) {
        try {
            return this.method.invoke(null, text);
        }
        catch (Exception e) {
            String message = String.format("Cannot convert string '%s' to %s.", text, super.getType());
            throw new PropertyEditorException(message, e);
        }
    }

    public static StaticFactoryConverter editor(Class type) {
        List<Method> candidates = StaticFactoryConverter.getCandidates(type);
        if (candidates.size() == 0) {
            return null;
        }
        Method method = StaticFactoryConverter.select(candidates);
        return new StaticFactoryConverter(type, method);
    }

    static List<Method> getCandidates(Class type) {
        ArrayList<Method> candidates = new ArrayList<Method>();
        for (Method method : type.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.getReturnType().equals(type) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            candidates.add(method);
        }
        return candidates;
    }

    static Method select(List<Method> candidates) {
        StaticFactoryConverter.sort(candidates);
        return candidates.get(0);
    }

    static void sort(List<Method> candidates) {
        Collections.sort(candidates, new Comparator<Method>(){

            @Override
            public int compare(Method a, Method b) {
                int av = StaticFactoryConverter.grade(a);
                int bv = StaticFactoryConverter.grade(b);
                return a.getName().compareTo(b.getName()) + (av - bv);
            }
        });
    }

    private static int grade(Method a) {
        String type = a.getReturnType().getSimpleName();
        String name = a.getName();
        if (name.equals("valueOf")) {
            return -990000;
        }
        if (name.equals("valueOf" + type)) {
            return -980000;
        }
        if (name.startsWith("valueOf")) {
            return -970000;
        }
        if (name.equals("new" + type)) {
            return -890000;
        }
        if (name.equals("newInstance")) {
            return -880000;
        }
        if (name.startsWith("new")) {
            return -870000;
        }
        if (name.equals("decode")) {
            return -790000;
        }
        if (name.equals("decode" + type)) {
            return -780000;
        }
        if (name.startsWith("decode")) {
            return -770000;
        }
        if (name.equals("for" + type)) {
            return -690000;
        }
        if (name.startsWith("for")) {
            return -680000;
        }
        if (name.equals("of")) {
            return -590000;
        }
        if (name.equals("of" + type)) {
            return -580000;
        }
        if (name.startsWith("of")) {
            return -570000;
        }
        if (name.equals("parse")) {
            return -490000;
        }
        if (name.equals("parse" + type)) {
            return -480000;
        }
        if (name.startsWith("parse")) {
            return -470000;
        }
        if (name.equals("from")) {
            return -390000;
        }
        if (name.equals("fromString")) {
            return -380000;
        }
        if (name.startsWith("from")) {
            return -370000;
        }
        if (name.equals("create")) {
            return -290000;
        }
        if (name.equals("create" + type)) {
            return -280000;
        }
        if (name.startsWith("create")) {
            return -270000;
        }
        if (name.equals("compile")) {
            return -190000;
        }
        if (name.equals("compile" + type)) {
            return -180000;
        }
        if (name.startsWith("compile")) {
            return -170000;
        }
        if (name.equals("get")) {
            return 1000;
        }
        if (name.equals("get" + type)) {
            return 1200;
        }
        if (name.equals("getInstance")) {
            return 1200;
        }
        if (name.startsWith("get")) {
            return 1300;
        }
        return 0;
    }
}

