/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;

public class ReportWriterConfiguration {
    private JasperReportsContext jasperReportsContext;
    private List<Pattern> excludePropertiesPattern;
    private boolean excludeUuids;

    public ReportWriterConfiguration(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.initExcludeProperties();
    }

    private void initExcludeProperties() {
        JasperReportsContext context = this.jasperReportsContext == null ? DefaultJasperReportsContext.getInstance() : this.jasperReportsContext;
        List<JRPropertiesUtil.PropertySuffix> excludeProperties = JRPropertiesUtil.getInstance(context).getProperties("net.sf.jasperreports.jrxml.writer.exclude.properties.");
        this.excludePropertiesPattern = new ArrayList<Pattern>(excludeProperties.size());
        for (JRPropertiesUtil.PropertySuffix propertySuffix : excludeProperties) {
            String regex = propertySuffix.getValue();
            Pattern pattern = Pattern.compile(regex);
            this.excludePropertiesPattern.add(pattern);
        }
        this.excludeUuids = JRPropertiesUtil.getInstance(context).getBooleanProperty("net.sf.jasperreports.jrxml.writer.exclude.uuids");
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public boolean isExcludeUuids() {
        return this.excludeUuids;
    }

    public boolean isPropertyToWrite(String propertyName) {
        boolean toWrite = true;
        for (Pattern pattern : this.excludePropertiesPattern) {
            if (!pattern.matcher(propertyName).matches()) continue;
            toWrite = false;
            break;
        }
        return toWrite;
    }
}

