/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.NormalizingSaxFilter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocViewFormat {
    private final OutputFormat format = new OutputFormat(4, true);
    private WeakReference<ByteArrayOutputStream> formattingBuffer;

    public OutputFormat getXmlOutputFormat() {
        return this.format;
    }

    public boolean format(File file, boolean dryRun) throws IOException {
        boolean changed;
        CRC32 originalCrc32 = new CRC32();
        CRC32 formattedCrc32 = new CRC32();
        byte[] formatted = this.format(file, originalCrc32, formattedCrc32);
        boolean bl = changed = originalCrc32.getValue() != formattedCrc32.getValue();
        if (changed && !dryRun) {
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                IOUtils.copy((InputStream)new ByteArrayInputStream(formatted), (OutputStream)out);
            }
        }
        return changed;
    }

    public List<String> format(File directory, List<Pattern> filenamePatterns, final boolean dryRun) throws IOException {
        final LinkedList<String> changed = new LinkedList<String>();
        Files.walkFileTree(directory.toPath(), new AbstractFormattingVisitor(filenamePatterns){

            @Override
            protected void process(File file) throws IOException {
                if (DocViewFormat.this.format(file, dryRun)) {
                    changed.add(file.getPath());
                }
            }
        });
        return changed;
    }

    private byte[] format(File file, Checksum original, Checksum formatted) throws IOException {
        byte[] byArray;
        CheckedInputStream in = new CheckedInputStream(new BufferedInputStream(new FileInputStream(file)), original);
        try {
            ByteArrayOutputStream buffer;
            ByteArrayOutputStream byteArrayOutputStream = buffer = this.formattingBuffer != null ? (ByteArrayOutputStream)this.formattingBuffer.get() : null;
            if (buffer == null) {
                buffer = new ByteArrayOutputStream();
                this.formattingBuffer = new WeakReference<ByteArrayOutputStream>(buffer);
            } else {
                buffer.reset();
            }
            try (CheckedOutputStream out = new CheckedOutputStream(buffer, formatted);
                 FormattingXmlStreamWriter writer = FormattingXmlStreamWriter.create(out, this.format);){
                TransformerFactory tf = TransformerFactory.newInstance();
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                SAXSource saxSource = new SAXSource(new InputSource(in));
                SAXParserFactory sf = SAXParserFactory.newInstance();
                sf.setNamespaceAware(true);
                sf.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                SAXParser parser = sf.newSAXParser();
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                saxSource.setXMLReader(new NormalizingSaxFilter(parser.getXMLReader()));
                Transformer t = tf.newTransformer();
                StAXResult result = new StAXResult(writer);
                t.transform(saxSource, result);
            }
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParserConfigurationException | FactoryConfigurationError | XMLStreamException | TransformerException | SAXException ex) {
                throw new IOException(ex);
            }
        }
        ((InputStream)in).close();
        return byArray;
    }

    private static abstract class AbstractFormattingVisitor
    extends SimpleFileVisitor<Path> {
        private final List<Pattern> patterns;

        AbstractFormattingVisitor(List<Pattern> patterns) {
            this.patterns = patterns;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (Files.isRegularFile(file, new LinkOption[0]) && this.isIncluded(file)) {
                this.process(file.toFile());
            }
            return super.visitFile(file, attrs);
        }

        private boolean isIncluded(Path file) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(file.getFileName().toString()).matches()) continue;
                return true;
            }
            return false;
        }

        protected abstract void process(File var1) throws IOException;
    }
}

