/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.config.client;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.servicecomb.config.archaius.sources.ConfigCenterConfigurationSourceImpl;
import org.apache.servicecomb.config.archaius.sources.ConfigCenterConfigurationSourceImpl.UpdateHandler;
import org.junit.Assert;
import org.junit.Test;

import mockit.Deencapsulation;

/**
 * @author
 */
public class TestParseConfigUtils {

  private ConfigCenterConfigurationSourceImpl configCenterSource = new ConfigCenterConfigurationSourceImpl();

  private UpdateHandler uh = configCenterSource.new UpdateHandler();

  private ParseConfigUtils pc = new ParseConfigUtils(uh);

  @Test
  public void testNotifyItemsChangedNeedRefresh() {

    boolean status = true;
    Map<String, Object> before = new HashMap<>();
    Map<String, Object> after = new HashMap<>();
    try {
      Deencapsulation.invoke(pc, "notifyItemsChangedNeedRefresh", before, after);
    } catch (Exception e) {
      status = false;
    }
    Assert.assertTrue(status);

    // Check with valid before object
    status = true;
    before.put("test", "testValue");
    try {
      Deencapsulation.invoke(pc, "notifyItemsChangedNeedRefresh", before, after);
    } catch (Exception e) {
      status = false;
    }
    Assert.assertTrue(status);

    // Check with valid after object
    status = true;
    after.put("test", "testValue2");
    try {
      Deencapsulation.invoke(pc, "notifyItemsChangedNeedRefresh", before, after);
    } catch (Exception e) {
      status = false;
    }
    Assert.assertTrue(status);

    // Check with valid localItems object
    status = true;
    try {
      Deencapsulation.invoke(pc, "notifyItemsChangedNeedRefresh", before, after);
    } catch (Exception e) {
      status = false;
    }
    Assert.assertTrue(status);
  }
  
  @Test
  public void testMergeDimensionItems() {

    boolean status = true;
    Map<String, Object> application = new HashMap<>();
    application.put("key1", "application1");
    application.put("key2", "application2");
    application.put("key3", "application3");
    application.put("key4", "application4");
    Map<String, Object> service = new HashMap<>();
    service.put("key1", "service1");
    service.put("key2", "service2");
    service.put("key3", "service3");
    Map<String, Object> version = new HashMap<>();
    version.put("key1", "version1");
    version.put("key2", "version1");
    Map<String, Object> tag = new HashMap<>();
    tag.put("key1", "tag1");

    Map<String, Map<String, Object>> items = new LinkedHashMap<String, Map<String, Object>>();
    items.put("application", application);
    items.put("service@app", service);
    items.put("service@app#version", version);
    items.put("service@app#version!tag", tag);

    Map<String, Object> result = null;
    try {
      result = Deencapsulation.invoke(pc, "mergeDimensionItems", items);
    } catch (Exception e) {
      status = false;
    }
    Assert.assertTrue(status);
    Assert.assertEquals(application.get("key4"), result.get("key4"));
    Assert.assertEquals(service.get("key3"), result.get("key3"));
    Assert.assertEquals(version.get("key2"), result.get("key2"));
    Assert.assertEquals(tag.get("key1"), result.get("key1"));
  }
}
