/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class LogoutServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Collection<HttpRequestInteractiveAuthenticator> AUTHENTICATORS;
    private HttpManagementConfiguration _managementConfiguration;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(config.getServletContext());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        HttpRequestInteractiveAuthenticator authenticator;
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        HttpRequestInteractiveAuthenticator.LogoutHandler logoutHandler = null;
        Iterator<HttpRequestInteractiveAuthenticator> iterator = AUTHENTICATORS.iterator();
        while (iterator.hasNext() && (logoutHandler = (authenticator = iterator.next()).getLogoutHandler(request, this._managementConfiguration)) == null) {
        }
        if (logoutHandler != null) {
            logoutHandler.handleLogout(resp);
        } else {
            resp.sendRedirect("/logout.html");
        }
    }

    static {
        ArrayList<HttpRequestInteractiveAuthenticator> authenticators = new ArrayList<HttpRequestInteractiveAuthenticator>();
        for (HttpRequestInteractiveAuthenticator authenticator : new QpidServiceLoader().instancesOf(HttpRequestInteractiveAuthenticator.class)) {
            authenticators.add(authenticator);
        }
        AUTHENTICATORS = Collections.unmodifiableList(authenticators);
    }
}

