/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.exchange.FanoutExchangeImpl;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.message.MessageDestination;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;

final class FanoutExchangeImplWithAccessChecking
extends FanoutExchangeImpl {
    private static final FixedKeyMapCreator BIND_MAP_CREATOR = new FixedKeyMapCreator("destination", "bindingKey", "arguments", "replaceExistingArguments");
    private static final FixedKeyMapCreator UNBIND_MAP_CREATOR = new FixedKeyMapCreator("destination", "bindingKey");

    FanoutExchangeImplWithAccessChecking(Map<String, Object> attributes, QueueManagingVirtualHost<?> queuemanagingvirtualhost) {
        super(attributes, queuemanagingvirtualhost);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<String> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean bind(final String destination, final String bindingKey, final Map<String, Object> arguments, final boolean replaceExistingArguments) {
        this.authorise(Operation.INVOKE_METHOD("bind"), BIND_MAP_CREATOR.createMap(destination, bindingKey, arguments, replaceExistingArguments));
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.bind(destination, bindingKey, arguments, replaceExistingArguments));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "bind";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "destination=" + destination + ",bindingKey=" + bindingKey + ",arguments=" + String.valueOf(arguments) + ",replaceExistingArguments=" + replaceExistingArguments;
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean unbind(final String destination, final String bindingKey) {
        this.authorise(Operation.INVOKE_METHOD("unbind"), UNBIND_MAP_CREATOR.createMap(destination, bindingKey));
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.unbind(destination, bindingKey));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "unbind";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "destination=" + destination + ",bindingKey=" + bindingKey;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD("resetStatistics"));
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                FanoutExchangeImplWithAccessChecking.super.resetStatistics();
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "resetStatistics";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public boolean addBinding(final String bindingKey, final Queue<?> queue, final Map<String, Object> arguments) throws AMQInvalidArgumentException {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                try {
                    return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.addBinding(bindingKey, queue, arguments));
                }
                catch (AMQInvalidArgumentException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "addBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + String.valueOf(queue) + ",arguments=" + String.valueOf(arguments);
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean deleteBinding(final String bindingKey, final Queue<?> queue) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.deleteBinding(bindingKey, queue));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "deleteBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + String.valueOf(queue);
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean hasBinding(final String bindingKey, final Queue<?> queue) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.hasBinding(bindingKey, queue));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "hasBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + String.valueOf(queue);
                }
                return this._args;
            }
        }));
    }

    @Override
    public void replaceBinding(final String bindingKey, final Queue<?> queue, final Map<String, Object> arguments) throws AMQInvalidArgumentException {
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                try {
                    FanoutExchangeImplWithAccessChecking.super.replaceBinding(bindingKey, queue, arguments);
                    return CompletableFuture.completedFuture(null);
                }
                catch (AMQInvalidArgumentException e) {
                    return CompletableFuture.failedFuture(e);
                }
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "replaceBinding";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",queue=" + String.valueOf(queue) + ",arguments=" + String.valueOf(arguments);
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean isBound(final String bindingKey, final Map<String, Object> arguments, final Queue<?> queue) {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.isBound(bindingKey, arguments, queue));
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "isBound";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "bindingKey=" + bindingKey + ",arguments=" + String.valueOf(arguments) + ",queue=" + String.valueOf(queue);
                }
                return this._args;
            }
        }));
    }

    @Override
    public boolean hasBindings() {
        return this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Boolean>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Boolean> execute() {
                return CompletableFuture.completedFuture(FanoutExchangeImplWithAccessChecking.super.hasBindings());
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "hasBindings";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public void destinationRemoved(final MessageDestination destination) {
        this.doSync(this.doOnConfigThread(new Task<CompletableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public CompletableFuture<Void> execute() {
                FanoutExchangeImplWithAccessChecking.super.destinationRemoved(destination);
                return CompletableFuture.completedFuture(null);
            }

            @Override
            public String getObject() {
                return FanoutExchangeImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "destinationRemoved";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "destination=" + String.valueOf(destination);
                }
                return this._args;
            }
        }));
    }
}

