/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectItemsFiltered;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectItemsFilteredRenderer<T extends AbstractUISelectItemsFiltered>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SUFFIX_QUERY = "::query";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String clientIdWithSuffix = component.getClientId(facesContext) + SUFFIX_QUERY;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientIdWithSuffix)) {
            String query = (String)requestParameterMap.get(clientIdWithSuffix);
            ((AbstractUISelectItemsFiltered)((Object)component)).setQuery(query);
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientIdWithSuffix = component.getClientId(facesContext) + SUFFIX_QUERY;
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(clientIdWithSuffix);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.NAME, clientIdWithSuffix, false);
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.DELAY, ((AbstractUISelectItemsFiltered)((Object)component)).getDelay());
        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.MIN_CHARS, ((AbstractUISelectItemsFiltered)((Object)component)).getMinimumCharacters());
        writer.endElement(HtmlElements.INPUT);
    }
}

