/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.Collections;
import java.util.HashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;

class SystemSession
extends SessionImpl {
    static SystemSession create(RepositoryImpl rep, WorkspaceConfig wspConfig) throws RepositoryException {
        HashSet<SystemPrincipal> principals = new HashSet<SystemPrincipal>();
        principals.add(new SystemPrincipal());
        Subject subject = new Subject(true, principals, Collections.EMPTY_SET, Collections.EMPTY_SET);
        return new SystemSession(rep, subject, wspConfig);
    }

    private SystemSession(RepositoryImpl rep, Subject subject, WorkspaceConfig wspConfig) throws RepositoryException {
        super(rep, subject, wspConfig);
    }

    protected String retrieveUserId(Subject subject) throws RepositoryException {
        return new SystemPrincipal().getName();
    }

    protected AccessManager createAccessManager(Subject subject, HierarchyManager hierMgr) throws AccessDeniedException, RepositoryException {
        return new SystemAccessManager();
    }

    private class SystemAccessManager
    extends AbstractAccessControlManager
    implements AccessManager {
        private final PrivilegeRegistry privilegeRegistry;

        SystemAccessManager() {
            this.privilegeRegistry = new PrivilegeRegistry((NameResolver)SystemSession.this);
        }

        public void init(AMContext context) throws AccessDeniedException, Exception {
        }

        public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        }

        public void close() throws Exception {
        }

        public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, RepositoryException {
        }

        public boolean isGranted(ItemId id, int permissions) throws RepositoryException {
            return true;
        }

        public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
            return true;
        }

        public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
            return true;
        }

        public boolean canRead(Path itemPath) throws RepositoryException {
            return true;
        }

        public boolean canAccess(String workspaceName) throws RepositoryException {
            return true;
        }

        protected void checkInitialized() throws IllegalStateException {
        }

        protected void checkPrivileges(String absPath, int privileges) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        }

        protected PrivilegeRegistry getPrivilegeRegistry() throws RepositoryException {
            return this.privilegeRegistry;
        }

        protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
            Path p = SystemSession.this.getQPath(absPath);
            if (!p.isAbsolute()) {
                throw new RepositoryException("Absolute path expected.");
            }
            if (SystemSession.this.hierMgr.resolveNodePath(p) == null) {
                throw new PathNotFoundException("No such node " + absPath);
            }
        }

        public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
            this.checkValidNodePath(absPath);
            return true;
        }

        public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
            this.checkValidNodePath(absPath);
            return this.getPrivilegeRegistry().getPrivileges(127);
        }

        public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
            throw new UnsupportedOperationException();
        }
    }
}

