/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.ByteHeap;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasSeqAddrMaps;
import org.apache.uima.cas.impl.CasTypeSystemMapper;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.FSsTobeAddedback;
import org.apache.uima.cas.impl.Heap;
import org.apache.uima.cas.impl.LongHeap;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.ShortHeap;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.StringHeap;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.rb_trees.Int2IntRBT;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasIOUtils;
import org.apache.uima.util.CasLoadMode;
import org.apache.uima.util.impl.DataIO;
import org.apache.uima.util.impl.OptimizeStrings;
import org.apache.uima.util.impl.SerializationMeasures;

public class BinaryCasSerDes6 {
    private static final int[] INT0 = new int[0];
    private static final boolean TRACE_SER = false;
    private static final boolean TRACE_DES = false;
    private static final boolean TRACE_STR_ARRAY = false;
    private static final int VERSION = 1;
    private static final long DBL_1 = Double.doubleToLongBits(1.0);
    private static final int arrayLength_i = SlotKinds.SlotKind.Slot_ArrayLength.ordinal();
    private static final int heapRef_i = SlotKinds.SlotKind.Slot_HeapRef.ordinal();
    private static final int int_i = SlotKinds.SlotKind.Slot_Int.ordinal();
    private static final int byte_i = SlotKinds.SlotKind.Slot_Byte.ordinal();
    private static final int short_i = SlotKinds.SlotKind.Slot_Short.ordinal();
    private static final int typeCode_i = SlotKinds.SlotKind.Slot_TypeCode.ordinal();
    private static final int strOffset_i = SlotKinds.SlotKind.Slot_StrOffset.ordinal();
    private static final int strLength_i = SlotKinds.SlotKind.Slot_StrLength.ordinal();
    private static final int long_High_i = SlotKinds.SlotKind.Slot_Long_High.ordinal();
    private static final int long_Low_i = SlotKinds.SlotKind.Slot_Long_Low.ordinal();
    private static final int float_Mantissa_Sign_i = SlotKinds.SlotKind.Slot_Float_Mantissa_Sign.ordinal();
    private static final int float_Exponent_i = SlotKinds.SlotKind.Slot_Float_Exponent.ordinal();
    private static final int double_Mantissa_Sign_i = SlotKinds.SlotKind.Slot_Double_Mantissa_Sign.ordinal();
    private static final int double_Exponent_i = SlotKinds.SlotKind.Slot_Double_Exponent.ordinal();
    private static final int fsIndexes_i = SlotKinds.SlotKind.Slot_FsIndexes.ordinal();
    private static final int strChars_i = SlotKinds.SlotKind.Slot_StrChars.ordinal();
    private static final int control_i = SlotKinds.SlotKind.Slot_Control.ordinal();
    private static final int strSeg_i = SlotKinds.SlotKind.Slot_StrSeg.ordinal();
    private TypeSystemImpl ts;
    private final CompressLevel compressLevel;
    private final CompressStrat compressStrategy;
    private final boolean isTypeMappingCmn;
    private CasTypeSystemMapper typeMapperCmn;
    private final CASImpl cas;
    private int[] heap;
    private final StringHeap stringHeapObj;
    private final LongHeap longHeapObj;
    private final ShortHeap shortHeapObj;
    private final ByteHeap byteHeapObj;
    private int heapStart;
    private int heapEnd;
    private int totalMappedHeapSize = 0;
    private final boolean isSerializingDelta;
    private boolean isDelta;
    private boolean isReadingDelta;
    private final MarkerImpl mark;
    private final CasSeqAddrMaps fsStartIndexes;
    private final boolean reuseInfoProvided;
    private final boolean doMeasurements;
    private OptimizeStrings os;
    private boolean only1CommonString;
    private final TypeSystemImpl tgtTs;
    private boolean isTsIncluded;
    private boolean isTsiIncluded;
    private TypeSystemImpl.TypeInfo typeInfo;
    private final CasTypeSystemMapper typeMapper;
    private boolean isTypeMapping;
    private final int[] iPrevHeapArray;
    private int iPrevHeap;
    private final int[][] prevHeapInstanceWithIntValues;
    private BitSet foundFSs;
    private BitSet foundFSsBelowMark;
    private int[] foundFSsArray;
    private final IntVector toBeScanned = new IntVector();
    private final boolean debugEOF = false;
    private DataOutputStream serializedOut;
    private final SerializationMeasures sm;
    private final ByteArrayOutputStream[] baosZipSources = new ByteArrayOutputStream[SlotKinds.SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
    private final DataOutputStream[] dosZipSources = new DataOutputStream[SlotKinds.SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
    private int[] savedAllIndexesFSs;
    private final int[] estimatedZipSize = new int[SlotKinds.SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
    private DataOutputStream byte_dos;
    private DataOutputStream typeCode_dos;
    private DataOutputStream strOffset_dos;
    private DataOutputStream strLength_dos;
    private DataOutputStream float_Mantissa_Sign_dos;
    private DataOutputStream float_Exponent_dos;
    private DataOutputStream double_Mantissa_Sign_dos;
    private DataOutputStream double_Exponent_dos;
    private DataOutputStream fsIndexes_dos;
    private DataOutputStream control_dos;
    private DataOutputStream strSeg_dos;
    private AllowPreexistingFS allowPreexistingFS;
    private DataInputStream deserIn;
    private int version;
    private final DataInputStream[] dataInputs = new DataInputStream[SlotKinds.SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
    private final Inflater[] inflaters = new Inflater[SlotKinds.SlotKind.NBR_SLOT_KIND_ZIP_STREAMS];
    private IntVector fixupsNeeded;
    private int stringTableOffset;
    private int longZeroIndex = -1;
    private int double1Index = -1;
    private boolean isUpdatePrevOK;
    private String[] readCommonString;
    private DataInputStream arrayLength_dis;
    private DataInputStream heapRef_dis;
    private DataInputStream int_dis;
    private DataInputStream byte_dis;
    private DataInputStream short_dis;
    private DataInputStream typeCode_dis;
    private DataInputStream strOffset_dis;
    private DataInputStream strLength_dis;
    private DataInputStream long_High_dis;
    private DataInputStream long_Low_dis;
    private DataInputStream float_Mantissa_Sign_dis;
    private DataInputStream float_Exponent_dis;
    private DataInputStream double_Mantissa_Sign_dis;
    private DataInputStream double_Exponent_dis;
    private DataInputStream fsIndexes_dis;
    private DataInputStream strChars_dis;
    private DataInputStream control_dis;
    private DataInputStream strSeg_dis;

    public ReuseInfo getReuseInfo() {
        return new ReuseInfo(this.foundFSs, this.foundFSsArray, this.fsStartIndexes);
    }

    public BinaryCasSerDes6(AbstractCas aCas, MarkerImpl mark, TypeSystemImpl tgtTs, ReuseInfo rfs, boolean doMeasurements, CompressLevel compressLevel, CompressStrat compressStrategy) throws ResourceInitializationException {
        this(aCas, mark, tgtTs, false, false, rfs, doMeasurements, compressLevel, compressStrategy);
    }

    private BinaryCasSerDes6(AbstractCas aCas, MarkerImpl mark, TypeSystemImpl tgtTs, boolean storeTS, boolean storeTSI, ReuseInfo rfs, boolean doMeasurements, CompressLevel compressLevel, CompressStrat compressStrategy) throws ResourceInitializationException {
        this.cas = ((CASImpl)(aCas instanceof JCas ? ((JCas)aCas).getCas() : aCas)).getBaseCAS();
        this.ts = this.cas.getTypeSystemImpl();
        this.mark = mark;
        if (null != mark && !mark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", new String[]{"Invalid Marker."});
        }
        this.doMeasurements = doMeasurements;
        this.sm = doMeasurements ? new SerializationMeasures() : null;
        this.isSerializingDelta = mark != null;
        this.isDelta = this.isSerializingDelta;
        this.typeMapperCmn = this.typeMapper = this.ts.getTypeSystemMapper(tgtTs);
        this.isTypeMapping = null != this.typeMapper;
        this.isTypeMappingCmn = this.isTypeMapping;
        this.isTsIncluded = storeTS;
        this.isTsiIncluded = storeTSI;
        this.heap = this.cas.getHeap().heap;
        this.heapEnd = this.cas.getHeap().getCellsUsed();
        this.heapStart = this.isSerializingDelta ? mark.getNextFSId() : 0;
        this.stringHeapObj = this.cas.getStringHeap();
        this.longHeapObj = this.cas.getLongHeap();
        this.shortHeapObj = this.cas.getShortHeap();
        this.byteHeapObj = this.cas.getByteHeap();
        this.iPrevHeapArray = new int[this.ts.getTypeArraySize()];
        this.prevHeapInstanceWithIntValues = new int[this.ts.getTypeArraySize()][];
        this.compressLevel = compressLevel;
        this.compressStrategy = compressStrategy;
        boolean bl = this.reuseInfoProvided = rfs != null;
        if (this.reuseInfoProvided) {
            this.foundFSs = rfs.foundFSs;
            this.foundFSsArray = rfs.foundFSsArray;
            this.fsStartIndexes = rfs.fsStartIndexes.copy();
        } else {
            this.foundFSs = null;
            this.foundFSsArray = null;
            this.fsStartIndexes = new CasSeqAddrMaps();
        }
        this.tgtTs = tgtTs;
    }

    BinaryCasSerDes6(BinaryCasSerDes6 f6, TypeSystemImpl tgtTs) throws ResourceInitializationException {
        this.cas = f6.cas;
        this.ts = this.cas.getTypeSystemImpl();
        this.mark = f6.mark;
        if (null != this.mark && !this.mark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", new String[]{"Invalid Marker."});
        }
        this.doMeasurements = f6.doMeasurements;
        this.sm = this.doMeasurements ? new SerializationMeasures() : null;
        this.isSerializingDelta = this.mark != null;
        this.isDelta = this.isSerializingDelta;
        this.typeMapperCmn = this.typeMapper = this.ts.getTypeSystemMapper(tgtTs);
        this.isTypeMapping = null != this.typeMapper;
        this.isTypeMappingCmn = this.isTypeMapping;
        this.isTsIncluded = f6.isTsIncluded;
        this.isTsiIncluded = f6.isTsiIncluded;
        this.heap = this.cas.getHeap().heap;
        this.heapEnd = this.cas.getHeap().getCellsUsed();
        this.heapStart = this.isSerializingDelta ? this.mark.getNextFSId() : 0;
        this.stringHeapObj = this.cas.getStringHeap();
        this.longHeapObj = this.cas.getLongHeap();
        this.shortHeapObj = this.cas.getShortHeap();
        this.byteHeapObj = this.cas.getByteHeap();
        this.iPrevHeapArray = new int[this.ts.getTypeArraySize()];
        this.prevHeapInstanceWithIntValues = new int[this.ts.getTypeArraySize()][];
        this.compressLevel = f6.compressLevel;
        this.compressStrategy = f6.compressStrategy;
        this.reuseInfoProvided = f6.reuseInfoProvided;
        this.foundFSs = f6.foundFSs;
        this.foundFSsArray = f6.foundFSsArray;
        this.fsStartIndexes = f6.fsStartIndexes;
        this.tgtTs = tgtTs;
    }

    public BinaryCasSerDes6(AbstractCas cas) throws ResourceInitializationException {
        this(cas, null, null, false, false, null, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, TypeSystemImpl tgtTs) throws ResourceInitializationException {
        this(cas, null, tgtTs, false, false, null, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, MarkerImpl mark, TypeSystemImpl tgtTs, ReuseInfo rfs) throws ResourceInitializationException {
        this(cas, mark, tgtTs, false, false, rfs, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, MarkerImpl mark, TypeSystemImpl tgtTs, ReuseInfo rfs, boolean doMeasurements) throws ResourceInitializationException {
        this(cas, mark, tgtTs, false, false, rfs, doMeasurements, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, ReuseInfo rfs) throws ResourceInitializationException {
        this(cas, null, null, false, false, rfs, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, ReuseInfo rfs, boolean storeTS, boolean storeTSI) throws ResourceInitializationException {
        this(cas, null, null, storeTS, storeTSI, rfs, false, CompressLevel.Default, CompressStrat.Default);
    }

    public SerializationMeasures serialize(Object out) throws IOException {
        SerializeModifiedFSs smfs;
        if (this.isSerializingDelta && this.tgtTs != null) {
            throw new UnsupportedOperationException("Can't do Delta Serialization with different target TS");
        }
        if (this.isTsIncluded && this.tgtTs != null) {
            throw new UnsupportedOperationException("Can't store a different target TS in the serialized form");
        }
        if (this.fsStartIndexes == null) {
            if (this.isSerializingDelta) {
                throw new UnsupportedOperationException("Serializing a delta requires valid ReuseInfo for Cas being serialized, captured right after it was deserialized");
            }
            if (this.isReadingDelta) {
                throw new UnsupportedOperationException("Deserializing a delta requires valid ReuseInfo for Cas being deserialized into");
            }
        }
        this.setupOutputStreams(out);
        if (this.doMeasurements) {
            System.out.println(this.printCasInfo(this.cas));
            this.sm.origAuxBytes = this.cas.getByteHeap().getSize();
            this.sm.origAuxShorts = this.cas.getShortHeap().getSize() * 2;
            this.sm.origAuxLongs = this.cas.getLongHeap().getSize() * 8;
            this.sm.totalTime = System.currentTimeMillis();
        }
        CommonSerDes.createHeader().form6().delta(this.isSerializingDelta).seqVer(0).typeSystemIncluded(this.isTsIncluded).typeSystemIndexDefIncluded(this.isTsiIncluded).write(this.serializedOut);
        if (this.isTsIncluded || this.isTsiIncluded) {
            CasIOUtils.writeTypeSystem(this.cas, this.serializedOut, this.isTsiIncluded);
        }
        this.os = new OptimizeStrings(this.doMeasurements);
        if (!this.reuseInfoProvided || this.isSerializingDelta) {
            this.processIndexedFeatureStructures(this.cas, false);
        }
        this.totalMappedHeapSize = this.initFsStartIndexes();
        if (this.heapStart == 0) {
            ++this.totalMappedHeapSize;
            this.heapStart = 1;
        }
        SerializeModifiedFSs serializeModifiedFSs = smfs = this.isSerializingDelta ? new SerializeModifiedFSs() : null;
        if (this.isSerializingDelta) {
            smfs.addModifiedStrings();
        }
        this.os.optimize();
        this.writeStringInfo();
        this.writeVnumber(this.control_dos, this.totalMappedHeapSize);
        if (this.doMeasurements) {
            this.sm.statDetails[SlotKinds.SlotKind.Slot_MainHeap.ordinal()].original = (1 + this.heapEnd - this.heapStart) * 4;
        }
        Arrays.fill(this.iPrevHeapArray, 0);
        Arrays.fill((Object[])this.prevHeapInstanceWithIntValues, null);
        int fsid = 1;
        for (int fssi = 0; fssi < this.foundFSsArray.length; ++fssi) {
            int i;
            int iHeap = this.foundFSsArray[fssi];
            if (this.isDelta && iHeap < this.mark.nextFSId) continue;
            int tCode = this.heap[iHeap];
            int mappedTypeCode = this.isTypeMapping ? this.typeMapper.mapTypeCodeSrc2Tgt(tCode) : tCode;
            ++fsid;
            if (mappedTypeCode == 0) continue;
            this.typeInfo = this.ts.getTypeInfo(tCode);
            this.iPrevHeap = this.iPrevHeapArray[tCode];
            this.writeVnumber(this.typeCode_dos, mappedTypeCode);
            if (this.typeInfo.isHeapStoredArray) {
                this.serializeHeapStoredArray(iHeap);
            } else if (this.typeInfo.isArray) {
                this.serializeNonHeapStoredArray(iHeap);
            } else if (this.isTypeMapping) {
                int[] tgtFeatOffsets2Src = this.typeMapper.getTgtFeatOffsets2Src(tCode);
                for (i = 0; i < tgtFeatOffsets2Src.length; ++i) {
                    int featOffsetInSrc = tgtFeatOffsets2Src[i] + 1;
                    if (featOffsetInSrc == 0) {
                        throw new RuntimeException();
                    }
                    this.serializeByKind(iHeap, featOffsetInSrc);
                }
            } else {
                int nbrSlots_p_1 = this.typeInfo.slotKinds.length + 1;
                for (i = 1; i < nbrSlots_p_1; ++i) {
                    this.serializeByKind(iHeap, i);
                }
            }
            this.iPrevHeapArray[tCode] = iHeap;
            if (!this.doMeasurements) continue;
            this.sm.statDetails[typeCode_i].incr(DataIO.lengthVnumber(tCode));
            ++this.sm.mainHeapFSs;
        }
        this.processIndexedFeatureStructures(this.cas, true);
        if (this.isSerializingDelta) {
            smfs.serializeModifiedFSs();
        }
        this.collectAndZip();
        if (this.doMeasurements) {
            this.sm.totalTime = System.currentTimeMillis() - this.sm.totalTime;
        }
        return this.sm;
    }

    private void serializeHeapStoredArray(int iHeap) throws IOException {
        int length = this.serializeArrayLength(iHeap);
        if (length == 0) {
            return;
        }
        SlotKinds.SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
        int endi = iHeap + length + 2;
        switch (arrayElementKind) {
            case Slot_HeapRef: 
            case Slot_Int: {
                int startIheap;
                int prev = this.iPrevHeap == 0 ? 0 : (this.heap[this.iPrevHeap + 1] == 0 ? 0 : this.getPrevIntValue(iHeap, 2));
                for (int i = startIheap = iHeap + 2; i < endi; ++i) {
                    int maybeConverted = this.writeIntOrHeapRef(arrayElementKind.ordinal(), i, prev);
                    if (this.isUpdatePrevOK && i == startIheap) {
                        this.updatePrevIntValue(iHeap, 2, maybeConverted);
                    }
                    prev = maybeConverted;
                }
                break;
            }
            case Slot_Float: {
                for (int i = iHeap + 2; i < endi; ++i) {
                    this.writeFloat(this.heap[i]);
                }
                break;
            }
            case Slot_StrRef: {
                for (int i = iHeap + 2; i < endi; ++i) {
                    this.writeString(this.stringHeapObj.getStringForCode(this.heap[i]));
                }
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    private int writeIntOrHeapRef(int kind, int index, int prev) throws IOException {
        int v = this.heap[index];
        return this.writeDiff(kind, v, prev);
    }

    private long writeLongFromHeapIndex(int index, long prev) throws IOException {
        long v = this.longHeapObj.getHeapValue(this.heap[index]);
        this.writeLong(v, prev);
        return v;
    }

    private void serializeNonHeapStoredArray(int iHeap) throws IOException {
        int length = this.serializeArrayLength(iHeap);
        if (length == 0) {
            return;
        }
        SlotKinds.SlotKind refKind = this.typeInfo.getSlotKind(2);
        switch (refKind) {
            case Slot_BooleanRef: 
            case Slot_ByteRef: {
                this.writeFromByteArray(refKind, this.heap[iHeap + 2], length);
                if (!this.doMeasurements) break;
                this.sm.statDetails[byte_i].incr(1);
                this.sm.origAuxByteArrayRefs += 4L;
                break;
            }
            case Slot_ShortRef: {
                this.writeFromShortArray(this.heap[iHeap + 2], length);
                if (!this.doMeasurements) break;
                this.sm.origAuxShortArrayRefs += 4L;
                break;
            }
            case Slot_LongRef: 
            case Slot_DoubleRef: {
                this.writeFromLongArray(refKind, this.heap[iHeap + 2], length);
                if (!this.doMeasurements) break;
                this.sm.origAuxLongArrayRefs += 4L;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void serializeByKind(int iHeap, int offset) throws IOException {
        SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(offset);
        switch (kind) {
            case Slot_HeapRef: 
            case Slot_Int: 
            case Slot_Short: {
                this.serializeDiffWithPrevTypeSlot(kind, iHeap, offset);
                break;
            }
            case Slot_Float: {
                this.writeFloat(this.heap[iHeap + offset]);
                break;
            }
            case Slot_Boolean: 
            case Slot_Byte: {
                this.byte_dos.write(this.heap[iHeap + offset]);
                break;
            }
            case Slot_StrRef: {
                this.writeString(this.stringHeapObj.getStringForCode(this.heap[iHeap + offset]));
                break;
            }
            case Slot_LongRef: {
                this.writeLongFromHeapIndex(iHeap + offset, this.iPrevHeap == 0 ? 0L : this.longHeapObj.getHeapValue(this.heap[this.iPrevHeap + offset]));
                break;
            }
            case Slot_DoubleRef: {
                this.writeDouble(this.longHeapObj.getHeapValue(this.heap[iHeap + offset]));
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    private int serializeArrayLength(int iHeap) throws IOException {
        int length = this.heap[iHeap + 1];
        this.writeVnumber(arrayLength_i, length);
        return length;
    }

    private void serializeDiffWithPrevTypeSlot(SlotKinds.SlotKind kind, int iHeap, int offset) throws IOException {
        int prev = this.iPrevHeap == 0 ? 0 : this.getPrevIntValue(iHeap, offset);
        int newValue = this.heap[iHeap + offset];
        int maybeConverted = this.writeDiff(kind.ordinal(), newValue, prev);
        if (this.isUpdatePrevOK) {
            this.updatePrevIntValue(iHeap, offset, maybeConverted);
        }
    }

    private void updatePrevIntValue(int iHeap, int offset, int newValue) {
        int[] featCache = this.initPrevIntValue(iHeap);
        featCache[offset - 1] = newValue;
    }

    private int[] initPrevIntValue(int iHeap) {
        int[] featCache = this.prevHeapInstanceWithIntValues[this.heap[iHeap]];
        if (null == featCache) {
            int[] nArray = new int[this.typeInfo.slotKinds.length];
            this.prevHeapInstanceWithIntValues[this.heap[iHeap]] = nArray;
            return nArray;
        }
        return featCache;
    }

    private int getPrevIntValue(int iHeap, int offset) {
        int[] featCache = this.prevHeapInstanceWithIntValues[this.heap[iHeap]];
        if (null == featCache) {
            return 0;
        }
        return featCache[offset - 1];
    }

    private void collectAndZip() throws IOException {
        int i;
        ByteArrayOutputStream baosZipped = new ByteArrayOutputStream(4096);
        Deflater deflater = new Deflater(this.compressLevel.lvl, true);
        deflater.setStrategy(this.compressStrategy.strat);
        int nbrEntries = 0;
        ArrayList<Integer> idxAndLen = new ArrayList<Integer>();
        for (i = 0; i < this.baosZipSources.length; ++i) {
            ByteArrayOutputStream baos = this.baosZipSources[i];
            if (baos == null) continue;
            ++nbrEntries;
            this.dosZipSources[i].close();
            long startTime = System.currentTimeMillis();
            int zipBufSize = Math.max(1024, baos.size() / 100);
            deflater.reset();
            DeflaterOutputStream cds = new DeflaterOutputStream((OutputStream)baosZipped, deflater, zipBufSize);
            baos.writeTo(cds);
            cds.close();
            idxAndLen.add(i);
            if (this.doMeasurements) {
                this.sm.statDetails[i].afterZip = deflater.getBytesWritten();
                idxAndLen.add((int)this.sm.statDetails[i].afterZip);
                this.sm.statDetails[i].beforeZip = deflater.getBytesRead();
                idxAndLen.add((int)this.sm.statDetails[i].beforeZip);
                this.sm.statDetails[i].zipTime = System.currentTimeMillis() - startTime;
                continue;
            }
            idxAndLen.add((int)deflater.getBytesWritten());
            idxAndLen.add((int)deflater.getBytesRead());
        }
        this.serializedOut.writeInt(nbrEntries);
        i = 0;
        while (i < idxAndLen.size()) {
            this.serializedOut.write((Integer)idxAndLen.get(i++));
            this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
            this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
        }
        baosZipped.writeTo(this.serializedOut);
    }

    private void writeLong(long v, long prev) throws IOException {
        this.writeDiff(long_High_i, (int)(v >>> 32), (int)(prev >>> 32));
        this.writeDiff(long_Low_i, (int)v, (int)prev);
    }

    private void writeString(String s) throws IOException {
        if (null == s) {
            this.writeVnumber(this.strLength_dos, 0);
            if (this.doMeasurements) {
                this.sm.statDetails[strLength_i].incr(1);
            }
            return;
        }
        int indexOrSeq = this.os.getIndexOrSeqIndex(s);
        if (indexOrSeq < 0) {
            int v = this.encodeIntSign(indexOrSeq);
            this.writeVnumber(this.strLength_dos, v);
            if (this.doMeasurements) {
                this.sm.statDetails[strLength_i].incr(DataIO.lengthVnumber(v));
            }
            return;
        }
        if (s.length() == 0) {
            this.writeVnumber(this.strLength_dos, this.encodeIntSign(1));
            if (this.doMeasurements) {
                this.sm.statDetails[strLength_i].incr(1);
            }
            return;
        }
        if (s.length() == Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot serialize string of Integer.MAX_VALUE length - too large.");
        }
        int offset = this.os.getOffset(indexOrSeq);
        int length = this.encodeIntSign(s.length() + 1);
        this.writeVnumber(this.strOffset_dos, offset);
        this.writeVnumber(this.strLength_dos, length);
        if (this.doMeasurements) {
            this.sm.statDetails[strOffset_i].incr(DataIO.lengthVnumber(offset));
            this.sm.statDetails[strLength_i].incr(DataIO.lengthVnumber(length));
        }
        if (!this.only1CommonString) {
            int csi = this.os.getCommonStringIndex(indexOrSeq);
            this.writeVnumber(this.strSeg_dos, csi);
            if (this.doMeasurements) {
                this.sm.statDetails[strSeg_i].incr(DataIO.lengthVnumber(csi));
            }
        }
    }

    private void writeFloat(int raw) throws IOException {
        if (raw == 0) {
            this.writeUnsignedByte(this.float_Exponent_dos, 0);
            if (this.doMeasurements) {
                this.sm.statDetails[float_Exponent_i].incr(1);
            }
            return;
        }
        int exponent = (raw >>> 23 & 0xFF) + 1;
        int revMants = Integer.reverse((raw & 0x7FFFFF) << 9);
        int mants = (revMants << 1) + (raw < 0 ? 1 : 0);
        this.writeVnumber(this.float_Exponent_dos, exponent);
        this.writeVnumber(this.float_Mantissa_Sign_dos, mants);
        if (this.doMeasurements) {
            this.sm.statDetails[float_Exponent_i].incr(DataIO.lengthVnumber(exponent));
            this.sm.statDetails[float_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
        }
    }

    private void writeVnumber(int kind, int v) throws IOException {
        DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
        if (this.doMeasurements) {
            this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
        }
    }

    private void writeVnumber(int kind, long v) throws IOException {
        DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
        if (this.doMeasurements) {
            this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
        }
    }

    private void writeVnumber(DataOutputStream s, int v) throws IOException {
        DataIO.writeVnumber((DataOutput)s, v);
    }

    private void writeVnumber(DataOutputStream s, long v) throws IOException {
        DataIO.writeVnumber((DataOutput)s, v);
    }

    private void writeUnsignedByte(DataOutputStream s, int v) throws IOException {
        s.write(v);
    }

    private void writeDouble(long raw) throws IOException {
        if (raw == 0L) {
            this.writeVnumber(this.double_Exponent_dos, 0);
            if (this.doMeasurements) {
                this.sm.statDetails[double_Exponent_i].incr(1);
            }
            return;
        }
        int exponent = (int)(raw >>> 52 & 0x7FFL);
        if ((exponent -= 1023) >= 0) {
            ++exponent;
        }
        exponent = this.encodeIntSign(exponent);
        long revMants = Long.reverse((raw & 0xFFFFFFFFFFFFFL) << 12);
        long mants = (revMants << 1) + (long)(raw < 0L ? 1 : 0);
        this.writeVnumber(this.double_Exponent_dos, exponent);
        this.writeVnumber(this.double_Mantissa_Sign_dos, mants);
        if (this.doMeasurements) {
            this.sm.statDetails[double_Exponent_i].incr(DataIO.lengthVnumber(exponent));
            this.sm.statDetails[double_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
        }
    }

    private int encodeIntSign(int v) {
        if (v < 0) {
            return -v << 1 | 1;
        }
        return v << 1;
    }

    private int writeDiff(int kind, int v, int prev) throws IOException {
        if (v == 0) {
            this.write0(kind);
            this.isUpdatePrevOK = false;
            return 0;
        }
        if (v == Integer.MIN_VALUE) {
            this.writeVnumber(kind, 2);
            if (this.doMeasurements) {
                ++this.sm.statDetails[kind].diffEncoded;
                ++this.sm.statDetails[kind].valueLeDiff;
            }
            this.isUpdatePrevOK = false;
            return 0;
        }
        if (kind == heapRef_i || kind == fsIndexes_i) {
            if (!this.isInstanceInTgtTs(v)) {
                this.write0(kind);
                this.isUpdatePrevOK = false;
                return 0;
            }
            if ((v = this.fsStartIndexes.getTgtSeqFromSrcAddr(v)) == -1) {
                if (kind == fsIndexes_i) {
                    throw new RuntimeException();
                }
                this.write0(kind);
                this.isUpdatePrevOK = false;
                return 0;
            }
        }
        int absV = Math.abs(v);
        if (v > 0 && prev > 0 || v < 0 && prev < 0) {
            int absDiff;
            int diff = v - prev;
            int n = absDiff = diff < 0 ? -diff : diff;
            if (absDiff < 0) {
                System.err.format("********* caught absdiff v = %s, prev = %s diff = %s absDiff = %s%n", Integer.toHexString(v), Integer.toHexString(prev), Integer.toHexString(diff), Integer.toHexString(absDiff));
            }
            if (absV < 0) {
                System.err.format("********* caught absv v = %s, absV = %s%n", Integer.toHexString(v), Integer.toHexString(absV));
            }
            this.writeVnumber(kind, absV <= absDiff ? ((long)absV << 2) + (v < 0 ? 2L : 0L) : ((long)absDiff << 2) + (diff < 0 ? 3L : 1L));
            if (this.doMeasurements) {
                ++this.sm.statDetails[kind].diffEncoded;
                this.sm.statDetails[kind].valueLeDiff = this.sm.statDetails[kind].valueLeDiff + (absV <= absDiff ? 1L : 0L);
            }
            this.isUpdatePrevOK = true;
            return v;
        }
        this.writeVnumber(kind, ((long)absV << 2) + (long)(v < 0 ? 2 : 0));
        if (this.doMeasurements) {
            ++this.sm.statDetails[kind].diffEncoded;
            ++this.sm.statDetails[kind].valueLeDiff;
        }
        this.isUpdatePrevOK = true;
        return v;
    }

    private void write0(int kind) throws IOException {
        this.writeVnumber(kind, 0);
        if (this.doMeasurements) {
            ++this.sm.statDetails[kind].diffEncoded;
            ++this.sm.statDetails[kind].valueLeDiff;
        }
    }

    private void writeFromByteArray(SlotKinds.SlotKind kind, int startPos, int length) throws IOException {
        this.byte_dos.write(this.byteHeapObj.heap, startPos, length);
    }

    private void writeFromLongArray(SlotKinds.SlotKind kind, int startPos, int length) throws IOException {
        long[] h = this.longHeapObj.heap;
        int endPos = startPos + length;
        long prev = 0L;
        for (int i = startPos; i < endPos; ++i) {
            long e = h[i];
            if (kind == SlotKinds.SlotKind.Slot_DoubleRef) {
                this.writeDouble(e);
                continue;
            }
            this.writeLong(e, prev);
            prev = e;
        }
    }

    private void writeFromShortArray(int startPos, int length) throws IOException {
        short[] h = this.shortHeapObj.heap;
        int endPos = startPos + length;
        int prev = 0;
        for (int i = startPos; i < endPos; ++i) {
            int e = h[i];
            this.writeDiff(short_i, e, prev);
            prev = e;
        }
    }

    public void deserialize(InputStream istream) throws IOException {
        CommonSerDes.Header h = this.readHeader(istream);
        if (this.isReadingDelta) {
            if (!this.reuseInfoProvided) {
                throw new UnsupportedOperationException("Deserializing Delta Cas, but original not serialized from");
            }
        } else {
            this.cas.resetNoQuestions();
        }
        this.cas.reinit(h, this.deserIn, null, CasLoadMode.DEFAULT, this, AllowPreexistingFS.allow, null);
    }

    public void deserialize(InputStream istream, AllowPreexistingFS allowPreexistingFS) throws IOException {
        CommonSerDes.Header h = this.readHeader(istream);
        if (this.isReadingDelta) {
            if (!this.reuseInfoProvided) {
                throw new UnsupportedOperationException("Deserializing Delta Cas, but original not serialized from");
            }
        } else {
            throw new UnsupportedOperationException("Delta CAS required for this call");
        }
        this.cas.reinit(h, this.deserIn, null, CasLoadMode.DEFAULT, this, allowPreexistingFS, null);
    }

    public void deserializeAfterVersion(DataInputStream istream, boolean isDelta, AllowPreexistingFS allowPreexistingFS) throws IOException {
        int targetHeapUsed;
        this.allowPreexistingFS = allowPreexistingFS;
        if (allowPreexistingFS == AllowPreexistingFS.ignore) {
            throw new UnsupportedOperationException("AllowPreexistingFS.ignore not an allowed setting");
        }
        this.deserIn = istream;
        this.isDelta = this.isReadingDelta = isDelta;
        this.setupReadStreams();
        int lenCmnStrs = this.readVnumber(this.strChars_dis);
        this.readCommonString = new String[lenCmnStrs];
        for (int i = 0; i < lenCmnStrs; ++i) {
            this.readCommonString[i] = DataIO.readUTFv(this.strChars_dis);
        }
        this.only1CommonString = lenCmnStrs == 1;
        int heapUsedInTarget = this.readVnumber(this.control_dis);
        Heap heapObj = this.cas.getHeap();
        this.heapStart = this.isReadingDelta ? heapObj.getNextId() : 0;
        int n = this.stringTableOffset = this.isReadingDelta ? this.stringHeapObj.getSize() - 1 : 0;
        if (!this.isReadingDelta) {
            heapObj.reinitSizeOnly(1);
            this.heap = heapObj.heap;
        }
        Arrays.fill(this.iPrevHeapArray, 0);
        Arrays.fill((Object[])this.prevHeapInstanceWithIntValues, null);
        if (this.heapStart == 0) {
            this.heapStart = 1;
        }
        if (this.isReadingDelta && !this.reuseInfoProvided) {
            throw new IllegalStateException("Reading Delta into CAS not serialized from");
        }
        this.fixupsNeeded = new IntVector(Math.max(16, heapObj.getCellsUsed() / 10));
        int iHeap = this.heapStart;
        int n2 = targetHeapUsed = this.isReadingDelta ? 0 : 1;
        while (targetHeapUsed < heapUsedInTarget) {
            TypeSystemImpl.TypeInfo srcTypeInfo;
            TypeSystemImpl.TypeInfo tgtTypeInfo;
            if (iHeap != heapObj.getNextId()) {
                throw new RuntimeException();
            }
            int tgtTypeCode = this.readVnumber(this.typeCode_dis);
            int srcTypeCode = this.isTypeMapping ? this.typeMapper.mapTypeCodeTgt2Src(tgtTypeCode) : tgtTypeCode;
            boolean storeIt = srcTypeCode != 0;
            TypeSystemImpl.TypeInfo typeInfo = tgtTypeInfo = this.isTypeMapping ? this.tgtTs.getTypeInfo(tgtTypeCode) : this.ts.getTypeInfo(srcTypeCode);
            TypeSystemImpl.TypeInfo typeInfo2 = !this.isTypeMapping ? tgtTypeInfo : (srcTypeInfo = storeIt ? this.ts.getTypeInfo(srcTypeCode) : null);
            if (storeIt) {
                this.typeInfo = tgtTypeInfo;
                this.initPrevIntValue(iHeap);
            }
            this.typeInfo = storeIt ? srcTypeInfo : tgtTypeInfo;
            this.fsStartIndexes.addSrcAddrForTgt(iHeap, storeIt);
            if (storeIt) {
                this.iPrevHeap = this.iPrevHeapArray[srcTypeCode];
            }
            if (this.typeInfo.isHeapStoredArray) {
                this.readHeapStoredArray(iHeap, storeIt, heapObj, srcTypeCode);
            } else if (this.typeInfo.isArray) {
                if (storeIt) {
                    heapObj.add(3, srcTypeCode);
                    this.heap = heapObj.heap;
                }
                this.readNonHeapStoredArray(iHeap, storeIt);
            } else {
                if (storeIt) {
                    this.cas.ll_createFS(srcTypeCode);
                    this.heap = heapObj.heap;
                }
                if (this.isTypeMapping && storeIt) {
                    int[] tgtFeatOffsets2Src = this.typeMapper.getTgtFeatOffsets2Src(srcTypeCode);
                    for (int i = 0; i < tgtFeatOffsets2Src.length; ++i) {
                        int featOffsetInSrc = tgtFeatOffsets2Src[i] + 1;
                        SlotKinds.SlotKind kind = tgtTypeInfo.slotKinds[i];
                        this.readByKind(iHeap, featOffsetInSrc, kind, storeIt);
                    }
                } else {
                    for (int i = 1; i < this.typeInfo.slotKinds.length + 1; ++i) {
                        SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(i);
                        this.readByKind(iHeap, i, kind, storeIt);
                    }
                }
            }
            if (storeIt) {
                this.iPrevHeapArray[srcTypeCode] = iHeap;
            }
            targetHeapUsed += BinaryCasSerDes6.incrToNextFs(this.heap, iHeap, tgtTypeInfo);
            iHeap += storeIt ? BinaryCasSerDes6.incrToNextFs(this.heap, iHeap, srcTypeInfo) : 0;
        }
        int end = this.fixupsNeeded.size();
        for (int i = 0; i < end; ++i) {
            int heapAddrToFix = this.fixupsNeeded.get(i);
            this.heap[heapAddrToFix] = this.fsStartIndexes.getSrcAddrFromTgtSeq(this.heap[heapAddrToFix]);
        }
        this.readIndexedFeatureStructures();
        if (this.isReadingDelta) {
            new ReadModifiedFSs().readModifiedFSs();
        }
        this.closeDataInputs();
    }

    private void readNonHeapStoredArray(int iHeap, boolean storeIt) throws IOException {
        int length = this.readArrayLength();
        if (storeIt) {
            this.heap[iHeap + 1] = length;
        }
        if (length == 0) {
            return;
        }
        SlotKinds.SlotKind refKind = this.typeInfo.getSlotKind(2);
        switch (refKind) {
            case Slot_BooleanRef: 
            case Slot_ByteRef: {
                int byteRef = this.readIntoByteArray(length, storeIt);
                if (!storeIt) break;
                this.heap[iHeap + 2] = byteRef;
                break;
            }
            case Slot_ShortRef: {
                int shortRef = this.readIntoShortArray(length, storeIt);
                if (!storeIt) break;
                this.heap[iHeap + 2] = shortRef;
                break;
            }
            case Slot_LongRef: 
            case Slot_DoubleRef: {
                int longDblRef = this.readIntoLongArray(refKind, length, storeIt);
                if (!storeIt) break;
                this.heap[iHeap + 2] = longDblRef;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private int readArrayLength() throws IOException {
        return this.readVnumber(this.arrayLength_dis);
    }

    private void readHeapStoredArray(int iHeap, boolean storeIt, Heap heapObj, int srcTypeCode) throws IOException {
        int length = this.readArrayLength();
        if (storeIt) {
            heapObj.add(2 + length, srcTypeCode);
            this.heap = heapObj.heap;
            this.heap[iHeap + 1] = length;
        }
        if (length == 0) {
            return;
        }
        SlotKinds.SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
        int endi = iHeap + length + 2;
        switch (arrayElementKind) {
            case Slot_HeapRef: 
            case Slot_Int: {
                int startIheap;
                int prev = this.iPrevHeap == 0 ? 0 : (this.heap[this.iPrevHeap + 1] == 0 ? 0 : this.getPrevIntValue(iHeap, 2));
                for (int i = startIheap = iHeap + 2; i < endi; ++i) {
                    int v;
                    prev = v = this.readDiff(arrayElementKind, prev);
                    if (startIheap == i && this.isUpdatePrevOK && storeIt) {
                        this.updatePrevIntValue(iHeap, 2, v);
                    }
                    if (!storeIt) continue;
                    this.heap[i] = v;
                    if (arrayElementKind != SlotKinds.SlotKind.Slot_HeapRef) continue;
                    this.fixupsNeeded.add(i);
                }
                break;
            }
            case Slot_Float: {
                for (int i = iHeap + 2; i < endi; ++i) {
                    int floatRef = this.readFloat();
                    if (!storeIt) continue;
                    this.heap[i] = floatRef;
                }
                break;
            }
            case Slot_StrRef: {
                for (int i = iHeap + 2; i < endi; ++i) {
                    int strRef = this.readString(storeIt);
                    if (!storeIt) continue;
                    this.heap[i] = strRef;
                }
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    private void readByKind(int iHeap, int offset, SlotKinds.SlotKind kind, boolean storeIt) throws IOException {
        if (offset == 0) {
            storeIt = false;
        }
        switch (kind) {
            case Slot_Int: 
            case Slot_Short: {
                this.readDiffWithPrevTypeSlot(kind, iHeap, offset, storeIt);
                break;
            }
            case Slot_Float: {
                int floatAsInt = this.readFloat();
                if (!storeIt) break;
                this.heap[iHeap + offset] = floatAsInt;
                break;
            }
            case Slot_Boolean: 
            case Slot_Byte: {
                byte vByte = this.byte_dis.readByte();
                if (!storeIt) break;
                this.heap[iHeap + offset] = vByte;
                break;
            }
            case Slot_HeapRef: {
                this.readDiffWithPrevTypeSlot(kind, iHeap, offset, storeIt);
                if (!storeIt) break;
                this.fixupsNeeded.add(iHeap + offset);
                break;
            }
            case Slot_StrRef: {
                int vStrRef = this.readString(storeIt);
                if (!storeIt) break;
                this.heap[iHeap + offset] = vStrRef;
                break;
            }
            case Slot_LongRef: {
                long v = this.readLongOrDouble(kind, !storeIt || this.iPrevHeap == 0 ? 0L : this.longHeapObj.getHeapValue(this.heap[this.iPrevHeap + offset]));
                if (v == 0L) {
                    if (this.longZeroIndex == -1) {
                        this.longZeroIndex = this.longHeapObj.addLong(0L);
                    }
                    if (!storeIt) break;
                    this.heap[iHeap + offset] = this.longZeroIndex;
                    break;
                }
                if (!storeIt) break;
                this.heap[iHeap + offset] = this.longHeapObj.addLong(v);
                break;
            }
            case Slot_DoubleRef: {
                long v = this.readDouble();
                if (v == 0L) {
                    if (this.longZeroIndex == -1) {
                        this.longZeroIndex = this.longHeapObj.addLong(0L);
                    }
                    if (!storeIt) break;
                    this.heap[iHeap + offset] = this.longZeroIndex;
                    break;
                }
                if (v == DBL_1) {
                    if (this.double1Index == -1) {
                        this.double1Index = this.longHeapObj.addLong(DBL_1);
                    }
                    if (!storeIt) break;
                    this.heap[iHeap + offset] = this.double1Index;
                    break;
                }
                if (!storeIt) break;
                this.heap[iHeap + offset] = this.longHeapObj.addLong(v);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    private void readIndexedFeatureStructures() throws IOException {
        int i;
        int nbrViews = this.readVnumber(this.control_dis);
        int nbrSofas = this.readVnumber(this.control_dis);
        IntVector fsIndexes = new IntVector(nbrViews + nbrSofas + 100);
        fsIndexes.add(nbrViews);
        fsIndexes.add(nbrSofas);
        for (i = 0; i < nbrSofas; ++i) {
            int realAddrOfSofa = this.fsStartIndexes.getSrcAddrFromTgtSeq(this.readVnumber(this.control_dis));
            fsIndexes.add(realAddrOfSofa);
        }
        for (i = 0; i < nbrViews; ++i) {
            this.readFsxPart(fsIndexes);
            if (!this.isDelta) continue;
            this.readFsxPart(fsIndexes);
            this.readFsxPart(fsIndexes);
        }
        if (this.isDelta) {
            this.cas.reinitDeltaIndexedFSs(fsIndexes.getArray());
        } else {
            this.cas.reinitIndexedFSs(fsIndexes.getArray());
        }
    }

    private void readFsxPart(IntVector fsIndexes) throws IOException {
        int nbrEntries = this.readVnumber(this.control_dis);
        int nbrEntriesAdded = 0;
        int indexOfNbrAdded = fsIndexes.size();
        fsIndexes.add(0);
        int prev = 0;
        for (int i = 0; i < nbrEntries; ++i) {
            int v;
            prev = v = this.readVnumber(this.fsIndexes_dis) + prev;
            if ((v = this.fsStartIndexes.getSrcAddrFromTgtSeq(v)) <= 0) continue;
            ++nbrEntriesAdded;
            fsIndexes.add(v);
        }
        fsIndexes.set(indexOfNbrAdded, nbrEntriesAdded);
    }

    private DataInput getInputStream(SlotKinds.SlotKind kind) {
        return this.dataInputs[kind.ordinal()];
    }

    private int readVnumber(DataInputStream dis) throws IOException {
        return DataIO.readVnumber(dis);
    }

    private long readVlong(DataInputStream dis) throws IOException {
        return DataIO.readVlong(dis);
    }

    private int readIntoByteArray(int length, boolean storeIt) throws IOException {
        if (storeIt) {
            int startPos = this.byteHeapObj.reserve(length);
            this.byte_dis.readFully(this.byteHeapObj.heap, startPos, length);
            return startPos;
        }
        BinaryCasSerDes6.skipBytes(this.byte_dis, length);
        return 0;
    }

    private int readIntoShortArray(int length, boolean storeIt) throws IOException {
        if (storeIt) {
            int startPos = this.shortHeapObj.reserve(length);
            short[] h = this.shortHeapObj.heap;
            int endPos = startPos + length;
            int prev = 0;
            for (int i = startPos; i < endPos; ++i) {
                prev = (short)this.readDiff(this.short_dis, prev);
            }
            return startPos;
        }
        BinaryCasSerDes6.skipBytes(this.short_dis, length * 2);
        return 0;
    }

    private int readIntoLongArray(SlotKinds.SlotKind kind, int length, boolean storeIt) throws IOException {
        if (storeIt) {
            int startPos = this.longHeapObj.reserve(length);
            long[] h = this.longHeapObj.heap;
            int endPos = startPos + length;
            long prev = 0L;
            for (int i = startPos; i < endPos; ++i) {
                h[i] = prev = this.readLongOrDouble(kind, prev);
            }
            return startPos;
        }
        if (kind == SlotKinds.SlotKind.Slot_LongRef) {
            this.skipLong(length);
        } else {
            this.skipDouble(length);
        }
        return 0;
    }

    private void readDiffWithPrevTypeSlot(SlotKinds.SlotKind kind, int iHeap, int offset, boolean storeIt) throws IOException {
        int v;
        if (storeIt) {
            int prev = this.iPrevHeap == 0 ? 0 : this.getPrevIntValue(iHeap, offset);
            this.heap[iHeap + offset] = v = this.readDiff(kind, prev);
        } else {
            v = this.readDiff(kind, 0);
        }
        if (storeIt && this.isUpdatePrevOK) {
            this.updatePrevIntValue(iHeap, offset, v);
        }
    }

    private int readDiff(SlotKinds.SlotKind kind, int prev) throws IOException {
        return this.readDiff(this.getInputStream(kind), prev);
    }

    private int readDiff(DataInput in, int prev) throws IOException {
        long encoded = this.readVlong(in);
        boolean bl = this.isUpdatePrevOK = encoded != 0L;
        if (!this.isUpdatePrevOK) {
            return 0;
        }
        boolean isDeltaEncoded = 0L != (encoded & 1L);
        boolean isNegative = 0L != (encoded & 2L);
        int v = (int)(encoded >>> 2);
        if (isNegative) {
            if (v == 0) {
                this.isUpdatePrevOK = false;
                return Integer.MIN_VALUE;
            }
            v = -v;
        }
        if (isDeltaEncoded) {
            v += prev;
        }
        return v;
    }

    private long readLongOrDouble(SlotKinds.SlotKind kind, long prev) throws IOException {
        if (kind == SlotKinds.SlotKind.Slot_DoubleRef) {
            return this.readDouble();
        }
        int vh = this.readDiff(this.long_High_dis, (int)(prev >>> 32));
        int vl = this.readDiff(this.long_Low_dis, (int)prev);
        long v = (long)vh << 32 | 0xFFFFFFFFL & (long)vl;
        return v;
    }

    private void skipLong(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            BinaryCasSerDes6.skipBytes(this.long_High_dis, 8);
            BinaryCasSerDes6.skipBytes(this.long_Low_dis, 8);
        }
    }

    private void skipDouble(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.readDouble();
        }
    }

    private int readFloat() throws IOException {
        int exponent = this.readVnumber(this.float_Exponent_dis);
        if (exponent == 0) {
            return 0;
        }
        int mants = this.readVnumber(this.float_Mantissa_Sign_dis);
        boolean isNegative = (mants & 1) == 1;
        mants >>>= 1;
        mants = Integer.reverse(mants) >>> 9;
        return exponent - 1 << 23 | mants | (isNegative ? Integer.MIN_VALUE : 0);
    }

    private int decodeIntSign(int v) {
        if (1 == (v & 1)) {
            return -(v >>> 1);
        }
        return v >>> 1;
    }

    private long readDouble() throws IOException {
        int exponent = this.readVnumber(this.double_Exponent_dis);
        if (exponent == 0) {
            return 0L;
        }
        long mants = this.readVlong(this.double_Mantissa_Sign_dis);
        return this.decodeDouble(mants, exponent);
    }

    private long decodeDouble(long mants, int exponent) {
        if ((exponent = this.decodeIntSign(exponent)) > 0) {
            --exponent;
        }
        long r = (long)((exponent += 1023) & 0x7FF) << 52;
        boolean isNegative = 1L == (mants & 1L);
        mants = Long.reverse(mants >>> 1) >>> 12;
        r = r | mants | (isNegative ? Long.MIN_VALUE : 0L);
        return r;
    }

    private long readVlong(DataInput dis) throws IOException {
        return DataIO.readVlong(dis);
    }

    private int readString(boolean storeIt) throws IOException {
        int length = this.decodeIntSign(this.readVnumber(this.strLength_dis));
        if (0 == length) {
            return 0;
        }
        if (1 == length) {
            return this.stringHeapObj.addString("");
        }
        if (length < 0) {
            if (storeIt) {
                return this.stringTableOffset - length;
            }
            return 0;
        }
        int offset = this.readVnumber(this.strOffset_dis);
        int segmentIndex = this.only1CommonString ? 0 : this.readVnumber(this.strSeg_dis);
        String s = this.readCommonString[segmentIndex].substring(offset, offset + length - 1);
        return this.stringHeapObj.addString(s);
    }

    static void skipBytes(DataInputStream stream, int skipNumber) throws IOException {
        int r = stream.skipBytes(skipNumber);
        if (r != skipNumber) {
            throw new IOException(String.format("%d bytes skipped when %d was requested, causing out-of-synch while deserializing from stream %s", r, skipNumber, stream));
        }
    }

    private static int incrToNextFs(int[] heap, int iHeap, TypeSystemImpl.TypeInfo typeInfo) {
        if (typeInfo.isHeapStoredArray) {
            return 2 + heap[iHeap + 1];
        }
        return 1 + typeInfo.slotKinds.length;
    }

    private void processIndexedFeatureStructures(CASImpl cas, boolean isWrite) throws IOException {
        int fi;
        int[] fsIndexes;
        if (!isWrite) {
            this.foundFSs = new BitSet(Math.max(1024, cas.getHeap().getCellsUsed()));
            BitSet bitSet = this.foundFSsBelowMark = this.isSerializingDelta ? new BitSet(this.mark.nextByteHeapAddr) : null;
        }
        int[] nArray = isWrite ? (this.isSerializingDelta ? cas.getDeltaIndexedFSs(this.mark) : this.savedAllIndexesFSs) : (fsIndexes = cas.getIndexedFSs());
        if (!isWrite) {
            this.savedAllIndexesFSs = fsIndexes;
            this.toBeScanned.removeAllElements();
        }
        int nbrViews = fsIndexes[0];
        int nbrSofas = fsIndexes[1];
        if (isWrite) {
            if (this.doMeasurements) {
                this.sm.statDetails[BinaryCasSerDes6.fsIndexes_i].original = fsIndexes.length * 4 + 1;
            }
            this.writeVnumber(control_i, nbrViews);
            this.writeVnumber(control_i, nbrSofas);
            if (this.doMeasurements) {
                this.sm.statDetails[fsIndexes_i].incr(1);
                this.sm.statDetails[fsIndexes_i].incr(1);
            }
        }
        int end1 = nbrSofas + 2;
        for (fi = 2; fi < end1; ++fi) {
            int addrSofaFs = fsIndexes[fi];
            if (isWrite) {
                int v = this.fsStartIndexes.getTgtSeqFromSrcAddr(addrSofaFs);
                this.writeVnumber(control_i, v);
                if (!this.doMeasurements) continue;
                this.sm.statDetails[fsIndexes_i].incr(DataIO.lengthVnumber(v));
                continue;
            }
            this.enqueueFS(addrSofaFs);
        }
        this.heap = cas.getHeap().heap;
        for (int vi = 0; vi < nbrViews; ++vi) {
            fi = this.processFsxPart(fsIndexes, fi, true, isWrite);
            if (!isWrite || !this.isSerializingDelta) continue;
            fi = this.processFsxPart(fsIndexes, fi, false, true);
            fi = this.processFsxPart(fsIndexes, fi, false, true);
        }
        this.processRefedFSs();
        if (!isWrite) {
            int fsslen = this.foundFSs.cardinality();
            this.foundFSsArray = new int[fsslen];
            int len = this.foundFSs.length();
            int b = 0;
            int i = 0;
            while (b < len) {
                b = this.foundFSs.nextSetBit(b);
                this.foundFSsArray[i] = b++;
                ++i;
            }
        }
    }

    private int processFsxPart(int[] fsIndexes, int fsNdxStart, boolean isDoingEnqueue, boolean isWrite) throws IOException {
        int ix = fsNdxStart;
        int nbrEntries = fsIndexes[ix++];
        int end = ix + nbrEntries;
        int[] ia = new int[nbrEntries];
        System.arraycopy(fsIndexes, ix, ia, 0, nbrEntries);
        Arrays.sort(ia);
        int prev = 0;
        int entriesWritten = 0;
        for (int i = 0; i < ia.length; ++i) {
            int fsAddr = ia[i];
            if (isWrite) {
                if (this.isTypeMapping && 0 == this.typeMapper.mapTypeCodeSrc2Tgt(this.heap[fsAddr])) continue;
                int tgtV = this.fsStartIndexes.getTgtSeqFromSrcAddr(fsAddr);
                if (tgtV == -1) {
                    throw new RuntimeException();
                }
                int delta = tgtV - prev;
                ++entriesWritten;
                this.writeVnumber(this.fsIndexes_dos, delta);
                if (this.doMeasurements) {
                    this.sm.statDetails[fsIndexes_i].incr(DataIO.lengthVnumber(delta));
                }
                prev = tgtV;
                continue;
            }
            if (!isDoingEnqueue) continue;
            this.enqueueFS(fsAddr);
        }
        if (isWrite) {
            this.writeVnumber(this.control_dos, entriesWritten);
            if (this.doMeasurements) {
                this.sm.statDetails[typeCode_i].incr(DataIO.lengthVnumber(entriesWritten));
            }
        }
        return end;
    }

    private void enqueueFS(int fsAddr) {
        if (!this.isInstanceInTgtTs(fsAddr)) {
            return;
        }
        if (0 != fsAddr) {
            if (fsAddr >= this.heapStart) {
                boolean added;
                boolean bl = added = !this.foundFSs.get(fsAddr);
                if (added) {
                    this.foundFSs.set(fsAddr);
                    this.toBeScanned.add(fsAddr);
                }
            } else {
                boolean added;
                boolean bl = added = !this.foundFSsBelowMark.get(fsAddr);
                if (added) {
                    this.foundFSsBelowMark.set(fsAddr);
                    this.toBeScanned.add(fsAddr);
                }
            }
        }
    }

    private boolean isInstanceInTgtTs(int fsAddr) {
        return !this.isTypeMapping || 0 != this.typeMapper.mapTypeCodeSrc2Tgt(this.heap[fsAddr]);
    }

    private void processRefedFSs() {
        for (int i = 0; i < this.toBeScanned.size(); ++i) {
            this.enqueueFeatures(this.toBeScanned.get(i));
        }
    }

    private void enqueueFeatures(int addr) {
        int tCode = this.heap[addr];
        TypeSystemImpl.TypeInfo typeInfo = this.ts.getTypeInfo(tCode);
        SlotKinds.SlotKind[] kinds = typeInfo.slotKinds;
        if (typeInfo.isHeapStoredArray && SlotKinds.SlotKind.Slot_HeapRef == kinds[1]) {
            int length = this.heap[addr + 1];
            for (int i = 0; i < length; ++i) {
                this.enqueueFS(this.heap[addr + 2 + i]);
            }
            return;
        }
        if (typeInfo.isArray) {
            return;
        }
        if (this.isTypeMapping) {
            int[] tgtFeatOffsets2Src = this.typeMapper.getTgtFeatOffsets2Src(tCode);
            for (int i = 0; i < tgtFeatOffsets2Src.length; ++i) {
                int featOffsetInSrc = tgtFeatOffsets2Src[i] + 1;
                if (featOffsetInSrc == 0) {
                    throw new RuntimeException();
                }
                if (kinds[featOffsetInSrc - 1] != SlotKinds.SlotKind.Slot_HeapRef) continue;
                this.enqueueFS(this.heap[addr + featOffsetInSrc]);
            }
        } else {
            for (int i = 1; i < typeInfo.slotKinds.length + 1; ++i) {
                if (kinds[i - 1] != SlotKinds.SlotKind.Slot_HeapRef) continue;
                this.enqueueFS(this.heap[addr + i]);
            }
        }
    }

    private int initFsStartIndexes() {
        boolean isTypeMapping = this.isTypeMappingCmn;
        CasTypeSystemMapper typeMapper = this.typeMapperCmn;
        int tgtHeapUsed = 0;
        int nextTgtHeap = this.isSerializingDelta ? this.mark.nextFSId : 1;
        for (int i = 0; i < this.foundFSsArray.length; ++i) {
            TypeSystemImpl.TypeInfo tgtTypeInfo;
            int iSrcHeap = this.foundFSsArray[i];
            int iTgtHeap = nextTgtHeap;
            int tCode = this.heap[iSrcHeap];
            int tgtTypeCode = isTypeMapping ? typeMapper.mapTypeCodeSrc2Tgt(tCode) : tCode;
            boolean isIncludedType = tgtTypeCode != 0;
            this.fsStartIndexes.addItemAddr(iSrcHeap, iTgtHeap, isIncludedType);
            TypeSystemImpl.TypeInfo srcTypeInfo = this.ts.getTypeInfo(tCode);
            TypeSystemImpl.TypeInfo typeInfo = tgtTypeInfo = isTypeMapping && isIncludedType ? ((TypeSystemImpl)typeMapper.tsTgt.get()).getTypeInfo(tgtTypeCode) : srcTypeInfo;
            if (isIncludedType && this.os != null) {
                this.addStringFromFS(srcTypeInfo, iSrcHeap, tCode);
            }
            if (!isIncludedType) continue;
            int deltaTgtHeap = BinaryCasSerDes6.incrToNextFs(this.heap, iSrcHeap, tgtTypeInfo);
            nextTgtHeap += deltaTgtHeap;
            tgtHeapUsed += deltaTgtHeap;
        }
        return tgtHeapUsed;
    }

    private void addStringFromFS(TypeSystemImpl.TypeInfo srcTypeInfo, int iSrcHeap, int tCode) {
        int markStringHeap;
        int n = markStringHeap = this.isDelta ? this.mark.getNextStringHeapAddr() : 0;
        if (srcTypeInfo.isHeapStoredArray && srcTypeInfo.slotKinds[1] == SlotKinds.SlotKind.Slot_StrRef) {
            for (int i = 0; i < this.heap[iSrcHeap + 1]; ++i) {
                int strHeapIndex = this.heap[iSrcHeap + 2 + i];
                if (strHeapIndex < markStringHeap) continue;
                this.os.add(this.stringHeapObj.getStringForCode(strHeapIndex));
            }
        } else {
            int[] strOffsets = srcTypeInfo.strRefOffsets;
            boolean[] fSrcInTgt = this.isTypeMapping ? this.typeMapper.getFSrcInTgt(tCode) : null;
            for (int i = 0; i < strOffsets.length; ++i) {
                int strHeapIndex;
                int srcOffset = strOffsets[i];
                if (this.isTypeMapping && !fSrcInTgt[srcOffset - 1] || (strHeapIndex = this.heap[iSrcHeap + srcOffset]) < markStringHeap) continue;
                this.os.add(this.stringHeapObj.getStringForCode(strHeapIndex));
            }
        }
    }

    public boolean compareCASes(CASImpl c1, CASImpl c2) {
        return new CasCompare(c1, c2).compareCASes();
    }

    private static DataOutputStream makeDataOutputStream(Object f) throws FileNotFoundException {
        if (f instanceof DataOutputStream) {
            return (DataOutputStream)f;
        }
        if (f instanceof OutputStream) {
            return new DataOutputStream((OutputStream)f);
        }
        if (f instanceof File) {
            FileOutputStream fos = new FileOutputStream((File)f);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            return new DataOutputStream(bos);
        }
        throw new RuntimeException(String.format("Invalid class passed to method, class was %s", f.getClass().getName()));
    }

    String printCasInfo(CASImpl cas) {
        int heapsz = cas.getHeap().getNextId() * 4;
        StringHeapDeserializationHelper shdh = cas.getStringHeap().serialize();
        int charssz = shdh.charHeap.length * 2;
        int strintsz = cas.getStringHeap().getSize() * 8;
        int strsz = charssz + strintsz;
        int fsindexessz = cas.getIndexedFSs().length * 4;
        int bytessz = cas.getByteHeap().getSize();
        int shortsz = cas.getShortHeap().getSize() * 2;
        int longsz = cas.getLongHeap().getSize() * 8;
        int total = heapsz + strsz + fsindexessz + bytessz + shortsz + longsz;
        return String.format("CAS info before compression: totalSize(bytes): %,d%n  mainHeap: %,d(%d%%)%n  Strings: [%,d(%d%%): %,d chars %,d ints]%n  fsIndexes: %,d(%d%%)%n  byte/short/long Heaps: [%,d %,d %,d]", total, heapsz, 100L * (long)heapsz / (long)total, strsz, 100L * (long)strsz / (long)total, charssz, strintsz, fsindexessz, 100L * (long)fsindexessz / (long)total, bytessz, shortsz, longsz);
    }

    private void setupOutputStreams(Object out) throws FileNotFoundException {
        this.serializedOut = BinaryCasSerDes6.makeDataOutputStream(out);
        int compr = (this.heapEnd - this.heapStart) * 8 / 3 / 50;
        int compr1000 = Math.max(512, compr / 1000);
        this.estimatedZipSize[BinaryCasSerDes6.typeCode_i] = Math.max(512, compr / 4);
        this.estimatedZipSize[BinaryCasSerDes6.byte_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.short_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.int_i] = Math.max(1024, compr1000);
        this.estimatedZipSize[BinaryCasSerDes6.arrayLength_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.float_Mantissa_Sign_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.float_Exponent_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.double_Mantissa_Sign_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.double_Exponent_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.long_High_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.long_Low_i] = compr1000;
        this.estimatedZipSize[BinaryCasSerDes6.heapRef_i] = Math.max(1024, compr1000);
        this.estimatedZipSize[BinaryCasSerDes6.strOffset_i] = Math.max(512, compr / 4);
        this.estimatedZipSize[BinaryCasSerDes6.strLength_i] = Math.max(512, compr / 4);
        this.estimatedZipSize[BinaryCasSerDes6.fsIndexes_i] = Math.max(512, compr / 8);
        this.estimatedZipSize[BinaryCasSerDes6.strChars_i] = Math.max(512, compr / 4);
        this.estimatedZipSize[BinaryCasSerDes6.control_i] = 128;
        for (int i = 0; i < this.baosZipSources.length; ++i) {
            this.setupOutputStream(i);
        }
        this.byte_dos = this.dosZipSources[byte_i];
        this.typeCode_dos = this.dosZipSources[typeCode_i];
        this.strOffset_dos = this.dosZipSources[strOffset_i];
        this.strLength_dos = this.dosZipSources[strLength_i];
        this.float_Mantissa_Sign_dos = this.dosZipSources[float_Mantissa_Sign_i];
        this.float_Exponent_dos = this.dosZipSources[float_Exponent_i];
        this.double_Mantissa_Sign_dos = this.dosZipSources[double_Mantissa_Sign_i];
        this.double_Exponent_dos = this.dosZipSources[double_Exponent_i];
        this.fsIndexes_dos = this.dosZipSources[fsIndexes_i];
        this.control_dos = this.dosZipSources[control_i];
        this.strSeg_dos = this.dosZipSources[strSeg_i];
    }

    private DataOutputStream setupOutputStream(int i) {
        int size = this.estimatedZipSize[i];
        this.baosZipSources[i] = new ByteArrayOutputStream(size);
        this.dosZipSources[i] = new DataOutputStream(this.baosZipSources[i]);
        return this.dosZipSources[i];
    }

    private void setupReadStreams() throws IOException {
        int i;
        int nbrEntries = this.deserIn.readInt();
        IntVector idxAndLen = new IntVector(nbrEntries * 3);
        for (i = 0; i < nbrEntries; ++i) {
            idxAndLen.add(this.deserIn.readUnsignedByte());
            idxAndLen.add(this.deserIn.readInt());
            idxAndLen.add(this.deserIn.readInt());
        }
        i = 0;
        while (i < idxAndLen.size()) {
            this.setupReadStream(idxAndLen.get(i++), idxAndLen.get(i++), idxAndLen.get(i++));
        }
        this.arrayLength_dis = this.dataInputs[arrayLength_i];
        this.heapRef_dis = this.dataInputs[heapRef_i];
        this.int_dis = this.dataInputs[int_i];
        this.byte_dis = this.dataInputs[byte_i];
        this.short_dis = this.dataInputs[short_i];
        this.typeCode_dis = this.dataInputs[typeCode_i];
        this.strOffset_dis = this.dataInputs[strOffset_i];
        this.strLength_dis = this.dataInputs[strLength_i];
        this.long_High_dis = this.dataInputs[long_High_i];
        this.long_Low_dis = this.dataInputs[long_Low_i];
        this.float_Mantissa_Sign_dis = this.dataInputs[float_Mantissa_Sign_i];
        this.float_Exponent_dis = this.dataInputs[float_Exponent_i];
        this.double_Mantissa_Sign_dis = this.dataInputs[double_Mantissa_Sign_i];
        this.double_Exponent_dis = this.dataInputs[double_Exponent_i];
        this.fsIndexes_dis = this.dataInputs[fsIndexes_i];
        this.strChars_dis = this.dataInputs[strChars_i];
        this.control_dis = this.dataInputs[control_i];
        this.strSeg_dis = this.dataInputs[strSeg_i];
    }

    private void setupReadStream(int slotIndex, int bytesCompr, int bytesOrig) throws IOException {
        Inflater inflater;
        byte[] b = new byte[bytesCompr + 1];
        this.deserIn.readFully(b, 0, bytesCompr);
        this.inflaters[slotIndex] = inflater = new Inflater(true);
        ByteArrayInputStream baiStream = new ByteArrayInputStream(b);
        int zipBufSize = Math.max(1024, bytesCompr);
        InflaterInputStream iis = new InflaterInputStream(baiStream, inflater, zipBufSize);
        this.dataInputs[slotIndex] = new DataInputStream(new BufferedInputStream(iis, zipBufSize * 1));
    }

    private void closeDataInputs() {
        for (DataInputStream is : this.dataInputs) {
            if (null == is) continue;
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        for (Inflater inflater : this.inflaters) {
            if (null == inflater) continue;
            inflater.end();
        }
    }

    private CommonSerDes.Header readHeader(InputStream istream) throws IOException {
        this.deserIn = CommonSerDes.maybeWrapToDataInputStream(istream);
        CommonSerDes.Header h = CommonSerDes.readHeader(this.deserIn);
        if (!h.isCompressed) {
            throw new RuntimeException("non-compressed invalid object passed to BinaryCasSerDes6 deserialize");
        }
        if (!h.form6) {
            throw new RuntimeException(String.format("Wrong version: %x in input source passed to BinaryCasSerDes6 for deserialization", h.v));
        }
        this.isReadingDelta = h.isDelta;
        return h;
    }

    private void writeStringInfo() throws IOException {
        String[] commonStrings = this.os.getCommonStrings();
        this.writeVnumber(strChars_i, commonStrings.length);
        for (int i = 0; i < commonStrings.length; ++i) {
            int startPos = this.dosZipSources[strChars_i].size();
            DataIO.writeUTFv(commonStrings[i], this.dosZipSources[strChars_i]);
            if (!this.doMeasurements) continue;
            float len = this.dosZipSources[strChars_i].size() - startPos;
            float excess = len / (float)commonStrings[i].length() - 1.0f;
            int encAs2 = (int)(excess * (float)commonStrings[i].length());
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].countTotal += commonStrings[i].length();
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].c[0] = commonStrings[i].length() - encAs2;
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].c[1] = encAs2;
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].lengthTotal = (int)((float)this.sm.statDetails[BinaryCasSerDes6.strChars_i].lengthTotal + len);
        }
        boolean bl = this.only1CommonString = commonStrings.length == 1;
        if (this.doMeasurements) {
            long commonStringsLength = 0L;
            this.sm.stringsNbrCommon = commonStrings.length;
            int r = 0;
            for (int i = 0; i < commonStrings.length; ++i) {
                r = (int)((long)r + DataIO.lengthUTFv(commonStrings[i]));
                commonStringsLength += (long)commonStrings[i].length();
            }
            this.sm.stringsCommonChars = r;
            this.sm.stringsSavedExact = this.os.getSavedCharsExact() * 2L;
            this.sm.stringsSavedSubstr = this.os.getSavedCharsSubstr() * 2L;
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].original = this.os.getSavedCharsExact() * 2L + this.os.getSavedCharsSubstr() * 2L + commonStringsLength * 2L;
            int stringHeapStart = this.isSerializingDelta ? this.mark.nextStringHeapAddr : 1;
            int stringHeapEnd = this.stringHeapObj.getSize();
            this.sm.statDetails[BinaryCasSerDes6.strLength_i].original = (stringHeapEnd - stringHeapStart) * 4;
            this.sm.statDetails[BinaryCasSerDes6.strOffset_i].original = (stringHeapEnd - stringHeapStart) * 4;
        }
    }

    private int[] toArrayOrINT0(IntVector v) {
        if (null == v) {
            return INT0;
        }
        return v.toArray();
    }

    TypeSystemImpl getTgtTs() {
        return this.tgtTs;
    }

    static /* synthetic */ int[] access$1002(BinaryCasSerDes6 x0, int[] x1) {
        x0.heap = x1;
        return x1;
    }

    private class CasCompare {
        private final CASImpl c1;
        private final CASImpl c2;
        private final TypeSystemImpl ts1;
        private final TypeSystemImpl ts2;
        private final Heap c1HO;
        private final Heap c2HO;
        private final int[] c1heap;
        private final int[] c2heap;
        private TypeSystemImpl.TypeInfo typeInfo;
        private int c1heapIndex;
        private int c2heapIndex;
        private final Int2IntRBT addr2seq1;
        private final Int2IntRBT addr2seq2;

        public CasCompare(CASImpl c1, CASImpl c2) {
            this.c1 = c1;
            this.c2 = c2;
            this.ts1 = c1.getTypeSystemImpl();
            this.ts2 = c2.getTypeSystemImpl();
            this.c1HO = c1.getHeap();
            this.c2HO = c2.getHeap();
            this.c1heap = this.c1HO.heap;
            this.c2heap = this.c2HO.heap;
            this.addr2seq1 = new Int2IntRBT(Math.max(1000, this.c1heap.length / 100));
            this.addr2seq2 = new Int2IntRBT(Math.max(1000, this.c2heap.length / 100));
        }

        public boolean compareCASes() {
            int v;
            int i;
            int[] c2FoundFSs;
            int[] c1FoundFSs;
            try {
                BinaryCasSerDes6.this.heapStart = 0;
                BinaryCasSerDes6.this.ts = this.ts1;
                BinaryCasSerDes6.this.processIndexedFeatureStructures(this.c1, false);
                c1FoundFSs = BinaryCasSerDes6.this.foundFSsArray;
                boolean savedIsTypeMapping = BinaryCasSerDes6.this.isTypeMapping;
                BinaryCasSerDes6.this.isTypeMapping = false;
                BinaryCasSerDes6.this.ts = this.ts2;
                BinaryCasSerDes6.this.processIndexedFeatureStructures(this.c2, false);
                BinaryCasSerDes6.this.ts = null;
                BinaryCasSerDes6.this.isTypeMapping = savedIsTypeMapping;
                c2FoundFSs = BinaryCasSerDes6.this.foundFSsArray;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BinaryCasSerDes6.access$1002(BinaryCasSerDes6.this, this.c1heap);
            for (i = 0; i < c1FoundFSs.length; ++i) {
                v = c1FoundFSs[i];
                this.addr2seq1.put(v, i);
            }
            for (i = 0; i < c2FoundFSs.length; ++i) {
                v = c2FoundFSs[i];
                this.addr2seq2.put(v, i);
            }
            int i1 = 0;
            int i2 = 0;
            while (i1 < c1FoundFSs.length && i2 < c2FoundFSs.length) {
                this.c1heapIndex = c1FoundFSs[i1];
                this.c2heapIndex = c2FoundFSs[i2];
                if (BinaryCasSerDes6.this.isTypeMapping) {
                    int tCode1_2 = BinaryCasSerDes6.this.typeMapper.mapTypeCodeSrc2Tgt(this.c1heap[this.c1heapIndex]);
                    int tCode2_1 = BinaryCasSerDes6.this.typeMapper.mapTypeCodeTgt2Src(this.c2heap[this.c2heapIndex]);
                    if (tCode1_2 != 0 && tCode2_1 != 0) {
                        if (!this.compareFss()) {
                            return false;
                        }
                        ++i1;
                        ++i2;
                        continue;
                    }
                    if (tCode1_2 == 0 && tCode2_1 == 0) {
                        ++i1;
                        ++i2;
                        continue;
                    }
                    if (tCode1_2 == 0 && tCode2_1 != 0) {
                        ++i1;
                        continue;
                    }
                    if (tCode1_2 == 0 || tCode2_1 != 0) continue;
                    ++i2;
                    continue;
                }
                if (!this.compareFss()) {
                    return false;
                }
                ++i1;
                ++i2;
            }
            if (i1 >= c1FoundFSs.length && i2 >= c2FoundFSs.length) {
                return true;
            }
            if (BinaryCasSerDes6.this.isTypeMapping) {
                while (i1 < c1FoundFSs.length) {
                    this.c1heapIndex = c1FoundFSs[i1];
                    if (BinaryCasSerDes6.this.typeMapper.mapTypeCodeSrc2Tgt(this.c1heap[this.c1heapIndex]) != 0) {
                        return false;
                    }
                    ++i1;
                }
                while (i2 < c2FoundFSs.length) {
                    this.c2heapIndex = c2FoundFSs[i2];
                    if (BinaryCasSerDes6.this.typeMapper.mapTypeCodeTgt2Src(this.c2heap[this.c2heapIndex]) != 0) {
                        return false;
                    }
                    ++i2;
                }
            }
            return true;
        }

        private boolean compareFss() {
            int tCodeTgtInSrc;
            int tCode = this.c1heap[this.c1heapIndex];
            this.typeInfo = this.ts1.getTypeInfo(tCode);
            int tCodeTgt = this.c2heap[this.c2heapIndex];
            int n = tCodeTgtInSrc = BinaryCasSerDes6.this.isTypeMapping ? BinaryCasSerDes6.this.typeMapper.mapTypeCodeTgt2Src(tCodeTgt) : tCodeTgt;
            if (tCode != tCodeTgtInSrc) {
                return this.mismatchFs();
            }
            if (this.typeInfo.isArray) {
                return this.compareFssArray();
            }
            if (BinaryCasSerDes6.this.isTypeMapping) {
                int[] srcSlots = BinaryCasSerDes6.this.typeMapper.getTgtFeatOffsets2Src(tCode);
                int len = srcSlots.length;
                for (int i = 0; i < len; ++i) {
                    if (this.compareSlot(srcSlots[i] + 1, i + 1)) continue;
                    return this.mismatchFs(srcSlots[i], i);
                }
            } else {
                for (int i = 1; i < this.typeInfo.slotKinds.length + 1; ++i) {
                    if (this.compareSlot(i, i)) continue;
                    return this.mismatchFs();
                }
            }
            return true;
        }

        private boolean compareFssArray() {
            int len1 = this.c1heap[this.c1heapIndex + 1];
            int len2 = this.c2heap[this.c2heapIndex + 1];
            if (len1 != len2) {
                return this.mismatchFs();
            }
            block5: for (int i = 0; i < len1; ++i) {
                SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(2);
                if (this.typeInfo.isHeapStoredArray) {
                    if (kind == SlotKinds.SlotKind.Slot_StrRef) {
                        if (this.compareStrings(this.c1.getStringForCode(this.c1heap[this.c1heapIndex + 2 + i]), this.c2.getStringForCode(this.c2heap[this.c2heapIndex + 2 + i]))) continue;
                        return this.mismatchFs();
                    }
                    if (kind == SlotKinds.SlotKind.Slot_HeapRef) {
                        int c1ref = this.c1heap[this.c1heapIndex + 2 + i];
                        int c2ref = this.c2heap[this.c2heapIndex + 2 + i];
                        if (!BinaryCasSerDes6.this.isInstanceInTgtTs(c1ref)) {
                            return c2ref == 0;
                        }
                        if (c1ref == 0 || c2ref == 0 || this.addr2seq1.getMostlyClose(c1ref) == this.addr2seq2.getMostlyClose(c2ref)) continue;
                        return this.mismatchFs();
                    }
                    if (this.c1heap[this.c1heapIndex + 2 + i] == this.c2heap[this.c2heapIndex + 2 + i]) continue;
                    return this.mismatchFs();
                }
                switch (kind) {
                    case Slot_BooleanRef: 
                    case Slot_ByteRef: {
                        if (this.c1.getByteHeap().getHeapValue(this.c1heap[this.c1heapIndex + 2] + i) == this.c2.getByteHeap().getHeapValue(this.c2heap[this.c2heapIndex + 2] + i)) continue block5;
                        return this.mismatchFs();
                    }
                    case Slot_ShortRef: {
                        if (this.c1.getShortHeap().getHeapValue(this.c1heap[this.c1heapIndex + 2] + i) == this.c2.getShortHeap().getHeapValue(this.c2heap[this.c2heapIndex + 2] + i)) continue block5;
                        return this.mismatchFs();
                    }
                    case Slot_LongRef: 
                    case Slot_DoubleRef: {
                        if (this.c1.getLongHeap().getHeapValue(this.c1heap[this.c1heapIndex + 2] + i) == this.c2.getLongHeap().getHeapValue(this.c2heap[this.c2heapIndex + 2] + i)) continue block5;
                        return this.mismatchFs();
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
            }
            return true;
        }

        private boolean compareSlot(int offsetSrc, int offsetTgt) {
            SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(offsetSrc);
            switch (kind) {
                case Slot_Int: 
                case Slot_Float: 
                case Slot_Short: 
                case Slot_Boolean: 
                case Slot_Byte: {
                    return this.c1heap[this.c1heapIndex + offsetSrc] == this.c2heap[this.c2heapIndex + offsetTgt];
                }
                case Slot_HeapRef: {
                    int c1ref = this.c1heap[this.c1heapIndex + offsetSrc];
                    int c2ref = this.c2heap[this.c2heapIndex + offsetTgt];
                    return this.diagnoseMiscompareHeapRef(c1ref, c2ref, offsetSrc);
                }
                case Slot_StrRef: {
                    return this.compareStrings(this.c1.getStringForCode(this.c1heap[this.c1heapIndex + offsetSrc]), this.c2.getStringForCode(this.c2heap[this.c2heapIndex + offsetTgt]));
                }
                case Slot_LongRef: 
                case Slot_DoubleRef: {
                    return this.c1.getLongHeap().getHeapValue(this.c1heap[this.c1heapIndex + offsetSrc]) == this.c2.getLongHeap().getHeapValue(this.c2heap[this.c2heapIndex + offsetTgt]);
                }
            }
            throw new RuntimeException("internal error");
        }

        private boolean diagnoseMiscompareHeapRef(int c1ref, int c2ref, int offsetSrc) {
            int seq2;
            if (!BinaryCasSerDes6.this.isInstanceInTgtTs(c1ref)) {
                if (c2ref != 0) {
                    System.err.format("HeapRef original %,d is for a type not in target, target should have 0 but has %,d%n", c1ref, c2ref);
                    return false;
                }
                return true;
            }
            if (c1ref == 0) {
                int prevC1Ref = this.c1heap[this.c1heapIndex + offsetSrc];
                if (prevC1Ref != 0) {
                    System.err.format("HeapRef original c1Ref = %,d but instance not in target ts, so set to 0", prevC1Ref);
                    return false;
                }
                return true;
            }
            if (c2ref == 0) {
                System.err.format("heapRef one is 0, other not: c1Ref = %,d c2Ref = %,d%n", c1ref, c2ref);
                return false;
            }
            int seq1 = this.addr2seq1.getMostlyClose(c1ref);
            if (seq1 != (seq2 = this.addr2seq2.getMostlyClose(c2ref))) {
                System.err.format("heapRef seq1 not match seq2.  c1ref = %,d seq1 = %,d   c2ref= %,d seq2 = %,d%n", c1ref, seq1, c2ref, seq2);
                return false;
            }
            return true;
        }

        private boolean compareStrings(String s1, String s2) {
            if (null == s1 && null == s2) {
                return true;
            }
            if (null == s1) {
                return false;
            }
            return s1.equals(s2);
        }

        private boolean mismatchFs() {
            System.err.format("Mismatched Feature Structures:%n %s%n %s%n", this.dumpHeapFs(this.c1, this.c1heapIndex, this.ts1), this.dumpHeapFs(this.c2, this.c2heapIndex, this.ts2));
            return false;
        }

        private boolean mismatchFs(int i1, int i2) {
            System.err.format("Mismatched Feature Structures in srcSlot %d, tgtSlot %d%n %s%n %s%n", i1, i2, this.dumpHeapFs(this.c1, this.c1heapIndex, this.ts1), this.dumpHeapFs(this.c2, this.c2heapIndex, this.ts2));
            return false;
        }

        private StringBuilder dumpHeapFs(CASImpl cas, int iHeap, TypeSystemImpl ts) {
            StringBuilder sb = new StringBuilder();
            this.typeInfo = ts.getTypeInfo(cas.getHeap().heap[iHeap]);
            sb.append("Heap Addr: ").append(iHeap).append(' ');
            sb.append(this.typeInfo).append(' ');
            if (this.typeInfo.isHeapStoredArray) {
                sb.append((CharSequence)this.dumpHeapStoredArray(cas, iHeap));
            } else if (this.typeInfo.isArray) {
                sb.append((CharSequence)this.dumpNonHeapStoredArray(cas, iHeap));
            } else {
                sb.append("   Slots:\n");
                for (int i = 1; i < this.typeInfo.slotKinds.length + 1; ++i) {
                    sb.append("  ").append((Object)this.typeInfo.getSlotKind(i)).append(": ").append((CharSequence)this.dumpByKind(cas, i, iHeap)).append('\n');
                }
            }
            return sb;
        }

        private StringBuilder dumpHeapStoredArray(CASImpl cas, int iHeap) {
            StringBuilder sb = new StringBuilder();
            int[] heap = cas.getHeap().heap;
            int length = heap[iHeap + 1];
            sb.append("Array Length: ").append(length).append('[');
            SlotKinds.SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
            switch (arrayElementKind) {
                case Slot_HeapRef: 
                case Slot_Int: 
                case Slot_Float: 
                case Slot_Short: 
                case Slot_Boolean: 
                case Slot_Byte: {
                    for (int i = iHeap + 2; i < iHeap + length + 2; ++i) {
                        if (i > iHeap + 2) {
                            sb.append(", ");
                        }
                        sb.append(heap[i]);
                    }
                    break;
                }
                case Slot_StrRef: {
                    StringHeap sh = cas.getStringHeap();
                    for (int i = iHeap + 2; i < iHeap + length + 2; ++i) {
                        if (i > iHeap + 2) {
                            sb.append(", ");
                        }
                        sb.append(sh.getStringForCode(heap[i]));
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            sb.append("] ");
            return sb;
        }

        private StringBuilder dumpNonHeapStoredArray(CASImpl cas, int iHeap) {
            StringBuilder sb = new StringBuilder();
            int[] heap = cas.getHeap().heap;
            int length = heap[iHeap + 1];
            sb.append("Array Length: ").append(length).append('[');
            SlotKinds.SlotKind arrayElementKind = this.typeInfo.slotKinds[1];
            block5: for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                switch (arrayElementKind) {
                    case Slot_BooleanRef: 
                    case Slot_ByteRef: {
                        sb.append(cas.getByteHeap().getHeapValue(heap[iHeap + 2 + i]));
                        continue block5;
                    }
                    case Slot_ShortRef: {
                        sb.append(cas.getShortHeap().getHeapValue(heap[iHeap + 2 + i]));
                        continue block5;
                    }
                    case Slot_LongRef: 
                    case Slot_DoubleRef: {
                        long v = cas.getLongHeap().getHeapValue(heap[iHeap + 2 + i]);
                        if (arrayElementKind == SlotKinds.SlotKind.Slot_DoubleRef) {
                            sb.append(Double.longBitsToDouble(v));
                            continue block5;
                        }
                        sb.append(String.format("%,d", v));
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("internal error");
                    }
                }
            }
            sb.append("] ");
            return sb;
        }

        private StringBuilder dumpByKind(CASImpl cas, int offset, int iHeap) {
            StringBuilder sb = new StringBuilder();
            int[] heap = cas.getHeap().heap;
            SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(offset);
            switch (kind) {
                case Slot_Int: {
                    return sb.append(heap[iHeap + offset]);
                }
                case Slot_Short: {
                    return sb.append((short)heap[iHeap + offset]);
                }
                case Slot_Byte: {
                    return sb.append((byte)heap[iHeap + offset]);
                }
                case Slot_Boolean: {
                    return sb.append(heap[iHeap + offset] != 0);
                }
                case Slot_Float: {
                    int v = heap[iHeap + offset];
                    return sb.append(Float.intBitsToFloat(v)).append(' ').append(Integer.toHexString(v));
                }
                case Slot_HeapRef: {
                    return sb.append("HeapRef[").append(heap[iHeap + offset]).append(']');
                }
                case Slot_StrRef: {
                    return sb.append(cas.getStringForCode(heap[iHeap + offset]));
                }
                case Slot_LongRef: {
                    return sb.append(String.format("%,d", cas.getLongHeap().getHeapValue(heap[iHeap + offset])));
                }
                case Slot_DoubleRef: {
                    long v = cas.getLongHeap().getHeapValue(heap[iHeap + offset]);
                    return sb.append(Double.longBitsToDouble(v)).append(' ').append(Long.toHexString(v));
                }
            }
            throw new RuntimeException("internal error");
        }
    }

    private class ReadModifiedFSs {
        private int vPrevModInt = 0;
        private int prevModHeapRefTgtSeq = 0;
        private short vPrevModShort = 0;
        private long vPrevModLong = 0L;
        private int iHeap;
        private TypeSystemImpl.TypeInfo typeInfo;
        private int[] tgtF2srcF;
        private boolean wasRemoved;
        private FSsTobeAddedback.FSsTobeAddedbackSingle addbackSingle;
        private int[] featCodes;

        private ReadModifiedFSs() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readModifiedFSs() throws IOException {
            int modFSsLength = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.control_dis);
            int prevSeq = 0;
            if (modFSsLength > 0 && BinaryCasSerDes6.this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                CASRuntimeException e = new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", new String[]{String.format("%,d pre-existing Feature Structures modified", modFSsLength)});
                throw e;
            }
            for (int i = 0; i < modFSsLength; ++i) {
                int seqNbrModified;
                prevSeq = seqNbrModified = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.fsIndexes_dis, prevSeq);
                this.iHeap = BinaryCasSerDes6.this.fsStartIndexes.getSrcAddrFromTgtSeq(seqNbrModified);
                if (this.iHeap < 1) {
                    throw new RuntimeException("never happen");
                }
                int tCode = BinaryCasSerDes6.this.heap[this.iHeap];
                this.typeInfo = BinaryCasSerDes6.this.ts.getTypeInfo(tCode);
                if (BinaryCasSerDes6.this.isTypeMapping) {
                    this.tgtF2srcF = BinaryCasSerDes6.this.typeMapper.getTgtFeatOffsets2Src(tCode);
                }
                int numberOfModsInThisFs = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.fsIndexes_dis);
                if (this.typeInfo.isArray && !this.typeInfo.isHeapStoredArray) {
                    this.readModifiedAuxHeap(numberOfModsInThisFs);
                    continue;
                }
                this.featCodes = BinaryCasSerDes6.this.cas.getTypeSystemImpl().ll_getAppropriateFeatures(tCode);
                try {
                    this.wasRemoved = false;
                    this.readModifiedMainHeap(numberOfModsInThisFs);
                    continue;
                }
                finally {
                    BinaryCasSerDes6.this.cas.addbackSingle(this.iHeap);
                }
            }
        }

        private void readModifiedAuxHeap(int numberOfMods) throws IOException {
            boolean isAuxLong;
            int prevOffset = 0;
            int auxHeapIndex = BinaryCasSerDes6.this.heap[this.iHeap + 2];
            SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(2);
            boolean isAuxByte = kind == SlotKinds.SlotKind.Slot_BooleanRef || kind == SlotKinds.SlotKind.Slot_ByteRef;
            boolean isAuxShort = kind == SlotKinds.SlotKind.Slot_ShortRef;
            boolean bl = isAuxLong = kind == SlotKinds.SlotKind.Slot_LongRef || kind == SlotKinds.SlotKind.Slot_DoubleRef;
            if (!(isAuxByte | isAuxShort | isAuxLong)) {
                throw new RuntimeException();
            }
            for (int i2 = 0; i2 < numberOfMods; ++i2) {
                int offset;
                prevOffset = offset = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.fsIndexes_dis) + prevOffset;
                if (isAuxByte) {
                    BinaryCasSerDes6.this.byteHeapObj.setHeapValue(BinaryCasSerDes6.this.byte_dis.readByte(), auxHeapIndex + offset);
                    continue;
                }
                if (isAuxShort) {
                    short v;
                    this.vPrevModShort = v = (short)BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.int_dis, this.vPrevModShort);
                    BinaryCasSerDes6.this.shortHeapObj.setHeapValue(v, auxHeapIndex + offset);
                    continue;
                }
                long v = BinaryCasSerDes6.this.readLongOrDouble(kind, this.vPrevModLong);
                if (kind == SlotKinds.SlotKind.Slot_LongRef) {
                    this.vPrevModLong = v;
                }
                BinaryCasSerDes6.this.longHeapObj.setHeapValue(v, auxHeapIndex + offset);
            }
        }

        private void readModifiedMainHeap(int numberOfMods) throws IOException {
            int iPrevTgtOffsetInFs = 0;
            this.wasRemoved = false;
            this.addbackSingle = BinaryCasSerDes6.this.cas.getAddbackSingle();
            this.addbackSingle.clear();
            block10: for (int i = 0; i < numberOfMods; ++i) {
                int srcOffsetInFs;
                int tgtOffsetInFs;
                iPrevTgtOffsetInFs = tgtOffsetInFs = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.fsIndexes_dis) + iPrevTgtOffsetInFs;
                int n = srcOffsetInFs = BinaryCasSerDes6.this.isTypeMapping ? this.tgtF2srcF[tgtOffsetInFs] : tgtOffsetInFs;
                if (srcOffsetInFs < 0) {
                    throw new RuntimeException();
                }
                SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(this.typeInfo.isArray ? 2 : srcOffsetInFs);
                switch (kind) {
                    case Slot_HeapRef: {
                        int v;
                        int tgtSeq;
                        this.prevModHeapRefTgtSeq = tgtSeq = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.heapRef_dis, this.prevModHeapRefTgtSeq);
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = v = BinaryCasSerDes6.this.fsStartIndexes.getSrcAddrFromTgtSeq(tgtSeq);
                        continue block10;
                    }
                    case Slot_Int: {
                        int v;
                        this.vPrevModInt = v = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.int_dis, this.vPrevModInt);
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = v;
                        this.maybeRemove(srcOffsetInFs);
                        continue block10;
                    }
                    case Slot_Short: {
                        int v = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.int_dis, this.vPrevModShort);
                        this.vPrevModShort = (short)v;
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = v;
                        continue block10;
                    }
                    case Slot_LongRef: {
                        long v;
                        this.vPrevModLong = v = BinaryCasSerDes6.this.readLongOrDouble(kind, this.vPrevModLong);
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = BinaryCasSerDes6.this.longHeapObj.addLong(v);
                        continue block10;
                    }
                    case Slot_DoubleRef: {
                        long v = BinaryCasSerDes6.this.readDouble();
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = BinaryCasSerDes6.this.longHeapObj.addLong(v);
                        continue block10;
                    }
                    case Slot_Boolean: 
                    case Slot_Byte: {
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = BinaryCasSerDes6.this.byte_dis.readByte();
                        continue block10;
                    }
                    case Slot_Float: {
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = BinaryCasSerDes6.this.readFloat();
                        this.maybeRemove(srcOffsetInFs);
                        continue block10;
                    }
                    case Slot_StrRef: {
                        ((BinaryCasSerDes6)BinaryCasSerDes6.this).heap[this.iHeap + srcOffsetInFs] = BinaryCasSerDes6.this.readString(true);
                        this.maybeRemove(srcOffsetInFs);
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        }

        private void maybeRemove(int srcOffsetInFs) {
            if (!this.typeInfo.isHeapStoredArray && !this.wasRemoved) {
                this.wasRemoved |= BinaryCasSerDes6.this.cas.removeFromCorruptableIndexAnyView(this.iHeap, this.addbackSingle, this.featCodes[srcOffsetInFs - 1]);
            }
        }
    }

    private class SerializeModifiedFSs {
        final int[] modifiedMainHeapAddrs;
        final int[] modifiedFSs;
        final int[] modifiedByteHeapAddrs;
        final int[] modifiedShortHeapAddrs;
        final int[] modifiedLongHeapAddrs;
        final int modMainHeapAddrsLength;
        final int modFSsLength;
        final int modByteHeapAddrsLength;
        final int modShortHeapAddrsLength;
        final int modLongHeapAddrsLength;
        int imaModMainHeap;
        int imaModByteRef;
        int imaModShortRef;
        int imaModLongRef;
        int vPrevModInt;
        int vPrevModHeapRef;
        short vPrevModShort;
        long vPrevModLong;
        int iHeap;
        TypeSystemImpl.TypeInfo typeInfo;

        private SerializeModifiedFSs() {
            this.modifiedMainHeapAddrs = BinaryCasSerDes6.this.toArrayOrINT0(BinaryCasSerDes6.this.cas.getModifiedFSHeapAddrs());
            this.modifiedFSs = BinaryCasSerDes6.this.toArrayOrINT0(BinaryCasSerDes6.this.cas.getModifiedFSList());
            this.modifiedByteHeapAddrs = BinaryCasSerDes6.this.toArrayOrINT0(BinaryCasSerDes6.this.cas.getModifiedByteHeapAddrs());
            this.modifiedShortHeapAddrs = BinaryCasSerDes6.this.toArrayOrINT0(BinaryCasSerDes6.this.cas.getModifiedShortHeapAddrs());
            this.modifiedLongHeapAddrs = BinaryCasSerDes6.this.toArrayOrINT0(BinaryCasSerDes6.this.cas.getModifiedLongHeapAddrs());
            this.sortModifications();
            this.modMainHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedMainHeapAddrs);
            this.modFSsLength = this.eliminateDuplicatesInMods(this.modifiedFSs);
            this.modByteHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedByteHeapAddrs);
            this.modShortHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedShortHeapAddrs);
            this.modLongHeapAddrsLength = this.eliminateDuplicatesInMods(this.modifiedLongHeapAddrs);
            this.imaModMainHeap = 0;
            this.imaModByteRef = 0;
            this.imaModShortRef = 0;
            this.imaModLongRef = 0;
            this.vPrevModInt = 0;
            this.vPrevModHeapRef = 0;
            this.vPrevModShort = 0;
            this.vPrevModLong = 0L;
        }

        private void addModifiedStrings() {
            for (int i = 0; i < this.modFSsLength; ++i) {
                this.iHeap = this.modifiedFSs[i];
                if (!BinaryCasSerDes6.this.foundFSsBelowMark.get(this.iHeap)) continue;
                int tCode = BinaryCasSerDes6.this.heap[this.iHeap];
                TypeSystemImpl.TypeInfo typeInfo = BinaryCasSerDes6.this.ts.getTypeInfo(tCode);
                BinaryCasSerDes6.this.addStringFromFS(typeInfo, this.iHeap, tCode);
            }
        }

        private void serializeModifiedFSs() throws IOException {
            int skipped = 0;
            int prevHeapSeq = 0;
            int splitPoint = ((BinaryCasSerDes6)BinaryCasSerDes6.this).mark.nextFSId;
            for (int i = 0; i < this.modFSsLength; ++i) {
                this.iHeap = this.modifiedFSs[i];
                boolean skipping = this.iHeap >= splitPoint && !BinaryCasSerDes6.this.foundFSs.get(this.iHeap) || this.iHeap < splitPoint && !BinaryCasSerDes6.this.foundFSsBelowMark.get(this.iHeap);
                int tCode = BinaryCasSerDes6.this.heap[this.iHeap];
                this.typeInfo = BinaryCasSerDes6.this.ts.getTypeInfo(tCode);
                if (!skipping) {
                    prevHeapSeq = BinaryCasSerDes6.this.writeDiff(fsIndexes_i, this.iHeap, prevHeapSeq);
                }
                if (this.typeInfo.isArray && !this.typeInfo.isHeapStoredArray) {
                    this.writeAuxHeapMods(skipping);
                } else {
                    this.writeMainHeapMods(skipping);
                }
                if (!skipping) continue;
                ++skipped;
            }
            BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.control_dos, this.modFSsLength - skipped);
        }

        private void sortModifications() {
            Arrays.sort(this.modifiedMainHeapAddrs);
            Arrays.sort(this.modifiedFSs);
            Arrays.sort(this.modifiedByteHeapAddrs);
            Arrays.sort(this.modifiedShortHeapAddrs);
            Arrays.sort(this.modifiedLongHeapAddrs);
        }

        private int eliminateDuplicatesInMods(int[] sorted) {
            int length = sorted.length;
            if (length < 2) {
                return length;
            }
            int prev = sorted[0];
            int to = 1;
            for (int from = 1; from < length; ++from) {
                int s = sorted[from];
                if (s == prev) continue;
                prev = s;
                sorted[to] = s;
                ++to;
            }
            return to;
        }

        private int countModifiedSlotsInFs(int fsLength) {
            return this.countModifiedSlots(this.iHeap, fsLength, this.modifiedMainHeapAddrs, this.imaModMainHeap, this.modMainHeapAddrsLength);
        }

        private int countModifiedSlotsInAuxHeap(int[] modifiedAddrs, int indexInModAddrs, int length) {
            return this.countModifiedSlots(BinaryCasSerDes6.this.heap[this.iHeap + 2], BinaryCasSerDes6.this.heap[this.iHeap + 1], modifiedAddrs, indexInModAddrs, length);
        }

        private int countModifiedSlots(int firstAddr, int length, int[] modifiedAddrs, int indexInModAddrs, int modAddrsLength) {
            if (0 == length) {
                throw new RuntimeException();
            }
            int nextAddr = firstAddr + length;
            int nextModAddr = modifiedAddrs[indexInModAddrs];
            if (firstAddr > nextModAddr || nextModAddr >= nextAddr) {
                throw new RuntimeException();
            }
            int i = 1;
            while (indexInModAddrs + i != modAddrsLength && (nextModAddr = modifiedAddrs[indexInModAddrs + i]) < nextAddr) {
                ++i;
            }
            return i;
        }

        private void writeMainHeapMods(boolean skipping) throws IOException {
            int fsLength = BinaryCasSerDes6.incrToNextFs(BinaryCasSerDes6.this.heap, this.iHeap, this.typeInfo);
            int numberOfModsInFs = this.countModifiedSlotsInFs(fsLength);
            if (!skipping) {
                BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, numberOfModsInFs);
            }
            int iPrevOffsetInFs = 0;
            block10: for (int i = 0; i < numberOfModsInFs; ++i) {
                int nextMainHeapIndex = this.modifiedMainHeapAddrs[this.imaModMainHeap++];
                if (skipping) continue;
                int offsetInFs = nextMainHeapIndex - this.iHeap;
                BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, offsetInFs - iPrevOffsetInFs);
                iPrevOffsetInFs = offsetInFs;
                SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(this.typeInfo.isArray ? 2 : offsetInFs);
                switch (kind) {
                    case Slot_HeapRef: {
                        this.vPrevModHeapRef = BinaryCasSerDes6.this.writeIntOrHeapRef(heapRef_i, nextMainHeapIndex, this.vPrevModHeapRef);
                        continue block10;
                    }
                    case Slot_Int: {
                        this.vPrevModInt = BinaryCasSerDes6.this.writeIntOrHeapRef(int_i, nextMainHeapIndex, this.vPrevModInt);
                        continue block10;
                    }
                    case Slot_Short: {
                        this.vPrevModShort = (short)BinaryCasSerDes6.this.writeIntOrHeapRef(int_i, nextMainHeapIndex, this.vPrevModShort);
                        continue block10;
                    }
                    case Slot_LongRef: {
                        this.vPrevModLong = BinaryCasSerDes6.this.writeLongFromHeapIndex(nextMainHeapIndex, this.vPrevModLong);
                        continue block10;
                    }
                    case Slot_Boolean: 
                    case Slot_Byte: {
                        BinaryCasSerDes6.this.byte_dos.write(BinaryCasSerDes6.this.heap[nextMainHeapIndex]);
                        continue block10;
                    }
                    case Slot_Float: {
                        BinaryCasSerDes6.this.writeFloat(BinaryCasSerDes6.this.heap[nextMainHeapIndex]);
                        continue block10;
                    }
                    case Slot_StrRef: {
                        BinaryCasSerDes6.this.writeString(BinaryCasSerDes6.this.stringHeapObj.getStringForCode(BinaryCasSerDes6.this.heap[nextMainHeapIndex]));
                        continue block10;
                    }
                    case Slot_DoubleRef: {
                        BinaryCasSerDes6.this.writeDouble(BinaryCasSerDes6.this.longHeapObj.getHeapValue(BinaryCasSerDes6.this.heap[nextMainHeapIndex]));
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        }

        private void writeAuxHeapMods(boolean skipping) throws IOException {
            int modXxxHeapAddrsLength;
            int[] modXxxHeapAddrs;
            boolean isAuxLong;
            int auxHeapIndex = BinaryCasSerDes6.this.heap[this.iHeap + 2];
            int iPrevOffsetInAuxArray = 0;
            SlotKinds.SlotKind kind = this.typeInfo.getSlotKind(2);
            boolean isAuxByte = kind == SlotKinds.SlotKind.Slot_BooleanRef || kind == SlotKinds.SlotKind.Slot_ByteRef;
            boolean isAuxShort = kind == SlotKinds.SlotKind.Slot_ShortRef;
            boolean bl = isAuxLong = kind == SlotKinds.SlotKind.Slot_LongRef || kind == SlotKinds.SlotKind.Slot_DoubleRef;
            if (!(isAuxByte || isAuxShort || isAuxLong)) {
                throw new RuntimeException();
            }
            int[] nArray = isAuxByte ? this.modifiedByteHeapAddrs : (modXxxHeapAddrs = isAuxShort ? this.modifiedShortHeapAddrs : this.modifiedLongHeapAddrs);
            int n = isAuxByte ? this.modByteHeapAddrsLength : (modXxxHeapAddrsLength = isAuxShort ? this.modShortHeapAddrsLength : this.modLongHeapAddrsLength);
            int imaModXxxRef = isAuxByte ? this.imaModByteRef : (isAuxShort ? this.imaModShortRef : this.imaModLongRef);
            int numberOfModsInAuxHeap = this.countModifiedSlotsInAuxHeap(modXxxHeapAddrs, imaModXxxRef, modXxxHeapAddrsLength);
            if (!skipping) {
                BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, numberOfModsInAuxHeap);
            }
            for (int i = 0; i < numberOfModsInAuxHeap; ++i) {
                int nextModAuxIndex = modXxxHeapAddrs[imaModXxxRef++];
                int offsetInAuxArray = nextModAuxIndex - auxHeapIndex;
                if (!skipping) {
                    BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, offsetInAuxArray - iPrevOffsetInAuxArray);
                    iPrevOffsetInAuxArray = offsetInAuxArray;
                    if (isAuxByte) {
                        BinaryCasSerDes6.this.writeUnsignedByte(BinaryCasSerDes6.this.byte_dos, BinaryCasSerDes6.this.byteHeapObj.getHeapValue(nextModAuxIndex));
                    } else if (isAuxShort) {
                        short v = BinaryCasSerDes6.this.shortHeapObj.getHeapValue(nextModAuxIndex);
                        BinaryCasSerDes6.this.writeDiff(int_i, v, this.vPrevModShort);
                        this.vPrevModShort = v;
                    } else {
                        long v = BinaryCasSerDes6.this.longHeapObj.getHeapValue(nextModAuxIndex);
                        if (kind == SlotKinds.SlotKind.Slot_LongRef) {
                            BinaryCasSerDes6.this.writeLong(v, this.vPrevModLong);
                            this.vPrevModLong = v;
                        } else {
                            BinaryCasSerDes6.this.writeDouble(v);
                        }
                    }
                }
                if (isAuxByte) {
                    ++this.imaModByteRef;
                    continue;
                }
                if (isAuxShort) {
                    ++this.imaModShortRef;
                    continue;
                }
                ++this.imaModLongRef;
            }
        }
    }

    public static class ReuseInfo {
        private final BitSet foundFSs;
        private final int[] foundFSsArray;
        private final CasSeqAddrMaps fsStartIndexes;

        private ReuseInfo(BitSet foundFSs, int[] foundFSsArray, CasSeqAddrMaps fsStartIndexes) {
            this.foundFSs = foundFSs;
            this.foundFSsArray = foundFSsArray;
            this.fsStartIndexes = fsStartIndexes;
        }
    }

    public static enum CompressStrat {
        Default(0),
        Filtered(1),
        HuffmanOnly(2);

        public final int strat;

        private CompressStrat(int strat) {
            this.strat = strat;
        }
    }

    public static enum CompressLevel {
        None(0),
        Fast(1),
        Default(-1),
        Best(9);

        public final int lvl;

        private CompressLevel(int lvl) {
            this.lvl = lvl;
        }
    }
}

