/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.metadata;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.knox.gateway.service.definition.Metadata;
import org.apache.knox.gateway.service.definition.Sample;
import org.apache.knox.gateway.topology.Service;

@XmlRootElement(name="service")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ServiceModel
implements Comparable<ServiceModel> {
    static final String SERVICE_URL_TEMPLATE = "%s://%s:%s/%s/%s%s";
    static final String CURL_SAMPLE_TEMPLATE = "curl -iv -X %s \"%s%s\"";
    static final String HIVE_SERVICE_NAME = "HIVE";
    static final String HIVE_SERVICE_URL_TEMPLATE = "jdbc:hive2://%s:%d/;ssl=true;transportMode=http;httpPath=%s/%s/hive";
    static final String IMPALA_SERVICE_NAME = "IMPALA";
    static final String IMPALA_SERVICE_URL_TEMPLATE = "jdbc:impala://%s:%d/;ssl=1;transportMode=http;httpPath=%s/%s/impala;AuthMech=3";
    private HttpServletRequest request;
    private String topologyName;
    private String gatewayPath;
    private Service service;
    private Metadata serviceMetadata;

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setTopologyName(String topologyName) {
        this.topologyName = topologyName;
    }

    public void setGatewayPath(String gatewayPath) {
        this.gatewayPath = gatewayPath;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setServiceMetadata(Metadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    @XmlElement
    public String getServiceName() {
        return this.service == null ? "" : this.service.getRole();
    }

    @XmlElement
    public String getVersion() {
        return this.service == null ? "" : (this.service.getVersion() == null ? "" : this.service.getVersion().toString());
    }

    @XmlElement(name="shortDesc")
    public String getShortDescription() {
        if (this.serviceMetadata == null) {
            return this.getServiceName().substring(0, 1).toUpperCase(Locale.ROOT) + this.getServiceName().substring(1).toLowerCase(Locale.ROOT);
        }
        return this.serviceMetadata.getShortDesc();
    }

    @XmlElement
    public String getDescription() {
        if (this.serviceMetadata == null) {
            return this.getShortDescription() + (Type.API == this.getType() ? " REST API" : (Type.UI == this.getType() ? " Web User Interface" : ""));
        }
        return this.serviceMetadata.getDescription();
    }

    @XmlElement
    public Type getType() {
        return this.serviceMetadata == null ? Type.UNKNOWN : Type.valueOf(this.serviceMetadata.getType());
    }

    @XmlElement
    public String getContext() {
        return this.serviceMetadata == null ? "/" + this.getServiceName().toLowerCase(Locale.ROOT) : this.serviceMetadata.getContext();
    }

    @XmlElement(name="serviceUrls")
    public List<String> getServiceUrls() {
        TreeSet<String> resolvedServiceUrls = new TreeSet<String>();
        String context = this.getContext();
        if (HIVE_SERVICE_NAME.equals(this.getServiceName())) {
            resolvedServiceUrls.add(String.format(Locale.ROOT, HIVE_SERVICE_URL_TEMPLATE, this.request.getServerName(), this.request.getServerPort(), this.gatewayPath, this.topologyName));
        } else if (IMPALA_SERVICE_NAME.equals(this.getServiceName())) {
            resolvedServiceUrls.add(String.format(Locale.ROOT, IMPALA_SERVICE_URL_TEMPLATE, this.request.getServerName(), this.request.getServerPort(), this.gatewayPath, this.topologyName));
        } else if (this.service != null && this.service.getUrls() != null && !this.service.getUrls().isEmpty()) {
            this.service.getUrls().forEach(serviceUrl -> resolvedServiceUrls.add(this.getServiceUrl(context, (String)serviceUrl)));
        } else {
            resolvedServiceUrls.add(this.getServiceUrl(context, null));
        }
        return Arrays.asList(resolvedServiceUrls.toArray(new String[0]));
    }

    private String getServiceUrl(String context, String serviceUrl) {
        String resolvedContext = this.resolvePlaceholdersFromBackendUrl(context, serviceUrl);
        return String.format(Locale.ROOT, SERVICE_URL_TEMPLATE, this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), this.gatewayPath, this.topologyName, resolvedContext);
    }

    private String resolvePlaceholdersFromBackendUrl(String resolveable, String serviceUrl) {
        String backendUrlString;
        String toBeResolved = resolveable;
        if (toBeResolved != null && StringUtils.isNotBlank((CharSequence)(backendUrlString = this.getBackendServiceUrl(serviceUrl)))) {
            if (toBeResolved.indexOf("{{BACKEND_HOST}}") > -1) {
                toBeResolved = toBeResolved.replace("{{BACKEND_HOST}}", backendUrlString);
            }
            if (toBeResolved.indexOf("{{SCHEME}}") > -1 || toBeResolved.indexOf("{{HOST}}") > -1 || toBeResolved.indexOf("{{PORT}}") > -1) {
                try {
                    URL backendUrl = new URL(backendUrlString);
                    toBeResolved = toBeResolved.replace("{{SCHEME}}", backendUrl.getProtocol());
                    toBeResolved = toBeResolved.replace("{{HOST}}", backendUrl.getHost());
                    toBeResolved = toBeResolved.replace("{{PORT}}", String.valueOf(backendUrl.getPort()));
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException("Error while converting '" + backendUrlString + "' to a URL", e);
                }
            }
        }
        return toBeResolved;
    }

    String getBackendServiceUrl(String serviceUrl) {
        String backendServiceUrl = serviceUrl == null ? (this.service == null ? "" : this.service.getUrl()) : serviceUrl;
        return backendServiceUrl == null ? "" : backendServiceUrl;
    }

    @XmlElement(name="sample")
    @XmlElementWrapper(name="samples")
    public List<Sample> getSamples() {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        if (this.serviceMetadata != null && this.serviceMetadata.getSamples() != null) {
            this.serviceMetadata.getSamples().forEach(sample -> {
                Sample resolvedSample = new Sample();
                resolvedSample.setDescription(sample.getDescription());
                if (StringUtils.isNotBlank((CharSequence)sample.getValue())) {
                    resolvedSample.setValue(sample.getValue());
                } else {
                    String path;
                    String method = StringUtils.isBlank((CharSequence)sample.getMethod()) ? "GET" : sample.getMethod();
                    String string = path = sample.getPath().startsWith("/") ? sample.getPath() : "/" + sample.getPath();
                    String serviceUrl = this.getServiceUrls().isEmpty() ? (this.service == null ? "$SERVICE_URL" : this.service.getUrl()) : (String)this.getServiceUrls().stream().findFirst().get();
                    resolvedSample.setValue(String.format(Locale.ROOT, CURL_SAMPLE_TEMPLATE, method, serviceUrl, path));
                }
                samples.add(resolvedSample);
            });
        }
        return samples;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ServiceModel serviceModel = (ServiceModel)obj;
        return new EqualsBuilder().append((Object)this.topologyName, (Object)serviceModel.topologyName).append((Object)this.gatewayPath, (Object)serviceModel.gatewayPath).append((Object)this.getServiceName(), (Object)serviceModel.getServiceName()).append((Object)this.getVersion(), (Object)serviceModel.getVersion()).append((Object)this.serviceMetadata, (Object)serviceModel.serviceMetadata).append(this.getServiceUrls(), serviceModel.getServiceUrls()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.topologyName).append((Object)this.gatewayPath).append((Object)this.getServiceName()).append((Object)this.getVersion()).append((Object)this.serviceMetadata).append(this.getServiceUrls()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.topologyName).append((Object)this.gatewayPath).append((Object)this.getServiceName()).append((Object)this.getVersion()).append((Object)this.serviceMetadata).append(this.getServiceUrls()).toString();
    }

    @Override
    public int compareTo(ServiceModel other) {
        int byServiceName = this.getServiceName().compareTo(other.getServiceName());
        if (byServiceName == 0) {
            int byVersion = this.getVersion().compareTo(this.getVersion());
            return byVersion == 0 ? Integer.compare(this.getServiceUrls().size(), other.getServiceUrls().size()) : byVersion;
        }
        return byServiceName;
    }

    public static enum Type {
        API,
        UI,
        API_AND_UI,
        UNKNOWN;

    }
}

