/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.Topology;

public class GatewayServicesContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        GatewayServices gs = GatewayServer.getGatewayServices();
        sce.getServletContext().setAttribute("org.apache.knox.gateway.gateway.services", (Object)gs);
        String topologyName = (String)sce.getServletContext().getAttribute("org.apache.knox.gateway.gateway.cluster");
        TopologyService ts = (TopologyService)gs.getService(ServiceType.TOPOLOGY_SERVICE);
        Topology topology = this.getTopology(ts, topologyName);
        sce.getServletContext().setAttribute("org.apache.knox.gateway.topology", (Object)topology);
    }

    private Topology getTopology(TopologyService ts, String topologyName) {
        Topology t = null;
        for (Topology topology : ts.getTopologies()) {
            if (!topology.getName().equals(topologyName)) continue;
            t = topology;
            break;
        }
        return t;
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

