/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayFilter;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.GatewayParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;

public class GatewayFactory {
    public static GatewayFilter create(GatewayDescriptor descriptor) throws URISyntaxException {
        GatewayFilter filter = new GatewayFilter();
        for (ResourceDescriptor resource : descriptor.resources()) {
            GatewayFactory.addResource(filter, resource);
        }
        return filter;
    }

    private static void addResource(GatewayFilter gateway, ResourceDescriptor resource) throws URISyntaxException {
        for (FilterDescriptor filter : resource.filters()) {
            GatewayFactory.addFilter(gateway, filter);
        }
    }

    private static void addFilter(GatewayFilter gateway, FilterDescriptor filter) throws URISyntaxException {
        String name = filter.name();
        if (name == null) {
            name = filter.role();
        }
        gateway.addFilter(filter.up().pattern(), name, filter.impl(), GatewayFactory.createParams(filter), filter.up().role());
    }

    private static Map<String, String> createParams(FilterDescriptor filter) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        ResourceDescriptor resource = filter.up();
        GatewayDescriptor gateway = resource.up();
        for (GatewayParamDescriptor param : gateway.params()) {
            paramMap.put(param.name(), param.value());
        }
        for (GatewayParamDescriptor param : resource.params()) {
            paramMap.put(param.name(), param.value());
        }
        paramMap.put("pattern", resource.pattern());
        List paramList = filter.params();
        for (FilterParamDescriptor param : paramList) {
            paramMap.put(param.name(), param.value());
        }
        return paramMap;
    }
}

