/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.alias;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.alias.AliasResponse;

public abstract class AbstractAliasRequest
extends AbstractRequest<AliasResponse> {
    public static final String SERVICE_PATH = "/admin/api/v1/aliases";
    protected static final String GATEWAY_CLUSTER_NAME = "__gateway";
    private HttpRequestBase httpRequest;
    protected URI requestURI;
    protected String clusterName;

    protected abstract RequestType getRequestType();

    AbstractAliasRequest(KnoxSession session) {
        this(session, null, null);
    }

    AbstractAliasRequest(KnoxSession session, String clusterName) {
        this(session, clusterName, null);
    }

    AbstractAliasRequest(KnoxSession session, String clusterName, String doAsUser) {
        super(session, doAsUser);
        this.clusterName = clusterName != null ? clusterName : GATEWAY_CLUSTER_NAME;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public HttpRequestBase getRequest() {
        return this.httpRequest;
    }

    @Override
    protected Callable<AliasResponse> callable() {
        return () -> {
            this.httpRequest = this.createRequest();
            try {
                return this.createResponse((HttpResponse)this.execute((HttpRequest)this.httpRequest));
            }
            catch (ErrorResponse e) {
                return new AliasResponse(e.getResponse());
            }
        };
    }

    protected URI buildURI() {
        try {
            URIBuilder uri = this.uri(this.getPathElements().toArray(new String[0]));
            return uri.build();
        }
        catch (URISyntaxException e) {
            throw new KnoxShellException(e);
        }
    }

    protected List<String> getPathElements() {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(SERVICE_PATH);
        if (this.clusterName != null) {
            elements.add("/");
            elements.add(this.clusterName);
        }
        return elements;
    }

    protected HttpRequestBase createRequest() {
        HttpPost request;
        switch (this.getRequestType()) {
            case POST: {
                request = new HttpPost(this.requestURI);
                break;
            }
            case PUT: {
                request = new HttpPut(this.requestURI);
                break;
            }
            case DELETE: {
                request = new HttpDelete(this.requestURI);
                break;
            }
            default: {
                request = new HttpGet(this.requestURI);
            }
        }
        return request;
    }

    protected AliasResponse createResponse(HttpResponse response) {
        return new AliasResponse(response);
    }

    protected static enum RequestType {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

