/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StartTlsResponse;
import org.apache.james.protocols.pop3.core.AbstractPOP3CommandHandler;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.MDCConstants;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StlsCmdHandler
extends AbstractPOP3CommandHandler
implements CapaCapability {
    private static final Logger LOGGER = LoggerFactory.getLogger(StlsCmdHandler.class);
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"STLS");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"STLS");
    private static final Response BEGIN_TLS = new POP3StartTlsResponse("+OK", "Begin TLS negotiation").immutable();
    private final MetricFactory metricFactory;

    @Inject
    public StlsCmdHandler(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public Response onCommand(POP3Session session, Request request) {
        return (Response)this.metricFactory.decorateSupplierWithTimerMetric("pop3-stls", () -> (Response)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("action", "START_TLS").addToContext(MDCConstants.withSession(session)), () -> this.stls(session)));
    }

    private Response stls(POP3Session session) {
        LOGGER.trace("STLS command received");
        if (session.isStartTLSSupported() && session.getHandlerState() == 0 && !session.isTLSStarted()) {
            return BEGIN_TLS;
        }
        return POP3Response.ERR;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.isStartTLSSupported() && session.getHandlerState() == 0) {
            return CAPS;
        }
        return Collections.emptySet();
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }
}

