/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IteratorWrapper<U>
implements Iterator<U> {
    private final Iterator<U> underlying;
    private final List<U> entriesSeen;

    public IteratorWrapper(Iterator<U> underlying) {
        Preconditions.checkNotNull(underlying);
        this.underlying = underlying;
        this.entriesSeen = new ArrayList<U>();
    }

    public List<U> getEntriesSeen() {
        return ImmutableList.copyOf(this.entriesSeen);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public U next() {
        U next = this.underlying.next();
        this.entriesSeen.add(next);
        return next;
    }

    @Override
    public void remove() {
        this.underlying.remove();
    }
}

