/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.util.MDCBuilder;

public class SMTPMDCContextFactory
implements ProtocolMDCContextFactory {
    public MDCBuilder onBound(Protocol protocol, ChannelHandlerContext ctx) {
        return ProtocolMDCContextFactory.mdcContext((Protocol)protocol, (ChannelHandlerContext)ctx);
    }

    public MDCBuilder withContext(ProtocolSession protocolSession) {
        return this.from(protocolSession);
    }

    public static MDCBuilder forSession(SMTPSession smtpSession) {
        return SMTPMDCContextFactory.forSMTPSession(smtpSession);
    }

    private MDCBuilder from(Object o) {
        return Optional.ofNullable(o).filter(SMTPSession.class::isInstance).map(SMTPSession.class::cast).map(SMTPMDCContextFactory::forSMTPSession).orElse(MDCBuilder.create());
    }

    private static MDCBuilder forSMTPSession(SMTPSession smtpSession) {
        return MDCBuilder.create().addToContext(ProtocolMDCContextFactory.from((Object)smtpSession)).addToContextIfPresent("ehlo", smtpSession.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection)).addToContextIfPresent("sender", smtpSession.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).map(MaybeSender::asString)).addToContextIfPresent("recipients", smtpSession.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).map(Objects::toString));
    }
}

