/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.apache.james.blob.objectstorage.aws.BucketNameResolver;
import org.apache.james.blob.objectstorage.aws.MinimalCopyBytesResponseTransformer;
import org.apache.james.blob.objectstorage.aws.S3BlobStoreConfiguration;
import org.apache.james.blob.objectstorage.aws.S3ClientFactory;
import org.apache.james.blob.objectstorage.aws.S3RequestOption;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.BucketAlreadyOwnedByYouException;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

@Singleton
public class S3BlobStoreDAO
implements BlobStoreDAO {
    private static final int CHUNK_SIZE = 102400;
    private static final int EMPTY_BUCKET_BATCH_SIZE = 1000;
    private static final int FILE_THRESHOLD = 102400;
    private static final Duration FIRST_BACK_OFF = Duration.ofMillis(100L);
    private static final boolean LAZY = false;
    private static final int MAX_RETRIES = 5;
    private final BucketNameResolver bucketNameResolver;
    private final S3AsyncClient client;
    private final S3BlobStoreConfiguration configuration;
    private final BlobId.Factory blobIdFactory;
    private final S3RequestOption s3RequestOption;
    private final Optional<BucketName> fallbackNamespace;

    @Inject
    public S3BlobStoreDAO(S3ClientFactory s3ClientFactory, S3BlobStoreConfiguration configuration, BlobId.Factory blobIdFactory, S3RequestOption s3RequestOption) {
        this.configuration = configuration;
        this.client = s3ClientFactory.get();
        this.blobIdFactory = blobIdFactory;
        this.s3RequestOption = s3RequestOption;
        this.fallbackNamespace = configuration.getFallbackNamespace();
        this.bucketNameResolver = BucketNameResolver.builder().prefix(configuration.getBucketPrefix()).namespace(configuration.getNamespace()).build();
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return ReactorUtils.toInputStream(((FluxResponse)this.getObject((BucketName)resolvedBucketName, (BlobId)blobId).onErrorMap(NoSuchBucketException.class, (Function<NoSuchBucketException, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$read$0(org.apache.james.blob.api.BucketName software.amazon.awssdk.services.s3.model.NoSuchBucketException ), (Lsoftware/amazon/awssdk/services/s3/model/NoSuchBucketException;)Ljava/lang/Throwable;)((BucketName)resolvedBucketName)).onErrorMap(NoSuchKeyException.class, (Function<NoSuchKeyException, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$read$1(org.apache.james.blob.api.BlobId org.apache.james.blob.api.BucketName software.amazon.awssdk.services.s3.model.NoSuchKeyException ), (Lsoftware/amazon/awssdk/services/s3/model/NoSuchKeyException;)Ljava/lang/Throwable;)((BlobId)blobId, (BucketName)resolvedBucketName)).block()).flux);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.getObject(resolvedBucketName, blobId).onErrorMap(NoSuchBucketException.class, e -> new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e)).onErrorMap(NoSuchKeyException.class, e -> new ObjectNotFoundException("Blob not found " + blobId.asString() + " in bucket " + resolvedBucketName.asString(), (Throwable)e)).publishOn(ReactorUtils.BLOCKING_CALL_WRAPPER).map(res -> ReactorUtils.toInputStream(res.flux));
    }

    private Mono<FluxResponse> getObject(BucketName bucketName, BlobId blobId) {
        return this.getObjectFromStore(bucketName, blobId).onErrorResume(e -> e instanceof NoSuchKeyException || e instanceof NoSuchBucketException, e -> {
            if (this.fallbackNamespace.isPresent() && this.bucketNameResolver.isNameSpace(bucketName)) {
                BucketName resolvedFallbackBucketName = this.bucketNameResolver.resolve(this.fallbackNamespace.get());
                return this.getObjectFromStore(resolvedFallbackBucketName, blobId);
            }
            return Mono.error((Throwable)e);
        });
    }

    private Mono<FluxResponse> getObjectFromStore(BucketName bucketName, BlobId blobId) {
        return this.buildGetObjectRequestBuilder(bucketName, blobId).flatMap(getObjectRequestBuilder -> Mono.fromFuture(() -> this.client.getObject((GetObjectRequest)getObjectRequestBuilder.build(), (AsyncResponseTransformer)new AsyncResponseTransformer<GetObjectResponse, FluxResponse>(this){
            FluxResponse response;

            public CompletableFuture<FluxResponse> prepare() {
                this.response = new FluxResponse();
                return this.response.supportingCompletableFuture;
            }

            public void onResponse(GetObjectResponse response) {
                this.response.sdkResponse = response;
            }

            public void exceptionOccurred(Throwable error) {
                this.response.supportingCompletableFuture.completeExceptionally(error);
            }

            public void onStream(SdkPublisher<ByteBuffer> publisher) {
                this.response.flux = Flux.from(publisher);
                this.response.supportingCompletableFuture.complete(this.response);
            }
        })).switchIfEmpty(Mono.error(() -> new ObjectStoreIOException("Request was unexpectedly canceled, no GetObjectResponse"))));
    }

    public Mono<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.getObjectBytes(resolvedBucketName, blobId).onErrorMap(NoSuchBucketException.class, e -> new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e)).onErrorMap(NoSuchKeyException.class, e -> new ObjectNotFoundException("Blob not found " + blobId.asString() + " in bucket " + resolvedBucketName.asString(), (Throwable)e)).publishOn(Schedulers.parallel()).map(BytesWrapper::asByteArrayUnsafe).onErrorMap(e -> e.getCause() instanceof OutOfMemoryError, Throwable::getCause);
    }

    private Mono<ResponseBytes<GetObjectResponse>> getObjectBytes(BucketName bucketName, BlobId blobId) {
        return this.getObjectBytesFromStore(bucketName, blobId).onErrorResume(e -> e instanceof NoSuchKeyException || e instanceof NoSuchBucketException, e -> {
            if (this.fallbackNamespace.isPresent() && this.bucketNameResolver.isNameSpace(bucketName)) {
                BucketName resolvedFallbackBucketName = this.bucketNameResolver.resolve(this.fallbackNamespace.get());
                return this.getObjectBytesFromStore(resolvedFallbackBucketName, blobId);
            }
            return Mono.error((Throwable)e);
        });
    }

    private Mono<ResponseBytes<GetObjectResponse>> getObjectBytesFromStore(BucketName bucketName, BlobId blobId) {
        return this.buildGetObjectRequestBuilder(bucketName, blobId).flatMap(putObjectRequest -> Mono.fromFuture(() -> this.client.getObject((GetObjectRequest)putObjectRequest.build(), (AsyncResponseTransformer)new MinimalCopyBytesResponseTransformer(this.configuration, blobId))));
    }

    private Mono<GetObjectRequest.Builder> buildGetObjectRequestBuilder(BucketName bucketName, BlobId blobId) {
        GetObjectRequest.Builder baseBuilder = GetObjectRequest.builder().bucket(bucketName.asString()).key(blobId.asString());
        if (this.s3RequestOption.ssec().enable()) {
            return Mono.from(this.s3RequestOption.ssec().sseCustomerKeyFactory().get().generate(bucketName, blobId)).map(sseCustomerKey -> baseBuilder.sseCustomerAlgorithm(sseCustomerKey.ssecAlgorithm()).sseCustomerKey(sseCustomerKey.customerKey()).sseCustomerKeyMD5(sseCustomerKey.md5()));
        }
        return Mono.just((Object)baseBuilder);
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.buildPutObjectRequestBuilder(resolvedBucketName, data.length, blobId).flatMap(putObjectRequest -> Mono.fromFuture(() -> this.client.putObject((PutObjectRequest)putObjectRequest.build(), AsyncRequestBody.fromBytes((byte[])data))).retryWhen((Retry)this.createBucketOnRetry(resolvedBucketName)).publishOn(Schedulers.parallel())).then();
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)inputStream);
        return this.uploadUsingFile(bucketName, blobId, inputStream);
    }

    private Mono<Void> uploadUsingFile(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        return Mono.using(() -> new FileBackedOutputStream(102400), fileBackedOutputStream -> Mono.fromCallable(() -> IOUtils.copy((InputStream)inputStream, (OutputStream)fileBackedOutputStream)).flatMap(size -> this.save(bucketName, blobId, new FileBackedOutputStreamByteSource((FileBackedOutputStream)fileBackedOutputStream, size.intValue()))), (Consumer)Throwing.consumer(FileBackedOutputStream::reset), (boolean)false).onErrorMap(IOException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).publishOn(Schedulers.parallel());
    }

    public Mono<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.fromCallable(() -> ((ByteSource)content).size()).subscribeOn(Schedulers.boundedElastic()).flatMap(contentLength -> Mono.usingWhen((Publisher)Mono.fromCallable(() -> ((ByteSource)content).openStream()).subscribeOn(Schedulers.boundedElastic()), stream -> this.save(resolvedBucketName, blobId, (InputStream)stream, (long)contentLength), stream -> Mono.fromRunnable((Runnable)Throwing.runnable(stream::close)))).retryWhen((Retry)this.createBucketOnRetry(resolvedBucketName)).onErrorMap(IOException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).retryWhen(this.configuration.uploadRetrySpec()).onErrorMap(SdkClientException.class, e -> new ObjectStoreIOException("Error saving blob", (Throwable)e)).then();
    }

    private Mono<PutObjectResponse> save(BucketName resolvedBucketName, BlobId blobId, InputStream stream, long contentLength) {
        int chunkSize = Math.min((int)contentLength, 102400);
        return this.buildPutObjectRequestBuilder(resolvedBucketName, contentLength, blobId).flatMap(putObjectRequest -> Mono.fromFuture(() -> this.client.putObject((PutObjectRequest)putObjectRequest.build(), AsyncRequestBody.fromPublisher((Publisher)this.chunkStream(chunkSize, stream).subscribeOn(Schedulers.boundedElastic())))));
    }

    private Mono<PutObjectRequest.Builder> buildPutObjectRequestBuilder(BucketName bucketName, long contentLength, BlobId blobId) {
        PutObjectRequest.Builder baseBuilder = PutObjectRequest.builder().bucket(bucketName.asString()).key(blobId.asString()).contentLength(Long.valueOf(contentLength));
        if (this.s3RequestOption.ssec().enable()) {
            return Mono.from(this.s3RequestOption.ssec().sseCustomerKeyFactory().get().generate(bucketName, blobId)).map(sseCustomerKey -> baseBuilder.sseCustomerAlgorithm(sseCustomerKey.ssecAlgorithm()).sseCustomerKey(sseCustomerKey.customerKey()).sseCustomerKeyMD5(sseCustomerKey.md5()));
        }
        return Mono.just((Object)baseBuilder);
    }

    private Flux<ByteBuffer> chunkStream(int chunkSize, InputStream stream) {
        if (chunkSize == 0) {
            return Flux.empty();
        }
        return ReactorUtils.toChunks((InputStream)stream, (int)chunkSize).subscribeOn(Schedulers.boundedElastic());
    }

    private RetryBackoffSpec createBucketOnRetry(BucketName bucketName) {
        return RetryBackoffSpec.backoff((long)5L, (Duration)FIRST_BACK_OFF).maxAttempts(5L).doBeforeRetryAsync(retrySignal -> {
            if (retrySignal.failure() instanceof NoSuchBucketException) {
                return Mono.fromFuture((CompletableFuture)this.client.createBucket(builder -> builder.bucket(bucketName.asString()))).onErrorResume(BucketAlreadyOwnedByYouException.class, e -> Mono.empty()).then();
            }
            return Mono.error((Throwable)retrySignal.failure());
        });
    }

    public Mono<Void> delete(BucketName bucketName, BlobId blobId) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return Mono.fromFuture(() -> this.client.deleteObject(delete -> delete.bucket(resolvedBucketName.asString()).key(blobId.asString()))).then().onErrorResume(NoSuchBucketException.class, e -> Mono.empty()).publishOn(Schedulers.parallel());
    }

    public Publisher<Void> delete(BucketName bucketName, Collection<BlobId> blobIds) {
        return this.deleteObjects(bucketName, (List)blobIds.stream().map(BlobId::asString).map(id -> (ObjectIdentifier)ObjectIdentifier.builder().key(id).build()).collect(ImmutableList.toImmutableList())).then().onErrorResume(NoSuchBucketException.class, e -> Mono.empty());
    }

    public Mono<Void> deleteBucket(BucketName bucketName) {
        BucketName resolvedBucketName = this.bucketNameResolver.resolve(bucketName);
        return this.deleteResolvedBucket(resolvedBucketName);
    }

    private Mono<Void> deleteResolvedBucket(BucketName bucketName) {
        return this.emptyBucket(bucketName).onErrorResume(throwable -> throwable instanceof CompletionException && throwable.getCause() instanceof NoSuchBucketException, t -> Mono.just((Object)bucketName)).flatMap(ignore -> Mono.fromFuture(() -> this.client.deleteBucket(builder -> builder.bucket(bucketName.asString())))).onErrorResume(NoSuchBucketException.class, t -> Mono.empty()).then().publishOn(Schedulers.parallel());
    }

    private Mono<BucketName> emptyBucket(BucketName bucketName) {
        return Flux.from((Publisher)this.client.listObjectsV2Paginator(builder -> builder.bucket(bucketName.asString()))).flatMap(response -> Flux.fromIterable((Iterable)response.contents()).window(1000).flatMap(this::buildListForBatch, 16).flatMap(identifiers -> this.deleteObjects(bucketName, (List<ObjectIdentifier>)identifiers), 16).then(Mono.just((Object)response))).then(Mono.just((Object)bucketName));
    }

    private Mono<List<ObjectIdentifier>> buildListForBatch(Flux<S3Object> batch) {
        return batch.map(element -> (ObjectIdentifier)ObjectIdentifier.builder().key(element.key()).build()).collect(ImmutableList.toImmutableList());
    }

    private Mono<DeleteObjectsResponse> deleteObjects(BucketName bucketName, List<ObjectIdentifier> identifiers) {
        return Mono.fromFuture(() -> this.client.deleteObjects(builder -> builder.bucket(bucketName.asString()).delete(delete -> delete.objects((Collection)identifiers))));
    }

    @VisibleForTesting
    public Mono<Void> deleteAllBuckets() {
        return Mono.fromFuture(() -> ((S3AsyncClient)this.client).listBuckets()).publishOn(Schedulers.parallel()).flatMapIterable(ListBucketsResponse::buckets).flatMap(bucket -> this.deleteResolvedBucket(BucketName.of((String)bucket.name())), 16).then();
    }

    public Publisher<BucketName> listBuckets() {
        return Mono.fromFuture(() -> ((S3AsyncClient)this.client).listBuckets()).flatMapIterable(ListBucketsResponse::buckets).map(Bucket::name).handle((bucket, sink) -> this.bucketNameResolver.unresolve(BucketName.of((String)bucket)).ifPresent(arg_0 -> ((SynchronousSink)sink).next(arg_0)));
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return Flux.from((Publisher)this.client.listObjectsV2Paginator(builder -> builder.bucket(bucketName.asString()))).flatMapIterable(ListObjectsV2Response::contents).map(S3Object::key).map(arg_0 -> ((BlobId.Factory)this.blobIdFactory).parse(arg_0)).onErrorResume(e -> e.getCause() instanceof NoSuchBucketException, e -> Flux.empty()).onErrorResume(NoSuchBucketException.class, e -> Flux.empty());
    }

    private static /* synthetic */ Throwable lambda$read$1(BlobId blobId, BucketName resolvedBucketName, NoSuchKeyException e) {
        return new ObjectNotFoundException("Blob not found " + blobId.asString() + " in bucket " + resolvedBucketName.asString(), (Throwable)e);
    }

    private static /* synthetic */ Throwable lambda$read$0(BucketName resolvedBucketName, NoSuchBucketException e) {
        return new ObjectNotFoundException("Bucket not found " + resolvedBucketName.asString(), (Throwable)e);
    }

    private static class FluxResponse {
        final CompletableFuture<FluxResponse> supportingCompletableFuture = new CompletableFuture();
        GetObjectResponse sdkResponse;
        Flux<ByteBuffer> flux;

        private FluxResponse() {
        }
    }

    private static class FileBackedOutputStreamByteSource
    extends ByteSource {
        private final FileBackedOutputStream stream;
        private final long size;

        private FileBackedOutputStreamByteSource(FileBackedOutputStream stream, long size) {
            Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"'size' must be positive");
            this.stream = stream;
            this.size = size;
        }

        public InputStream openStream() throws IOException {
            return this.stream.asByteSource().openStream();
        }

        public com.google.common.base.Optional<Long> sizeIfKnown() {
            return com.google.common.base.Optional.of((Object)this.size);
        }

        public long size() {
            return this.size;
        }
    }
}

