/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

class EpochTime {
    private final long javaSeconds;
    private final int nanos;

    private EpochTime(long pgMicros) {
        long pgSeconds = pgMicros / 1000000L;
        this.javaSeconds = this.toJavaSeconds(pgSeconds);
        this.nanos = (int)(pgMicros - pgSeconds * 1000000L) * 1000;
    }

    static EpochTime fromInt(int pgDays) {
        return new EpochTime((long)pgDays * 86400L * 1000000L);
    }

    static EpochTime fromLong(long pgMicros) {
        return new EpochTime(pgMicros);
    }

    long getJavaDays() {
        return this.javaSeconds / 86400L;
    }

    int getNanos() {
        return this.nanos;
    }

    long getSeconds() {
        return this.javaSeconds;
    }

    Instant toInstant() {
        return Instant.ofEpochSecond(this.getSeconds(), this.getNanos());
    }

    LocalDateTime toLocalDateTime() {
        return LocalDateTime.ofEpochSecond(this.getSeconds(), this.getNanos(), ZoneOffset.UTC);
    }

    private long toJavaSeconds(long secs) {
        if ((secs += 946684800L) < -12219292800L && (secs += 864000L) < -14825808000L) {
            int extraLeaps = (int)((secs + 14825808000L) / 3155760000L);
            --extraLeaps;
            extraLeaps -= extraLeaps / 4;
            secs += (long)extraLeaps * 86400L;
        }
        return secs;
    }
}

