/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

public final class WrapperSystemPropertyUtil {
    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = System.getProperty(name);
        return val != null && val.equalsIgnoreCase("TRUE");
    }

    public static int getIntProperty(String name, int defaultValue) {
        String val = System.getProperty(name);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static long getLongProperty(String name, long defaultValue) {
        String val = System.getProperty(name);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private WrapperSystemPropertyUtil() {
    }
}

