/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.io.Serializable;
import org.apache.activemq.artemis.commons.shaded.json.JsonArray;
import org.apache.activemq.artemis.commons.shaded.json.JsonObject;
import org.apache.activemq.artemis.commons.shaded.json.JsonStructure;
import org.apache.activemq.artemis.commons.shaded.json.JsonWriter;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonGenerator;

class JsonWriterImpl
implements JsonWriter,
Serializable {
    private final JsonGenerator generator;
    private boolean closed = false;

    JsonWriterImpl(JsonGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void writeArray(JsonArray array) {
        this.checkClosed();
        this.generator.write(array);
        this.close();
    }

    @Override
    public void writeObject(JsonObject object) {
        this.checkClosed();
        this.generator.write(object);
        this.close();
    }

    @Override
    public void write(JsonStructure value) {
        this.checkClosed();
        this.generator.write(value);
        this.close();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.generator.close();
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("writeArray(), writeObject(), write() or close() method was already called");
        }
    }
}

