/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.LDAPBindException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SCRAMBindRequest;
import com.unboundid.ldap.sdk.SCRAMClientFirstMessage;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class SCRAMServerFirstMessage
implements Serializable {
    private static final int MINIMUM_ALLOWED_ITERATION_COUNT = 4096;
    private static final long serialVersionUID = 3888813341685523286L;
    @NotNull
    private final BindResult bindResult;
    @NotNull
    private final byte[] salt;
    private final int iterationCount;
    @NotNull
    private final SCRAMBindRequest bindRequest;
    @NotNull
    private final SCRAMClientFirstMessage clientFirstMessage;
    @NotNull
    private final String serverFirstMessage;
    @NotNull
    private final String combinedNonce;
    @NotNull
    private final String serverNonce;

    SCRAMServerFirstMessage(@NotNull SCRAMBindRequest bindRequest, @NotNull SCRAMClientFirstMessage clientFirstMessage, @NotNull BindResult bindResult) throws LDAPBindException {
        this.bindRequest = bindRequest;
        this.clientFirstMessage = clientFirstMessage;
        this.bindResult = bindResult;
        ASN1OctetString serverSASLCredentials = bindResult.getServerSASLCredentials();
        if (serverSASLCredentials == null) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_NO_CREDS.get(bindRequest.getSASLMechanismName()), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        this.serverFirstMessage = serverSASLCredentials.stringValue();
        if (!this.serverFirstMessage.startsWith("r=")) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_NO_NONCE.get(bindRequest.getSASLMechanismName(), this.serverFirstMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        int commaSEqualsPos = this.serverFirstMessage.indexOf(",s=");
        if (commaSEqualsPos < 0) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_NO_SALT.get(bindRequest.getSASLMechanismName(), this.serverFirstMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        int commaIEqualsPos = this.serverFirstMessage.indexOf(",i=", commaSEqualsPos);
        if (commaIEqualsPos < 0) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_NO_ITERATION_COUNT.get(bindRequest.getSASLMechanismName(), this.serverFirstMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        this.combinedNonce = this.serverFirstMessage.substring(2, commaSEqualsPos);
        if (!this.combinedNonce.startsWith(clientFirstMessage.getClientNonce())) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_NONCE_MISSING_CLIENT.get(bindRequest.getSASLMechanismName(), this.serverFirstMessage, this.combinedNonce, clientFirstMessage.getClientNonce(), clientFirstMessage.getClientFirstMessage()), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        if (this.combinedNonce.equals(clientFirstMessage.getClientNonce())) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_NONCE_MISSING_SERVER.get(bindRequest.getSASLMechanismName(), this.serverFirstMessage, this.combinedNonce, clientFirstMessage.getClientFirstMessage()), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        this.serverNonce = this.combinedNonce.substring(clientFirstMessage.getClientNonce().length());
        String saltString = this.serverFirstMessage.substring(commaSEqualsPos + 3, commaIEqualsPos);
        if (saltString.isEmpty()) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_SALT_EMPTY.get(bindRequest.getSASLMechanismName(), this.serverFirstMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        try {
            this.salt = Base64.decode(saltString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_SALT_NOT_BASE64.get(bindRequest.getSASLMechanismName(), saltString, this.serverFirstMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        int extensionCommaPos = this.serverFirstMessage.indexOf(44, commaIEqualsPos + 1);
        String iterationCountString = extensionCommaPos > 0 ? this.serverFirstMessage.substring(commaIEqualsPos + 3, extensionCommaPos) : this.serverFirstMessage.substring(commaIEqualsPos + 3);
        try {
            this.iterationCount = Integer.parseInt(iterationCountString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_ITERATION_COUNT_NOT_INTEGER.get(bindRequest.getSASLMechanismName(), iterationCountString, this.serverFirstMessage), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
        if (this.iterationCount < 4096) {
            throw new LDAPBindException(new BindResult(bindResult.getMessageID(), ResultCode.DECODING_ERROR, LDAPMessages.ERR_SCRAM_SERVER_FIRST_MESSAGE_ITERATION_COUNT_BELOW_MINIMUM.get(bindRequest.getSASLMechanismName(), this.iterationCount, this.serverFirstMessage, 4096), bindResult.getMatchedDN(), bindResult.getReferralURLs(), bindResult.getResponseControls(), serverSASLCredentials));
        }
    }

    @NotNull
    SCRAMBindRequest getBindRequest() {
        return this.bindRequest;
    }

    @NotNull
    SCRAMClientFirstMessage getClientFirstMessage() {
        return this.clientFirstMessage;
    }

    @NotNull
    BindResult getBindResult() {
        return this.bindResult;
    }

    @NotNull
    String getCombinedNonce() {
        return this.combinedNonce;
    }

    @NotNull
    String getServerNonce() {
        return this.serverNonce;
    }

    @NotNull
    byte[] getSalt() {
        return this.salt;
    }

    int getIterationCount() {
        return this.iterationCount;
    }

    @NotNull
    String getServerFirstMessage() {
        return this.serverFirstMessage;
    }

    @NotNull
    public String toString() {
        return this.serverFirstMessage;
    }
}

