/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RateLimiterRequestHandler
extends LDAPListenerRequestHandler {
    @Nullable
    private final FixedRateBarrier abandonRateLimiter;
    @Nullable
    private final FixedRateBarrier addRateLimiter;
    @Nullable
    private final FixedRateBarrier bindRateLimiter;
    @Nullable
    private final FixedRateBarrier compareRateLimiter;
    @Nullable
    private final FixedRateBarrier deleteRateLimiter;
    @Nullable
    private final FixedRateBarrier extendedRateLimiter;
    @Nullable
    private final FixedRateBarrier modifyRateLimiter;
    @Nullable
    private final FixedRateBarrier modifyDNRateLimiter;
    @Nullable
    private final FixedRateBarrier searchRateLimiter;
    @NotNull
    private final LDAPListenerRequestHandler downstreamRequestHandler;

    public RateLimiterRequestHandler(@NotNull LDAPListenerRequestHandler downstreamRequestHandler, int maxPerSecond) {
        Validator.ensureNotNull(downstreamRequestHandler);
        Validator.ensureTrue(maxPerSecond > 0);
        this.downstreamRequestHandler = downstreamRequestHandler;
        FixedRateBarrier rateLimiter = new FixedRateBarrier(1000L, maxPerSecond);
        this.abandonRateLimiter = null;
        this.addRateLimiter = rateLimiter;
        this.bindRateLimiter = rateLimiter;
        this.compareRateLimiter = rateLimiter;
        this.deleteRateLimiter = rateLimiter;
        this.extendedRateLimiter = rateLimiter;
        this.modifyRateLimiter = rateLimiter;
        this.modifyDNRateLimiter = rateLimiter;
        this.searchRateLimiter = rateLimiter;
    }

    public RateLimiterRequestHandler(@NotNull LDAPListenerRequestHandler downstreamRequestHandler, @Nullable FixedRateBarrier rateLimiter) {
        this(downstreamRequestHandler, null, rateLimiter, rateLimiter, rateLimiter, rateLimiter, rateLimiter, rateLimiter, rateLimiter, rateLimiter);
    }

    public RateLimiterRequestHandler(@Nullable LDAPListenerRequestHandler downstreamRequestHandler, @Nullable FixedRateBarrier abandonRateLimiter, @Nullable FixedRateBarrier addRateLimiter, @Nullable FixedRateBarrier bindRateLimiter, @Nullable FixedRateBarrier compareRateLimiter, @Nullable FixedRateBarrier deleteRateLimiter, @Nullable FixedRateBarrier extendedRateLimiter, @Nullable FixedRateBarrier modifyRateLimiter, @Nullable FixedRateBarrier modifyDNRateLimiter, @Nullable FixedRateBarrier searchRateLimiter) {
        Validator.ensureNotNull(downstreamRequestHandler);
        this.downstreamRequestHandler = downstreamRequestHandler;
        this.abandonRateLimiter = abandonRateLimiter;
        this.addRateLimiter = addRateLimiter;
        this.bindRateLimiter = bindRateLimiter;
        this.compareRateLimiter = compareRateLimiter;
        this.deleteRateLimiter = deleteRateLimiter;
        this.extendedRateLimiter = extendedRateLimiter;
        this.modifyRateLimiter = modifyRateLimiter;
        this.modifyDNRateLimiter = modifyDNRateLimiter;
        this.searchRateLimiter = searchRateLimiter;
    }

    @Override
    @NotNull
    public RateLimiterRequestHandler newInstance(@NotNull LDAPListenerClientConnection connection) throws LDAPException {
        return new RateLimiterRequestHandler(this.downstreamRequestHandler.newInstance(connection), this.abandonRateLimiter, this.addRateLimiter, this.bindRateLimiter, this.compareRateLimiter, this.deleteRateLimiter, this.extendedRateLimiter, this.modifyRateLimiter, this.modifyDNRateLimiter, this.searchRateLimiter);
    }

    @Override
    public void processAbandonRequest(int messageID, @NotNull AbandonRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.abandonRateLimiter != null) {
            this.abandonRateLimiter.await();
        }
        this.downstreamRequestHandler.processAbandonRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processAddRequest(int messageID, @NotNull AddRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.addRateLimiter != null) {
            this.addRateLimiter.await();
        }
        return this.downstreamRequestHandler.processAddRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processBindRequest(int messageID, @NotNull BindRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.bindRateLimiter != null) {
            this.bindRateLimiter.await();
        }
        return this.downstreamRequestHandler.processBindRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processCompareRequest(int messageID, @NotNull CompareRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.compareRateLimiter != null) {
            this.compareRateLimiter.await();
        }
        return this.downstreamRequestHandler.processCompareRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processDeleteRequest(int messageID, @NotNull DeleteRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.deleteRateLimiter != null) {
            this.deleteRateLimiter.await();
        }
        return this.downstreamRequestHandler.processDeleteRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processExtendedRequest(int messageID, @NotNull ExtendedRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.extendedRateLimiter != null) {
            this.extendedRateLimiter.await();
        }
        return this.downstreamRequestHandler.processExtendedRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processModifyRequest(int messageID, @NotNull ModifyRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.modifyRateLimiter != null) {
            this.modifyRateLimiter.await();
        }
        return this.downstreamRequestHandler.processModifyRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processModifyDNRequest(int messageID, @NotNull ModifyDNRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.modifyDNRateLimiter != null) {
            this.modifyDNRateLimiter.await();
        }
        return this.downstreamRequestHandler.processModifyDNRequest(messageID, request, controls);
    }

    @Override
    @NotNull
    public LDAPMessage processSearchRequest(int messageID, @NotNull SearchRequestProtocolOp request, @NotNull List<Control> controls) {
        if (this.searchRateLimiter != null) {
            this.searchRateLimiter.await();
        }
        return this.downstreamRequestHandler.processSearchRequest(messageID, request, controls);
    }
}

