/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.fastfail;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.executor.SPFResult;
import org.apache.james.jspf.impl.DefaultSPF;
import org.apache.james.jspf.impl.SPF;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandler;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.RcptHook;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPFHandler
implements JamesMessageHook,
MailHook,
RcptHook,
ProtocolHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SPFHandler.class);
    private static final Logger FALLBACK_LOG = LoggerFactory.getLogger(SPFHandler.class);
    private final Logger serviceLog = FALLBACK_LOG;
    private static final ProtocolSession.AttachmentKey<Boolean> SPF_BLOCKLISTED = ProtocolSession.AttachmentKey.of((String)"SPF_BLOCKLISTED", Boolean.class);
    private static final ProtocolSession.AttachmentKey<String> SPF_DETAIL = ProtocolSession.AttachmentKey.of((String)"SPF_DETAIL", String.class);
    private static final ProtocolSession.AttachmentKey<Boolean> SPF_TEMPBLOCKLISTED = ProtocolSession.AttachmentKey.of((String)"SPF_TEMPBLOCKLISTED", Boolean.class);
    private static final ProtocolSession.AttachmentKey<String> SPF_HEADER = ProtocolSession.AttachmentKey.of((String)"SPF_HEADER", String.class);
    private static final AttributeName SPF_HEADER_MAIL_ATTRIBUTE_NAME = AttributeName.of((String)"org.apache.james.spf.header");
    private boolean blockSoftFail = false;
    private boolean blockPermError = true;
    private SPF spf = new DefaultSPF((org.apache.james.jspf.core.Logger)new SPFLogger(this.serviceLog));

    public void setBlockSoftFail(boolean blockSoftFail) {
        this.blockSoftFail = blockSoftFail;
    }

    public void setBlockPermError(boolean blockPermError) {
        this.blockPermError = blockPermError;
    }

    @Inject
    public void setDNSService(DNSService dnsService) {
        this.spf = new SPF(dnsService, (org.apache.james.jspf.core.Logger)new SPFLogger(this.serviceLog));
    }

    private void doSPFCheck(SMTPSession session, MaybeSender sender) {
        Optional heloEhlo = session.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection);
        if (sender.isNullSender() || !heloEhlo.isPresent()) {
            LOGGER.info("No Sender or HELO/EHLO present");
        } else {
            String ip = session.getRemoteAddress().getAddress().getHostAddress();
            SPFResult result = this.spf.checkSPF(ip, sender.asString(), (String)heloEhlo.get());
            String spfResult = result.getResult();
            Object explanation = "Blocked - see: " + result.getExplanation();
            session.setAttachment(SPF_HEADER, (Object)result.getHeaderText(), ProtocolSession.State.Transaction);
            LOGGER.info("Result for {} - {} - {} = {}", new Object[]{ip, sender.asString(), heloEhlo, spfResult});
            if (spfResult.equals("fail") || spfResult.equals("softfail") && this.blockSoftFail || spfResult.equals("permerror") && this.blockPermError) {
                if (spfResult.equals("permerror")) {
                    explanation = "Block caused by an invalid SPF record";
                }
                session.setAttachment(SPF_DETAIL, explanation, ProtocolSession.State.Transaction);
                session.setAttachment(SPF_BLOCKLISTED, (Object)true, ProtocolSession.State.Transaction);
            } else if (spfResult.equals("temperror")) {
                session.setAttachment(SPF_TEMPBLOCKLISTED, (Object)true, ProtocolSession.State.Transaction);
            }
        }
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        if (!session.isRelayingAllowed()) {
            if (session.getAttachment(SPF_BLOCKLISTED, ProtocolSession.State.Transaction).isPresent()) {
                return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpDescription(DSNStatus.getStatus((int)5, (String)"7.1") + " " + session.getAttachment(SPF_TEMPBLOCKLISTED, ProtocolSession.State.Transaction).orElse(false)).build();
            }
            if (session.getAttachment(SPF_TEMPBLOCKLISTED, ProtocolSession.State.Transaction).isPresent()) {
                return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("451").smtpDescription(DSNStatus.getStatus((int)4, (String)"4.3") + " Temporarily rejected: Problem on SPF lookup").build();
            }
        }
        return HookResult.DECLINED;
    }

    public HookResult doMail(SMTPSession session, MaybeSender sender) {
        this.doSPFCheck(session, sender);
        return HookResult.DECLINED;
    }

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        mail.setAttribute(new Attribute(SPF_HEADER_MAIL_ATTRIBUTE_NAME, AttributeValue.of((String)((String)session.getAttachment(SPF_HEADER, ProtocolSession.State.Transaction).get()))));
        return null;
    }

    public void init(Configuration config) throws ConfigurationException {
        this.setBlockSoftFail(config.getBoolean("blockSoftFail", false));
        this.setBlockPermError(config.getBoolean("blockPermError", true));
    }

    public static class SPFLogger
    implements org.apache.james.jspf.core.Logger {
        private final Logger serviceLog;

        public SPFLogger(Logger serviceLog) {
            this.serviceLog = serviceLog;
        }

        public SPFLogger() {
            this.serviceLog = FALLBACK_LOG;
        }

        public void debug(String message) {
            this.serviceLog.debug(message);
        }

        public void debug(String message, Throwable t) {
            this.serviceLog.debug(message, t);
        }

        public void error(String message) {
            this.serviceLog.error(message);
        }

        public void error(String message, Throwable t) {
            this.serviceLog.error(message, t);
        }

        public void fatalError(String message) {
            this.serviceLog.error(message);
        }

        public void fatalError(String message, Throwable t) {
            this.serviceLog.error(message, t);
        }

        public void info(String message) {
            this.serviceLog.info(message);
        }

        public void info(String message, Throwable t) {
            this.serviceLog.info(message, t);
        }

        public boolean isDebugEnabled() {
            return this.serviceLog.isDebugEnabled();
        }

        public boolean isErrorEnabled() {
            return this.serviceLog.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return this.serviceLog.isErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return this.serviceLog.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.serviceLog.isWarnEnabled();
        }

        public void warn(String message) {
            this.serviceLog.warn(message);
        }

        public void warn(String message, Throwable t) {
            this.serviceLog.warn(message, t);
        }

        public org.apache.james.jspf.core.Logger getChildLogger(String name) {
            return this;
        }
    }
}

