/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.message.view.MessageView;
import org.apache.james.mailbox.model.MessageId;

@JsonDeserialize(builder=Builder.class)
public class GetMessagesResponse
implements Method.Response {
    private final Set<MessageView> messages;
    private final Set<MessageId> messagesNotFound;

    public static Builder builder() {
        return new Builder();
    }

    private GetMessagesResponse(Set<MessageView> messages, Set<MessageId> messagesNotFound) {
        this.messages = messages;
        this.messagesNotFound = messagesNotFound;
    }

    @JsonSerialize
    public Set<MessageView> list() {
        return this.messages;
    }

    @JsonSerialize
    public Set<MessageId> notFound() {
        return this.messagesNotFound;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private ImmutableSet<MessageView> messages = ImmutableSet.of();
        private Set<MessageId> expectedMessageIds;

        private Builder() {
        }

        @JsonIgnore
        public Builder message(MessageView message) {
            this.messages = ImmutableSet.of((Object)message);
            return this;
        }

        public Builder messages(Collection<? extends MessageView> messages) {
            this.messages = ImmutableSet.copyOf(messages);
            return this;
        }

        public Builder expectedMessageIds(List<MessageId> expectedMessageIds) {
            this.expectedMessageIds = ImmutableSet.copyOf(expectedMessageIds);
            return this;
        }

        public GetMessagesResponse build() {
            Preconditions.checkState((this.messages != null ? 1 : 0) != 0);
            return new GetMessagesResponse((Set<MessageView>)this.messages, this.messagesNotFound());
        }

        private Set<MessageId> messagesNotFound() {
            if (this.expectedMessageIds.size() == this.messages.size()) {
                return ImmutableSet.of();
            }
            return Sets.difference(this.expectedMessageIds, this.messages.stream().map(MessageView::getId).collect(Collectors.toSet()));
        }
    }
}

