/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.mail.internet.AddressException;
import org.apache.james.core.MailAddress;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MailAddressParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAddressParser.class);

    MailAddressParser() {
    }

    static MailAddress parseMailAddress(String address, String addressType) {
        try {
            String decodedAddress = URLDecoder.decode(address, StandardCharsets.UTF_8.displayName());
            return new MailAddress(decodedAddress);
        }
        catch (AddressException e) {
            LOGGER.error("The {} {} is not an email address", (Object)addressType, (Object)address);
            throw ErrorResponder.builder().statusCode(400).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("The %s is not an email address", new Object[]{addressType}).cause((Exception)((Object)e)).haltError();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UTF-8 should be a valid encoding");
            throw ErrorResponder.builder().statusCode(500).type(ErrorResponder.ErrorType.SERVER_ERROR).message("Internal server error - Something went bad on the server side.").cause((Exception)e).haltError();
        }
    }
}

