/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.signature;

import com.google.crypto.tink.config.TinkFips;
import com.google.crypto.tink.proto.RegistryConfig;
import com.google.crypto.tink.signature.EcdsaSignKeyManager;
import com.google.crypto.tink.signature.EcdsaVerifyKeyManager;
import com.google.crypto.tink.signature.Ed25519PrivateKeyManager;
import com.google.crypto.tink.signature.Ed25519PublicKeyManager;
import com.google.crypto.tink.signature.PublicKeySignWrapper;
import com.google.crypto.tink.signature.PublicKeyVerifyWrapper;
import com.google.crypto.tink.signature.RsaSsaPkcs1SignKeyManager;
import com.google.crypto.tink.signature.RsaSsaPkcs1VerifyKeyManager;
import com.google.crypto.tink.signature.RsaSsaPssSignKeyManager;
import com.google.crypto.tink.signature.RsaSsaPssVerifyKeyManager;
import java.security.GeneralSecurityException;

public final class SignatureConfig {
    public static final String ECDSA_PUBLIC_KEY_TYPE_URL = new EcdsaVerifyKeyManager().getKeyType();
    public static final String ECDSA_PRIVATE_KEY_TYPE_URL = new EcdsaSignKeyManager().getKeyType();
    public static final String ED25519_PUBLIC_KEY_TYPE_URL = new Ed25519PublicKeyManager().getKeyType();
    public static final String ED25519_PRIVATE_KEY_TYPE_URL = new Ed25519PrivateKeyManager().getKeyType();
    public static final String RSA_PKCS1_PRIVATE_KEY_TYPE_URL = new RsaSsaPkcs1SignKeyManager().getKeyType();
    public static final String RSA_PKCS1_PUBLIC_KEY_TYPE_URL = new RsaSsaPkcs1VerifyKeyManager().getKeyType();
    public static final String RSA_PSS_PRIVATE_KEY_TYPE_URL = new RsaSsaPssSignKeyManager().getKeyType();
    public static final String RSA_PSS_PUBLIC_KEY_TYPE_URL = new RsaSsaPssVerifyKeyManager().getKeyType();
    @Deprecated
    public static final RegistryConfig TINK_1_0_0 = RegistryConfig.getDefaultInstance();
    @Deprecated
    public static final RegistryConfig TINK_1_1_0 = RegistryConfig.getDefaultInstance();
    public static final RegistryConfig LATEST = RegistryConfig.getDefaultInstance();

    @Deprecated
    public static void init() throws GeneralSecurityException {
        SignatureConfig.register();
    }

    public static void register() throws GeneralSecurityException {
        PublicKeySignWrapper.register();
        PublicKeyVerifyWrapper.register();
        EcdsaSignKeyManager.registerPair(true);
        RsaSsaPkcs1SignKeyManager.registerPair(true);
        if (TinkFips.useOnlyFips()) {
            return;
        }
        RsaSsaPssSignKeyManager.registerPair(true);
        Ed25519PrivateKeyManager.registerPair(true);
    }

    static {
        try {
            SignatureConfig.init();
        }
        catch (GeneralSecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

