/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UrlsDao {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insert;
    private final PreparedStatement selectAll;
    private final PreparedStatement select;

    @Inject
    public UrlsDao(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insert = this.prepareInsert(session);
        this.selectAll = this.prepareSelectAll(session);
        this.select = this.prepareSelect(session);
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"url"}).from("mailRepositoryUrls").where(QueryBuilder.eq((String)"url", (Object)QueryBuilder.bindMarker((String)"url"))));
    }

    private PreparedStatement prepareSelectAll(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"url"}).from("mailRepositoryUrls"));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailRepositoryUrls").value("url", (Object)QueryBuilder.bindMarker((String)"url")));
    }

    public Mono<Void> addUrl(MailRepositoryUrl url) {
        return this.executor.executeVoid((Statement)this.insert.bind().setString("url", url.asString()));
    }

    public Mono<Optional<MailRepositoryUrl>> retrieve(MailRepositoryUrl url) {
        return this.executor.executeSingleRowOptional((Statement)this.select.bind().setString("url", url.asString())).map(optional -> optional.map(this::toUrl));
    }

    public Flux<MailRepositoryUrl> retrieveUsedUrls() {
        return this.executor.executeRows((Statement)this.selectAll.bind()).map(this::toUrl);
    }

    private MailRepositoryUrl toUrl(Row row) {
        return MailRepositoryUrl.from((String)row.getString("url"));
    }
}

