/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.search.aggregations.metrics.AbstractCardinalityAlgorithm;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLog;
import org.elasticsearch.search.aggregations.metrics.AbstractLinearCounting;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlusSparse;

public abstract class AbstractHyperLogLogPlusPlus
extends AbstractCardinalityAlgorithm
implements Releasable {
    public static final boolean LINEAR_COUNTING = false;
    public static final boolean HYPERLOGLOG = true;

    public AbstractHyperLogLogPlusPlus(int precision) {
        super(precision);
    }

    protected abstract boolean getAlgorithm(long var1);

    protected abstract AbstractLinearCounting.HashesIterator getLinearCounting(long var1);

    protected abstract AbstractHyperLogLog.RunLenIterator getHyperLogLog(long var1);

    public abstract long maxOrd();

    public abstract void collect(long var1, long var3);

    public AbstractHyperLogLogPlusPlus clone(long bucketOrd, BigArrays bigArrays) {
        if (!this.getAlgorithm(bucketOrd)) {
            AbstractLinearCounting.HashesIterator iterator = this.getLinearCounting(bucketOrd);
            int size = Math.toIntExact(iterator.size());
            HyperLogLogPlusPlusSparse clone = new HyperLogLogPlusPlusSparse(this.precision(), bigArrays, size, 1);
            while (iterator.next()) {
                clone.addEncoded(0L, iterator.value());
            }
            return clone;
        }
        HyperLogLogPlusPlus clone = new HyperLogLogPlusPlus(this.precision(), bigArrays, 1L);
        clone.merge(0L, this, bucketOrd);
        return clone;
    }

    private Object getComparableData(long bucketOrd) {
        if (!this.getAlgorithm(bucketOrd)) {
            HashSet<Integer> values = new HashSet<Integer>();
            AbstractLinearCounting.HashesIterator iteratorValues = this.getLinearCounting(bucketOrd);
            while (iteratorValues.next()) {
                values.add(iteratorValues.value());
            }
            return values;
        }
        HashMap<Byte, Integer> values = new HashMap<Byte, Integer>();
        AbstractHyperLogLog.RunLenIterator iterator = this.getHyperLogLog(bucketOrd);
        while (iterator.next()) {
            byte runLength = iterator.value();
            Integer numOccurances = (Integer)values.get(runLength);
            if (numOccurances == null) {
                values.put(runLength, 1);
                continue;
            }
            values.put(runLength, numOccurances + 1);
        }
        return values;
    }

    public void writeTo(long bucket, StreamOutput out) throws IOException {
        out.writeVInt(this.precision());
        if (!this.getAlgorithm(bucket)) {
            out.writeBoolean(false);
            AbstractLinearCounting.HashesIterator hashes = this.getLinearCounting(bucket);
            out.writeVLong(hashes.size());
            while (hashes.next()) {
                out.writeInt(hashes.value());
            }
        } else {
            out.writeBoolean(true);
            AbstractHyperLogLog.RunLenIterator iterator = this.getHyperLogLog(bucket);
            while (iterator.next()) {
                out.writeByte(iterator.value());
            }
        }
    }

    public static AbstractHyperLogLogPlusPlus readFrom(StreamInput in, BigArrays bigArrays) throws IOException {
        int precision = in.readVInt();
        boolean algorithm = in.readBoolean();
        if (!algorithm) {
            long size = in.readVLong();
            HyperLogLogPlusPlusSparse counts = new HyperLogLogPlusPlusSparse(precision, bigArrays, Math.toIntExact(size), 1);
            for (long i = 0L; i < size; ++i) {
                counts.addEncoded(0L, in.readInt());
            }
            return counts;
        }
        HyperLogLogPlusPlus counts = new HyperLogLogPlusPlus(precision, bigArrays, 1L);
        int registers = 1 << precision;
        for (int i = 0; i < registers; ++i) {
            counts.addRunLen(0L, i, in.readByte());
        }
        return counts;
    }

    public boolean equals(long thisBucket, AbstractHyperLogLogPlusPlus other, long otherBucket) {
        return Objects.equals(this.precision(), other.precision()) && Objects.equals(this.getAlgorithm(thisBucket), other.getAlgorithm(otherBucket)) && Objects.equals(this.getComparableData(thisBucket), other.getComparableData(otherBucket));
    }

    public int hashCode(long bucket) {
        return Objects.hash(this.precision(), this.getAlgorithm(bucket), this.getComparableData(bucket));
    }
}

