/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.consumers.ThrowingConsumer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class WithStorageDirective
extends GenericMailet {
    public static final String TARGET_FOLDER_NAME = "targetFolderName";
    private final UsersRepository usersRepository;
    private AttributeValue<String> targetFolderName;

    @Inject
    public WithStorageDirective(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    public void init() throws MessagingException {
        this.targetFolderName = AttributeValue.of((String)this.validateMailetConfiguration(TARGET_FOLDER_NAME));
    }

    private String validateMailetConfiguration(String initParameterName) {
        String initParameterValue = this.getInitParameter(initParameterName);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)initParameterValue) ? 1 : 0) != 0, (String)"You need to specify %s", (Object)initParameterName);
        return initParameterValue;
    }

    public void service(Mail mail) throws MessagingException {
        mail.getRecipients().forEach(this.addStorageDirective(mail));
    }

    public ThrowingConsumer<MailAddress> addStorageDirective(Mail mail) {
        return recipient -> {
            AttributeName attributeNameForUser = AttributeName.of((String)("DeliveryPath_" + this.usersRepository.getUsername(recipient).asString()));
            mail.setAttribute(new Attribute(attributeNameForUser, this.targetFolderName));
        };
    }
}

