/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.commands;

import java.util.List;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.commands.AbstractBodyCommand;
import org.apache.jsieve.exception.CommandException;
import org.apache.jsieve.exception.SieveException;

public abstract class AbstractActionCommand
extends AbstractBodyCommand {
    @Override
    protected void updateState(SieveContext context) {
        super.updateState(context);
        context.getCommandStateManager().setHasActions(true);
        context.getCommandStateManager().setImplicitKeep(false);
    }

    @Override
    protected void validateState(SieveContext context) throws CommandException {
        if (context.getCommandStateManager().isRejected()) {
            throw context.getCoordinate().commandException("Cannot perform Actions on a rejected message.");
        }
    }

    protected void validateSingleStringArguments(Arguments arguments, SieveContext context) throws SieveException {
        List<Argument> args = arguments.getArgumentList();
        if (args.size() != 1) {
            throw context.getCoordinate().syntaxException("Exactly 1 argument permitted. Found " + args.size());
        }
        Argument argument = args.get(0);
        if (!(argument instanceof StringListArgument)) {
            throw context.getCoordinate().syntaxException("Expecting a string-list");
        }
        if (1 != ((StringListArgument)argument).getList().size()) {
            throw context.getCoordinate().syntaxException("Expecting exactly one argument");
        }
    }
}

