/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Circle;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.SloppyMath;

class Circle2D
implements Component2D {
    private final DistanceCalculator calculator;

    private Circle2D(DistanceCalculator calculator) {
        this.calculator = calculator;
    }

    @Override
    public double getMinX() {
        return this.calculator.getMinX();
    }

    @Override
    public double getMaxX() {
        return this.calculator.getMaxX();
    }

    @Override
    public double getMinY() {
        return this.calculator.getMinY();
    }

    @Override
    public double getMaxY() {
        return this.calculator.getMaxY();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.calculator.contains(x, y);
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (this.calculator.within(minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return this.calculator.relate(minX, maxX, minY, maxY);
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.calculator.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.pointInTriangle(minX, maxX, minY, maxY, this.calculator.geX(), this.calculator.getY(), aX, aY, bX, bY, cX, cY) || this.calculator.intersectsLine(aX, aY, bX, bY) || this.calculator.intersectsLine(bX, bY, cX, cY) || this.calculator.intersectsLine(cX, cY, aX, aY);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) && this.contains(bX, bY);
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) && this.contains(bX, bY) && this.contains(cX, cY);
    }

    @Override
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (ab && this.calculator.intersectsLine(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (this.calculator.disjoint(minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.calculator.intersectsLine(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (bc && this.calculator.intersectsLine(bX, bY, cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ca && this.calculator.intersectsLine(cX, cY, aX, aY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.calculator.geX(), this.calculator.getY(), aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    private static boolean intersectsLine(double centerX, double centerY, double aX, double aY, double bX, double bY, DistanceCalculator calculator) {
        double vectorAPX = centerX - aX;
        double vectorABX = bX - aX;
        double vectorAPY = centerY - aY;
        double vectorABY = bY - aY;
        double dotProduct = vectorAPX * vectorABX + vectorAPY * vectorABY;
        double magnitudeAB = vectorABX * vectorABX + vectorABY * vectorABY;
        double distance = dotProduct / magnitudeAB;
        if (distance < 0.0 || distance > dotProduct) {
            return false;
        }
        double pX = aX + vectorABX * distance;
        double pY = aY + vectorABY * distance;
        double minX = StrictMath.min(aX, bX);
        double minY = StrictMath.min(aY, bY);
        double maxX = StrictMath.max(aX, bX);
        double maxY = StrictMath.max(aY, bY);
        if (pX >= minX && pX <= maxX && pY >= minY && pY <= maxY) {
            return calculator.contains(pX, pY);
        }
        return false;
    }

    static Component2D create(XYCircle circle) {
        CartesianDistance calculator = new CartesianDistance(circle.getX(), circle.getY(), circle.getRadius());
        return new Circle2D(calculator);
    }

    static Component2D create(Circle circle) {
        HaversinDistance calculator = new HaversinDistance(circle.getLon(), circle.getLat(), circle.getRadius());
        return new Circle2D(calculator);
    }

    private static class HaversinDistance
    implements DistanceCalculator {
        final double centerLat;
        final double centerLon;
        final double sortKey;
        final double axisLat;
        final Rectangle rectangle;
        final boolean crossesDateline;

        public HaversinDistance(double centerLon, double centerLat, double radius) {
            this.centerLat = centerLat;
            this.centerLon = centerLon;
            this.sortKey = GeoUtils.distanceQuerySortKey(radius);
            this.axisLat = Rectangle.axisLat(centerLat, radius);
            this.rectangle = Rectangle.fromPointDistance(centerLat, centerLon, radius);
            this.crossesDateline = this.rectangle.minLon > this.rectangle.maxLon;
        }

        @Override
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            return GeoUtils.relate(minY, maxY, minX, maxX, this.centerLat, this.centerLon, this.sortKey, this.axisLat);
        }

        @Override
        public boolean contains(double x, double y) {
            if (this.crossesDateline ? Component2D.containsPoint(x, y, this.rectangle.minLon, 180.0, this.rectangle.minLat, this.rectangle.maxLat) || Component2D.containsPoint(x, y, -180.0, this.rectangle.maxLon, this.rectangle.minLat, this.rectangle.maxLat) : Component2D.containsPoint(x, y, this.rectangle.minLon, this.rectangle.maxLon, this.rectangle.minLat, this.rectangle.maxLat)) {
                return SloppyMath.haversinSortKey(y, x, this.centerLat, this.centerLon) <= this.sortKey;
            }
            return false;
        }

        @Override
        public boolean intersectsLine(double aX, double aY, double bX, double bY) {
            if (Circle2D.intersectsLine(this.centerLon, this.centerLat, aX, aY, bX, bY, this)) {
                return true;
            }
            if (this.crossesDateline) {
                double newCenterLon = this.centerLon > 0.0 ? this.centerLon - 360.0 : this.centerLon + 360.0;
                return Circle2D.intersectsLine(newCenterLon, this.centerLat, aX, aY, bX, bY, this);
            }
            return false;
        }

        @Override
        public boolean disjoint(double minX, double maxX, double minY, double maxY) {
            if (this.crossesDateline) {
                return Component2D.disjoint(this.rectangle.minLon, 180.0, this.rectangle.minLat, this.rectangle.maxLat, minX, maxX, minY, maxY) && Component2D.disjoint(-180.0, this.rectangle.maxLon, this.rectangle.minLat, this.rectangle.maxLat, minX, maxX, minY, maxY);
            }
            return Component2D.disjoint(this.rectangle.minLon, this.rectangle.maxLon, this.rectangle.minLat, this.rectangle.maxLat, minX, maxX, minY, maxY);
        }

        @Override
        public boolean within(double minX, double maxX, double minY, double maxY) {
            if (this.crossesDateline) {
                return Component2D.within(this.rectangle.minLon, 180.0, this.rectangle.minLat, this.rectangle.maxLat, minX, maxX, minY, maxY) || Component2D.within(-180.0, this.rectangle.maxLon, this.rectangle.minLat, this.rectangle.maxLat, minX, maxX, minY, maxY);
            }
            return Component2D.within(this.rectangle.minLon, this.rectangle.maxLon, this.rectangle.minLat, this.rectangle.maxLat, minX, maxX, minY, maxY);
        }

        @Override
        public double getMinX() {
            if (this.crossesDateline) {
                return -180.0;
            }
            return this.rectangle.minLon;
        }

        @Override
        public double getMaxX() {
            if (this.crossesDateline) {
                return 180.0;
            }
            return this.rectangle.maxLon;
        }

        @Override
        public double getMinY() {
            return this.rectangle.minLat;
        }

        @Override
        public double getMaxY() {
            return this.rectangle.maxLat;
        }

        @Override
        public double geX() {
            return this.centerLon;
        }

        @Override
        public double getY() {
            return this.centerLat;
        }
    }

    private static class CartesianDistance
    implements DistanceCalculator {
        private final double centerX;
        private final double centerY;
        private final double radiusSquared;
        private final XYRectangle rectangle;

        public CartesianDistance(float centerX, float centerY, float radius) {
            this.centerX = centerX;
            this.centerY = centerY;
            this.rectangle = XYRectangle.fromPointDistance(centerX, centerY, radius);
            this.radiusSquared = (double)radius * (double)radius;
        }

        @Override
        public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
            if (Component2D.containsPoint(this.centerX, this.centerY, minX, maxX, minY, maxY)) {
                if (this.contains(minX, minY) && this.contains(maxX, minY) && this.contains(maxX, maxY) && this.contains(minX, maxY)) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            } else {
                double diff;
                double sumOfSquaredDiffs = 0.0;
                if (this.centerX < minX) {
                    diff = minX - this.centerX;
                    sumOfSquaredDiffs += diff * diff;
                } else if (this.centerX > maxX) {
                    diff = maxX - this.centerX;
                    sumOfSquaredDiffs += diff * diff;
                }
                if (this.centerY < minY) {
                    diff = minY - this.centerY;
                    sumOfSquaredDiffs += diff * diff;
                } else if (this.centerY > maxY) {
                    diff = maxY - this.centerY;
                    sumOfSquaredDiffs += diff * diff;
                }
                if (sumOfSquaredDiffs > this.radiusSquared) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        @Override
        public boolean contains(double x, double y) {
            if (Component2D.containsPoint(x, y, this.rectangle.minX, this.rectangle.maxX, this.rectangle.minY, this.rectangle.maxY)) {
                double diffX = x - this.centerX;
                double diffY = y - this.centerY;
                return diffX * diffX + diffY * diffY <= this.radiusSquared;
            }
            return false;
        }

        @Override
        public boolean intersectsLine(double aX, double aY, double bX, double bY) {
            return Circle2D.intersectsLine(this.centerX, this.centerY, aX, aY, bX, bY, this);
        }

        @Override
        public boolean disjoint(double minX, double maxX, double minY, double maxY) {
            return Component2D.disjoint(this.rectangle.minX, this.rectangle.maxX, this.rectangle.minY, this.rectangle.maxY, minX, maxX, minY, maxY);
        }

        @Override
        public boolean within(double minX, double maxX, double minY, double maxY) {
            return Component2D.within(this.rectangle.minX, this.rectangle.maxX, this.rectangle.minY, this.rectangle.maxY, minX, maxX, minY, maxY);
        }

        @Override
        public double getMinX() {
            return this.rectangle.minX;
        }

        @Override
        public double getMaxX() {
            return this.rectangle.maxX;
        }

        @Override
        public double getMinY() {
            return this.rectangle.minY;
        }

        @Override
        public double getMaxY() {
            return this.rectangle.maxY;
        }

        @Override
        public double geX() {
            return this.centerX;
        }

        @Override
        public double getY() {
            return this.centerY;
        }
    }

    private static interface DistanceCalculator {
        public boolean contains(double var1, double var3);

        public boolean intersectsLine(double var1, double var3, double var5, double var7);

        public PointValues.Relation relate(double var1, double var3, double var5, double var7);

        public boolean disjoint(double var1, double var3, double var5, double var7);

        public boolean within(double var1, double var3, double var5, double var7);

        public double getMinX();

        public double getMaxX();

        public double getMinY();

        public double getMaxY();

        public double geX();

        public double getY();
    }
}

