/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import org.apache.james.mime4j.util.MimeUtil;
import org.junit.Assert;
import org.junit.Test;

public class MimeUtilTest {
    @Test
    public void testFold() {
        Assert.assertEquals((Object)"this\r\n is\r\n a\r\n test", (Object)MimeUtil.fold((String)"this is a test", (int)0, (int)4));
        Assert.assertEquals((Object)"this\r\n is a\r\n test", (Object)MimeUtil.fold((String)"this is a test", (int)0, (int)5));
        Assert.assertEquals((Object)"this\r\n is\r\n a\r\n test", (Object)MimeUtil.fold((String)"this is a test", (int)1, (int)4));
    }

    @Test
    public void testFoldWithDefaultMaxCharacters() {
        Assert.assertEquals((Object)"this is\r\n a test", (Object)MimeUtil.fold((String)"this is a test", (int)68));
        Assert.assertEquals((Object)"this is\r\n a test", (Object)MimeUtil.fold((String)"this is a test", (int)69));
        Assert.assertEquals((Object)"this\r\n is a test", (Object)MimeUtil.fold((String)"this is a test", (int)70));
        Assert.assertEquals((Object)"this  \r\n   is a test", (Object)MimeUtil.fold((String)"this     is a test", (int)70));
    }

    @Test
    public void testFoldOverlyLongNonWhitespace() throws Exception {
        String ninety = "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        String input = String.format("testing 1 2 %s testing %s", ninety, ninety);
        String expected = String.format("testing 1 2\r\n %s\r\n testing\r\n %s", ninety, ninety);
        Assert.assertEquals((Object)expected, (Object)MimeUtil.fold((String)input, (int)0));
    }

    @Test
    public void testUnfold() throws Exception {
        Assert.assertEquals((Object)"", (Object)MimeUtil.unfold((String)""));
        Assert.assertEquals((Object)"x", (Object)MimeUtil.unfold((String)"x"));
        Assert.assertEquals((Object)" x ", (Object)MimeUtil.unfold((String)" x "));
        Assert.assertEquals((Object)"", (Object)MimeUtil.unfold((String)"\r"));
        Assert.assertEquals((Object)"", (Object)MimeUtil.unfold((String)"\n"));
        Assert.assertEquals((Object)"", (Object)MimeUtil.unfold((String)"\r\n"));
        Assert.assertEquals((Object)" ", (Object)MimeUtil.unfold((String)" \n"));
        Assert.assertEquals((Object)" ", (Object)MimeUtil.unfold((String)"\n "));
        Assert.assertEquals((Object)" ", (Object)MimeUtil.unfold((String)" \r\n"));
        Assert.assertEquals((Object)" ", (Object)MimeUtil.unfold((String)"\r\n "));
        Assert.assertEquals((Object)"this is a test", (Object)MimeUtil.unfold((String)"this is\r\n a test"));
        Assert.assertEquals((Object)"this is a test", (Object)MimeUtil.unfold((String)"this is\r\n a test"));
        Assert.assertEquals((Object)"this is a test", (Object)MimeUtil.unfold((String)"this\r\n is a test"));
        Assert.assertEquals((Object)"this     is a test", (Object)MimeUtil.unfold((String)"this  \r\n   is a test"));
        Assert.assertEquals((Object)"this is a test", (Object)MimeUtil.unfold((String)"this\r\n is\r\n a\r\n test"));
    }
}

