/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryUpdateRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=698");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=700");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=699");
    private final RequestHeader requestHeader;
    private final ExtensionObject[] historyUpdateDetails;

    public HistoryUpdateRequest(RequestHeader requestHeader, ExtensionObject[] historyUpdateDetails) {
        this.requestHeader = requestHeader;
        this.historyUpdateDetails = historyUpdateDetails;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject[] getHistoryUpdateDetails() {
        return this.historyUpdateDetails;
    }

    protected HistoryUpdateRequest(HistoryUpdateRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((HistoryUpdateRequestBuilder)b).requestHeader;
        this.historyUpdateDetails = ((HistoryUpdateRequestBuilder)b).historyUpdateDetails;
    }

    public static HistoryUpdateRequestBuilder<?, ?> builder() {
        return new HistoryUpdateRequestBuilderImpl();
    }

    public HistoryUpdateRequestBuilder<?, ?> toBuilder() {
        return new HistoryUpdateRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryUpdateRequest)) {
            return false;
        }
        HistoryUpdateRequest other = (HistoryUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getHistoryUpdateDetails(), other.getHistoryUpdateDetails());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryUpdateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getHistoryUpdateDetails());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryUpdateRequest(requestHeader=" + this.getRequestHeader() + ", historyUpdateDetails=" + Arrays.deepToString(this.getHistoryUpdateDetails()) + ")";
    }

    private static final class HistoryUpdateRequestBuilderImpl
    extends HistoryUpdateRequestBuilder<HistoryUpdateRequest, HistoryUpdateRequestBuilderImpl> {
        private HistoryUpdateRequestBuilderImpl() {
        }

        @Override
        protected HistoryUpdateRequestBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryUpdateRequest build() {
            return new HistoryUpdateRequest(this);
        }
    }

    public static abstract class HistoryUpdateRequestBuilder<C extends HistoryUpdateRequest, B extends HistoryUpdateRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private ExtensionObject[] historyUpdateDetails;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryUpdateRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryUpdateRequest instance, HistoryUpdateRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.historyUpdateDetails(instance.historyUpdateDetails);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B historyUpdateDetails(ExtensionObject[] historyUpdateDetails) {
            this.historyUpdateDetails = historyUpdateDetails;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryUpdateRequest.HistoryUpdateRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", historyUpdateDetails=" + Arrays.deepToString(this.historyUpdateDetails) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryUpdateRequest> {
        @Override
        public Class<HistoryUpdateRequest> getType() {
            return HistoryUpdateRequest.class;
        }

        @Override
        public HistoryUpdateRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ExtensionObject[] historyUpdateDetails = decoder.readExtensionObjectArray("HistoryUpdateDetails");
            return new HistoryUpdateRequest(requestHeader, historyUpdateDetails);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryUpdateRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeExtensionObjectArray("HistoryUpdateDetails", value.getHistoryUpdateDetails());
        }
    }
}

