/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.mixed;

import io.reactivex.CompletableObserver;
import io.reactivex.MaybeObserver;
import io.reactivex.Notification;
import io.reactivex.SingleObserver;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

@Experimental
public final class MaterializeSingleObserver<T>
implements SingleObserver<T>,
MaybeObserver<T>,
CompletableObserver,
Disposable {
    final SingleObserver<? super Notification<T>> downstream;
    Disposable upstream;

    public MaterializeSingleObserver(SingleObserver<? super Notification<T>> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            this.downstream.onSubscribe(this);
        }
    }

    @Override
    public void onComplete() {
        this.downstream.onSuccess(Notification.createOnComplete());
    }

    @Override
    public void onSuccess(T t) {
        this.downstream.onSuccess(Notification.createOnNext(t));
    }

    @Override
    public void onError(Throwable e) {
        this.downstream.onSuccess(Notification.createOnError(e));
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }
}

